/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.util.StateTtlConfigUtil;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.Preconditions;

public final class JoinRecordStateViews {
    public static JoinRecordStateView create(RuntimeContext ctx, String stateName, JoinInputSideSpec inputSideSpec, RowDataTypeInfo recordType, long retentionTime) {
        StateTtlConfig ttlConfig = StateTtlConfigUtil.createTtlConfig(retentionTime);
        if (inputSideSpec.hasUniqueKey()) {
            if (inputSideSpec.joinKeyContainsUniqueKey()) {
                return new JoinKeyContainsUniqueKey(ctx, stateName, recordType, ttlConfig);
            }
            return new InputSideHasUniqueKey(ctx, stateName, recordType, inputSideSpec.getUniqueKeyType(), inputSideSpec.getUniqueKeySelector(), ttlConfig);
        }
        return new InputSideHasNoUniqueKey(ctx, stateName, recordType, ttlConfig);
    }

    private static final class InputSideHasNoUniqueKey
    implements JoinRecordStateView {
        private final MapState<RowData, Integer> recordState;

        private InputSideHasNoUniqueKey(RuntimeContext ctx, String stateName, RowDataTypeInfo recordType, StateTtlConfig ttlConfig) {
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, (TypeInformation)recordType, Types.INT);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
        }

        @Override
        public void addRecord(RowData record) throws Exception {
            Integer cnt = (Integer)this.recordState.get((Object)record);
            cnt = cnt != null ? Integer.valueOf(cnt + 1) : Integer.valueOf(1);
            this.recordState.put((Object)record, (Object)cnt);
        }

        @Override
        public void retractRecord(RowData record) throws Exception {
            Integer cnt = (Integer)this.recordState.get((Object)record);
            if (cnt != null) {
                if (cnt > 1) {
                    this.recordState.put((Object)record, (Object)(cnt - 1));
                } else {
                    this.recordState.remove((Object)record);
                }
            }
        }

        @Override
        public Iterable<RowData> getRecords() throws Exception {
            return new IterableIterator<RowData>(){
                private final Iterator<Map.Entry<RowData, Integer>> backingIterable;
                private RowData record;
                private int remainingTimes;
                {
                    this.backingIterable = recordState.entries().iterator();
                    this.remainingTimes = 0;
                }

                public boolean hasNext() {
                    return this.backingIterable.hasNext() || this.remainingTimes > 0;
                }

                public RowData next() {
                    if (this.remainingTimes > 0) {
                        Preconditions.checkNotNull((Object)this.record);
                        --this.remainingTimes;
                        return this.record;
                    }
                    Map.Entry<RowData, Integer> entry = this.backingIterable.next();
                    this.record = entry.getKey();
                    this.remainingTimes = entry.getValue() - 1;
                    return this.record;
                }

                public Iterator<RowData> iterator() {
                    return this;
                }
            };
        }
    }

    private static final class InputSideHasUniqueKey
    implements JoinRecordStateView {
        private final MapState<RowData, RowData> recordState;
        private final KeySelector<RowData, RowData> uniqueKeySelector;

        private InputSideHasUniqueKey(RuntimeContext ctx, String stateName, RowDataTypeInfo recordType, RowDataTypeInfo uniqueKeyType, KeySelector<RowData, RowData> uniqueKeySelector, StateTtlConfig ttlConfig) {
            Preconditions.checkNotNull((Object)((Object)uniqueKeyType));
            Preconditions.checkNotNull(uniqueKeySelector);
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, (TypeInformation)uniqueKeyType, (TypeInformation)recordType);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
            this.uniqueKeySelector = uniqueKeySelector;
        }

        @Override
        public void addRecord(RowData record) throws Exception {
            RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
            this.recordState.put((Object)uniqueKey, (Object)record);
        }

        @Override
        public void retractRecord(RowData record) throws Exception {
            RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
            this.recordState.remove((Object)uniqueKey);
        }

        @Override
        public Iterable<RowData> getRecords() throws Exception {
            return this.recordState.values();
        }
    }

    private static final class JoinKeyContainsUniqueKey
    implements JoinRecordStateView {
        private final ValueState<RowData> recordState;
        private final List<RowData> reusedList;

        private JoinKeyContainsUniqueKey(RuntimeContext ctx, String stateName, RowDataTypeInfo recordType, StateTtlConfig ttlConfig) {
            ValueStateDescriptor recordStateDesc = new ValueStateDescriptor(stateName, (TypeInformation)recordType);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getState(recordStateDesc);
            this.reusedList = new ArrayList<RowData>(1);
        }

        @Override
        public void addRecord(RowData record) throws Exception {
            this.recordState.update((Object)record);
        }

        @Override
        public void retractRecord(RowData record) throws Exception {
            this.recordState.clear();
        }

        @Override
        public Iterable<RowData> getRecords() throws Exception {
            this.reusedList.clear();
            RowData record = (RowData)this.recordState.value();
            if (record != null) {
                this.reusedList.add(record);
            }
            return this.reusedList;
        }
    }
}

