/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.JoinedRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.AbstractStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateViews;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.types.RowKind;

public class StreamingJoinOperator
extends AbstractStreamingJoinOperator {
    private static final long serialVersionUID = -376944622236540545L;
    private final boolean leftIsOuter;
    private final boolean rightIsOuter;
    private transient JoinedRowData outRow;
    private transient RowData leftNullRow;
    private transient RowData rightNullRow;
    private transient JoinRecordStateView leftRecordStateView;
    private transient JoinRecordStateView rightRecordStateView;

    public StreamingJoinOperator(RowDataTypeInfo leftType, RowDataTypeInfo rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean leftIsOuter, boolean rightIsOuter, boolean[] filterNullKeys, long minRetentionTime) {
        super(leftType, rightType, generatedJoinCondition, leftInputSideSpec, rightInputSideSpec, filterNullKeys, minRetentionTime);
        this.leftIsOuter = leftIsOuter;
        this.rightIsOuter = rightIsOuter;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.outRow = new JoinedRowData();
        this.leftNullRow = new GenericRowData(this.leftType.getArity());
        this.rightNullRow = new GenericRowData(this.rightType.getArity());
        this.leftRecordStateView = this.leftIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.minRetentionTime) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.minRetentionTime);
        this.rightRecordStateView = this.rightIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.minRetentionTime) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.minRetentionTime);
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.processElement((RowData)element.getValue(), this.leftRecordStateView, this.rightRecordStateView, true);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.processElement((RowData)element.getValue(), this.rightRecordStateView, this.leftRecordStateView, false);
    }

    private void processElement(RowData input, JoinRecordStateView inputSideStateView, JoinRecordStateView otherSideStateView, boolean inputIsLeft) throws Exception {
        block19: {
            AbstractStreamingJoinOperator.AssociatedRecords associatedRecords;
            RowKind inputRowKind;
            boolean otherIsOuter;
            boolean inputIsOuter;
            block20: {
                block17: {
                    block18: {
                        inputIsOuter = inputIsLeft ? this.leftIsOuter : this.rightIsOuter;
                        otherIsOuter = inputIsLeft ? this.rightIsOuter : this.leftIsOuter;
                        boolean isAccumulateMsg = RowDataUtil.isAccumulateMsg(input);
                        inputRowKind = input.getRowKind();
                        input.setRowKind(RowKind.INSERT);
                        associatedRecords = AbstractStreamingJoinOperator.AssociatedRecords.of(input, inputIsLeft, otherSideStateView, this.joinCondition);
                        if (!isAccumulateMsg) break block17;
                        if (!inputIsOuter) break block18;
                        OuterJoinRecordStateView inputSideOuterStateView = (OuterJoinRecordStateView)inputSideStateView;
                        if (associatedRecords.isEmpty()) {
                            this.outRow.setRowKind(RowKind.INSERT);
                            this.outputNullPadding(input, inputIsLeft);
                            inputSideOuterStateView.addRecord(input, 0);
                        } else {
                            if (otherIsOuter) {
                                OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                                for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                                    RowData other = outerRecord.record;
                                    if (outerRecord.numOfAssociations == 0) {
                                        this.outRow.setRowKind(RowKind.DELETE);
                                        this.outputNullPadding(other, !inputIsLeft);
                                    }
                                    otherSideOuterStateView.updateNumOfAssociations(other, outerRecord.numOfAssociations + 1);
                                }
                            }
                            this.outRow.setRowKind(RowKind.INSERT);
                            for (RowData other : associatedRecords.getRecords()) {
                                this.output(input, other, inputIsLeft);
                            }
                            inputSideOuterStateView.addRecord(input, associatedRecords.size());
                        }
                        break block19;
                    }
                    inputSideStateView.addRecord(input);
                    if (associatedRecords.isEmpty()) break block19;
                    if (otherIsOuter) {
                        OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                        for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                            if (outerRecord.numOfAssociations == 0) {
                                this.outRow.setRowKind(RowKind.DELETE);
                                this.outputNullPadding(outerRecord.record, !inputIsLeft);
                            }
                            otherSideOuterStateView.updateNumOfAssociations(outerRecord.record, outerRecord.numOfAssociations + 1);
                        }
                        this.outRow.setRowKind(RowKind.INSERT);
                    } else {
                        this.outRow.setRowKind(inputRowKind);
                    }
                    for (RowData other : associatedRecords.getRecords()) {
                        this.output(input, other, inputIsLeft);
                    }
                    break block19;
                }
                inputSideStateView.retractRecord(input);
                if (!associatedRecords.isEmpty()) break block20;
                if (!inputIsOuter) break block19;
                this.outRow.setRowKind(RowKind.DELETE);
                this.outputNullPadding(input, inputIsLeft);
                break block19;
            }
            if (inputIsOuter) {
                this.outRow.setRowKind(RowKind.DELETE);
            } else {
                this.outRow.setRowKind(inputRowKind);
            }
            for (RowData other : associatedRecords.getRecords()) {
                this.output(input, other, inputIsLeft);
            }
            if (otherIsOuter) {
                OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                    if (outerRecord.numOfAssociations == 1) {
                        this.outRow.setRowKind(RowKind.INSERT);
                        this.outputNullPadding(outerRecord.record, !inputIsLeft);
                    }
                    otherSideOuterStateView.updateNumOfAssociations(outerRecord.record, outerRecord.numOfAssociations - 1);
                }
            }
        }
    }

    private void output(RowData inputRow, RowData otherRow, boolean inputIsLeft) {
        if (inputIsLeft) {
            this.outRow.replace(inputRow, otherRow);
        } else {
            this.outRow.replace(otherRow, inputRow);
        }
        this.collector.collect((Object)this.outRow);
    }

    private void outputNullPadding(RowData row, boolean isLeft) {
        if (isLeft) {
            this.outRow.replace(row, this.rightNullRow);
        } else {
            this.outRow.replace(this.leftNullRow, row);
        }
        this.collector.collect((Object)this.outRow);
    }
}

