/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.util.StateTtlConfigUtil;
import org.apache.flink.util.Collector;

public class MiniBatchDeduplicateKeepLastRowFunction
extends MapBundleFunction<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = -8981813609115029119L;
    private final RowDataTypeInfo rowTypeInfo;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final TypeSerializer<RowData> typeSerializer;
    private final long minRetentionTime;
    private ValueState<RowData> state;

    public MiniBatchDeduplicateKeepLastRowFunction(RowDataTypeInfo rowTypeInfo, boolean generateUpdateBefore, boolean generateInsert, TypeSerializer<RowData> typeSerializer, long minRetentionTime) {
        this.minRetentionTime = minRetentionTime;
        this.rowTypeInfo = rowTypeInfo;
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.typeSerializer = typeSerializer;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("preRowState", (TypeInformation)this.rowTypeInfo);
        StateTtlConfig ttlConfig = StateTtlConfigUtil.createTtlConfig(this.minRetentionTime);
        if (ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(ttlConfig);
        }
        this.state = ctx.getRuntimeContext().getState(stateDesc);
    }

    @Override
    public RowData addInput(@Nullable RowData value, RowData input) {
        return (RowData)this.typeSerializer.copy((Object)input);
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData currentRow = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            DeduplicateFunctionHelper.processLastRow(currentRow, this.generateUpdateBefore, this.generateInsert, this.state, out);
        }
    }
}

