/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.util.StateTtlConfigUtil;
import org.apache.flink.util.Collector;

public class MiniBatchDeduplicateKeepFirstRowFunction
extends MapBundleFunction<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = -7994602893547654994L;
    private final TypeSerializer<RowData> typeSerializer;
    private final long minRetentionTime;
    private ValueState<Boolean> state;

    public MiniBatchDeduplicateKeepFirstRowFunction(TypeSerializer<RowData> typeSerializer, long minRetentionTime) {
        this.minRetentionTime = minRetentionTime;
        this.typeSerializer = typeSerializer;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("existsState", Types.BOOLEAN);
        StateTtlConfig ttlConfig = StateTtlConfigUtil.createTtlConfig(this.minRetentionTime);
        if (ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(ttlConfig);
        }
        this.state = ctx.getRuntimeContext().getState(stateDesc);
    }

    @Override
    public RowData addInput(@Nullable RowData value, RowData input) {
        if (value == null) {
            return (RowData)this.typeSerializer.copy((Object)input);
        }
        return value;
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData currentRow = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            DeduplicateFunctionHelper.processFirstRow(currentRow, this.state, out);
        }
    }
}

