/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.util.StateTtlConfigUtil;
import org.apache.flink.util.Collector;

public class DeduplicateKeepLastRowFunction
extends KeyedProcessFunction<RowData, RowData, RowData> {
    private static final long serialVersionUID = -291348892087180350L;
    private final RowDataTypeInfo rowTypeInfo;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final long minRetentionTime;
    private ValueState<RowData> state;

    public DeduplicateKeepLastRowFunction(long minRetentionTime, RowDataTypeInfo rowTypeInfo, boolean generateUpdateBefore, boolean generateInsert) {
        this.minRetentionTime = minRetentionTime;
        this.rowTypeInfo = rowTypeInfo;
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
    }

    public void open(Configuration configure) throws Exception {
        super.open(configure);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("preRowState", (TypeInformation)this.rowTypeInfo);
        StateTtlConfig ttlConfig = StateTtlConfigUtil.createTtlConfig(this.minRetentionTime);
        if (ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(ttlConfig);
        }
        this.state = this.getRuntimeContext().getState(stateDesc);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        DeduplicateFunctionHelper.processLastRow(input, this.generateUpdateBefore, this.generateInsert, this.state, out);
    }
}

