/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.JoinedRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class MiniBatchGlobalGroupAggFunction
extends MapBundleFunction<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 8349579876002001744L;
    private final GeneratedAggsHandleFunction genLocalAggsHandler;
    private final GeneratedAggsHandleFunction genGlobalAggsHandler;
    private final GeneratedRecordEqualiser genRecordEqualiser;
    private final LogicalType[] accTypes;
    private final RecordCounter recordCounter;
    private final boolean generateUpdateBefore;
    private transient JoinedRowData resultRow = new JoinedRowData();
    private transient AggsHandleFunction localAgg = null;
    private transient AggsHandleFunction globalAgg = null;
    private transient RecordEqualiser equaliser = null;
    private transient ValueState<RowData> accState = null;

    public MiniBatchGlobalGroupAggFunction(GeneratedAggsHandleFunction genLocalAggsHandler, GeneratedAggsHandleFunction genGlobalAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore) {
        this.genLocalAggsHandler = genLocalAggsHandler;
        this.genGlobalAggsHandler = genGlobalAggsHandler;
        this.genRecordEqualiser = genRecordEqualiser;
        this.accTypes = accTypes;
        this.recordCounter = RecordCounter.of(indexOfCountStar);
        this.generateUpdateBefore = generateUpdateBefore;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        this.localAgg = (AggsHandleFunction)this.genLocalAggsHandler.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.localAgg.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.globalAgg = (AggsHandleFunction)this.genGlobalAggsHandler.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.globalAgg.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        RowDataTypeInfo accTypeInfo = new RowDataTypeInfo(this.accTypes);
        ValueStateDescriptor accDesc = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = ctx.getRuntimeContext().getState(accDesc);
        this.resultRow = new JoinedRowData();
    }

    @Override
    public RowData addInput(@Nullable RowData previousAcc, RowData input) throws Exception {
        RowData currentAcc = previousAcc == null ? this.localAgg.createAccumulators() : previousAcc;
        this.localAgg.setAccumulators(currentAcc);
        this.localAgg.merge(input);
        return this.localAgg.getAccumulators();
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData bufferAcc = entry.getValue();
            boolean firstRow = false;
            this.ctx.setCurrentKey(currentKey);
            RowData stateAcc = (RowData)this.accState.value();
            if (stateAcc == null) {
                stateAcc = this.globalAgg.createAccumulators();
                firstRow = true;
            }
            this.globalAgg.setAccumulators(stateAcc);
            RowData prevAggValue = this.globalAgg.getValue();
            this.globalAgg.merge(bufferAcc);
            RowData newAggValue = this.globalAgg.getValue();
            stateAcc = this.globalAgg.getAccumulators();
            if (!this.recordCounter.recordCountIsZero(stateAcc)) {
                this.accState.update((Object)stateAcc);
                if (!firstRow) {
                    if (this.equaliser.equals(prevAggValue, newAggValue)) continue;
                    if (this.generateUpdateBefore) {
                        this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.UPDATE_BEFORE);
                        out.collect((Object)this.resultRow);
                    }
                    this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.UPDATE_AFTER);
                    out.collect((Object)this.resultRow);
                    continue;
                }
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.INSERT);
                out.collect((Object)this.resultRow);
                continue;
            }
            if (!firstRow) {
                this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.DELETE);
                out.collect((Object)this.resultRow);
            }
            this.accState.clear();
            this.globalAgg.cleanup();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.localAgg != null) {
            this.localAgg.close();
        }
        if (this.globalAgg != null) {
            this.globalAgg.close();
        }
    }
}

