/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.JoinedRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class GroupAggFunction
extends KeyedProcessFunctionWithCleanupState<RowData, RowData, RowData> {
    private static final long serialVersionUID = -4767158666069797704L;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final GeneratedRecordEqualiser genRecordEqualiser;
    private final LogicalType[] accTypes;
    private final RecordCounter recordCounter;
    private final boolean generateUpdateBefore;
    private transient JoinedRowData resultRow = null;
    private transient AggsHandleFunction function = null;
    private transient RecordEqualiser equaliser = null;
    private transient ValueState<RowData> accState = null;

    public GroupAggFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore) {
        super(minRetentionTime, maxRetentionTime);
        this.genAggsHandler = genAggsHandler;
        this.genRecordEqualiser = genRecordEqualiser;
        this.accTypes = accTypes;
        this.recordCounter = RecordCounter.of(indexOfCountStar);
        this.generateUpdateBefore = generateUpdateBefore;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        RowDataTypeInfo accTypeInfo = new RowDataTypeInfo(this.accTypes);
        ValueStateDescriptor accDesc = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accDesc);
        this.initCleanupTimeState("GroupAggregateCleanupTime");
        this.resultRow = new JoinedRowData();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        boolean firstRow;
        long currentTime = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime);
        RowData currentKey = (RowData)ctx.getCurrentKey();
        RowData accumulators = (RowData)this.accState.value();
        if (null == accumulators) {
            if (RowDataUtil.isRetractMsg(input)) {
                return;
            }
            firstRow = true;
            accumulators = this.function.createAccumulators();
        } else {
            firstRow = false;
        }
        this.function.setAccumulators(accumulators);
        RowData prevAggValue = this.function.getValue();
        if (RowDataUtil.isAccumulateMsg(input)) {
            this.function.accumulate(input);
        } else {
            this.function.retract(input);
        }
        RowData newAggValue = this.function.getValue();
        accumulators = this.function.getAccumulators();
        if (!this.recordCounter.recordCountIsZero(accumulators)) {
            this.accState.update((Object)accumulators);
            if (!firstRow) {
                if (!this.stateCleaningEnabled && this.equaliser.equals(prevAggValue, newAggValue)) {
                    return;
                }
                if (this.generateUpdateBefore) {
                    this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)this.resultRow);
                }
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.UPDATE_AFTER);
            } else {
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.INSERT);
            }
            out.collect((Object)this.resultRow);
        } else {
            if (!firstRow) {
                this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.DELETE);
                out.collect((Object)this.resultRow);
            }
            this.accState.clear();
            this.function.cleanup();
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.accState});
            this.function.cleanup();
        }
    }

    public void close() throws Exception {
        if (this.function != null) {
            this.function.close();
        }
    }
}

