/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesHashMap {
    private static final Logger LOG = LoggerFactory.getLogger(BytesHashMap.class);
    public static final int BUCKET_SIZE = 16;
    public static final int RECORD_EXTRA_LENGTH = 8;
    private static final int BUCKET_SIZE_BITS = 4;
    private static final int ELEMENT_POINT_LENGTH = 8;
    private static final long END_OF_LIST = Long.MAX_VALUE;
    private static final int STEP_INCREMENT = 1;
    private static final double LOAD_FACTOR = 0.75;
    private static final long INIT_BUCKET_MEMORY_IN_BYTES = 0x100000L;
    private final int numBucketsPerSegment;
    private final int numBucketsPerSegmentBits;
    private final int numBucketsPerSegmentMask;
    private final int lastBucketPosition;
    private final int segmentSize;
    private final RecordArea recordArea;
    private final boolean hashSetMode;
    private final BinaryRowDataSerializer valueSerializer;
    private final BinaryRowDataSerializer keySerializer;
    private final LookupInfo reuseLookInfo;
    private BinaryRowData reusedValue;
    private BinaryRowData reusedKey;
    private final LazyMemorySegmentPool memoryPool;
    private List<MemorySegment> bucketSegments;
    private long numElements = 0L;
    private int numBucketsMask;
    private int log2NumBuckets;
    private int numBucketsMask2;
    private int growthThreshold;
    private volatile RecordArea.DestructiveEntryIterator destructiveIterator = null;
    private final int reservedNumBuffers;
    private long numSpillFiles;
    private long spillInBytes;

    public BytesHashMap(Object owner, MemoryManager memoryManager, long memorySize, LogicalType[] keyTypes, LogicalType[] valueTypes) {
        this(owner, memoryManager, memorySize, keyTypes, valueTypes, false);
    }

    public BytesHashMap(Object owner, MemoryManager memoryManager, long memorySize, LogicalType[] keyTypes, LogicalType[] valueTypes, boolean inferBucketMemory) {
        int initBucketSegmentNum;
        this.segmentSize = memoryManager.getPageSize();
        this.reservedNumBuffers = (int)(memorySize / (long)this.segmentSize);
        this.memoryPool = new LazyMemorySegmentPool(owner, memoryManager, this.reservedNumBuffers);
        this.numBucketsPerSegment = this.segmentSize / 16;
        this.numBucketsPerSegmentBits = MathUtils.log2strict((int)this.numBucketsPerSegment);
        this.numBucketsPerSegmentMask = (1 << this.numBucketsPerSegmentBits) - 1;
        this.lastBucketPosition = (this.numBucketsPerSegment - 1) * 16;
        Preconditions.checkArgument((keyTypes.length > 0 ? 1 : 0) != 0);
        this.keySerializer = new BinaryRowDataSerializer(keyTypes.length);
        this.reusedKey = this.keySerializer.createInstance();
        if (valueTypes.length == 0) {
            this.valueSerializer = new BinaryRowDataSerializer(0);
            this.hashSetMode = true;
            this.reusedValue = new BinaryRowData(0);
            this.reusedValue.pointTo(MemorySegmentFactory.wrap((byte[])new byte[8]), 0, 8);
            LOG.info("BytesHashMap with hashSetMode = true.");
        } else {
            this.valueSerializer = new BinaryRowDataSerializer(valueTypes.length);
            this.hashSetMode = false;
            this.reusedValue = this.valueSerializer.createInstance();
        }
        this.reuseLookInfo = new LookupInfo();
        this.recordArea = new RecordArea();
        if (inferBucketMemory) {
            initBucketSegmentNum = this.calcNumBucketSegments(keyTypes, valueTypes);
        } else {
            Preconditions.checkArgument((memorySize > 0x100000L ? 1 : 0) != 0, (Object)"The minBucketMemorySize is not valid!");
            initBucketSegmentNum = MathUtils.roundDownToPowerOf2((int)((int)(0x100000L / (long)this.segmentSize)));
        }
        this.initBucketSegments(initBucketSegmentNum);
        LOG.info("BytesHashMap with initial memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.reservedNumBuffers, this.reservedNumBuffers * this.segmentSize, initBucketSegmentNum});
    }

    static int getVariableLength(LogicalType[] types) {
        int length = 0;
        for (LogicalType type : types) {
            if (BinaryRowData.isInFixedLengthPart(type)) continue;
            length += 16;
        }
        return length;
    }

    private int calcNumBucketSegments(LogicalType[] keyTypes, LogicalType[] valueTypes) {
        double averageBucketSize = 21.333333333333332;
        int calcRecordLength = this.reusedValue.getFixedLengthPartSize() + BytesHashMap.getVariableLength(valueTypes) + this.reusedKey.getFixedLengthPartSize() + BytesHashMap.getVariableLength(keyTypes);
        double fraction = averageBucketSize / (averageBucketSize + (double)calcRecordLength + 8.0);
        int ret = Math.max(1, MathUtils.roundDownToPowerOf2((int)((int)((double)this.reservedNumBuffers * fraction))));
        if ((long)ret * (long)this.numBucketsPerSegment > Integer.MAX_VALUE) {
            ret = MathUtils.roundDownToPowerOf2((int)(Integer.MAX_VALUE / this.numBucketsPerSegment));
        }
        return ret;
    }

    @VisibleForTesting
    boolean isHashSetMode() {
        return this.hashSetMode;
    }

    public LookupInfo lookup(BinaryRowData key) {
        Preconditions.checkArgument((key.getSegments().length == 1 ? 1 : 0) != 0);
        int hashCode1 = key.hashCode();
        int newPos = hashCode1 & this.numBucketsMask;
        int bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
        int bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
        boolean found = false;
        int step = 1;
        long hashCode2 = 0L;
        try {
            long findElementPtr;
            while ((findElementPtr = this.bucketSegments.get(bucketSegmentIndex).getLong(bucketOffset)) != Long.MAX_VALUE) {
                int storedHashCode = this.bucketSegments.get(bucketSegmentIndex).getInt(bucketOffset + 8);
                if (hashCode1 == storedHashCode) {
                    this.recordArea.setReadPosition(findElementPtr);
                    if (this.recordArea.readKeyAndEquals(key)) {
                        found = true;
                        this.reusedValue = this.recordArea.readValue(this.reusedValue);
                        break;
                    }
                }
                if (step == 1) {
                    hashCode2 = this.calcSecondHashCode(hashCode1);
                }
                newPos = (int)((long)hashCode1 + (long)step * hashCode2 & (long)this.numBucketsMask);
                bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
                ++step;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading record from the aggregate map: " + ex.getMessage(), ex);
        }
        this.reuseLookInfo.set(found, hashCode1, key, this.reusedValue, bucketSegmentIndex, bucketOffset);
        return this.reuseLookInfo;
    }

    private long calcSecondHashCode(int firstHashCode) {
        return (((long)(firstHashCode >> this.log2NumBuckets) & (long)this.numBucketsMask2) << 1) + 1L;
    }

    public BinaryRowData append(LookupInfo info, BinaryRowData value) throws IOException {
        try {
            if (this.numElements >= (long)this.growthThreshold) {
                this.growAndRehash();
                this.lookup(info.key);
            }
            BinaryRowData toAppend = this.hashSetMode ? this.reusedValue : value;
            long pointerToAppended = this.recordArea.appendRecord(info.key, toAppend);
            this.bucketSegments.get(info.bucketSegmentIndex).putLong(info.bucketOffset, pointerToAppended);
            this.bucketSegments.get(info.bucketSegmentIndex).putInt(info.bucketOffset + 8, info.keyHashCode);
            ++this.numElements;
            this.recordArea.setReadPosition(pointerToAppended);
            this.recordArea.skipKey();
            return this.recordArea.readValue(this.reusedValue);
        }
        catch (EOFException e) {
            ++this.numSpillFiles;
            this.spillInBytes += (long)this.recordArea.segments.size() * (long)this.segmentSize;
            throw e;
        }
    }

    public long getNumSpillFiles() {
        return this.numSpillFiles;
    }

    public long getUsedMemoryInBytes() {
        return (long)(this.bucketSegments.size() + this.recordArea.segments.size()) * (long)this.segmentSize;
    }

    public long getSpillInBytes() {
        return this.spillInBytes;
    }

    public long getNumElements() {
        return this.numElements;
    }

    private void initBucketSegments(int numBucketSegments) {
        if (numBucketSegments < 1) {
            throw new RuntimeException("Too small memory allocated for BytesHashMap");
        }
        this.bucketSegments = new ArrayList<MemorySegment>(numBucketSegments);
        for (int i = 0; i < numBucketSegments; ++i) {
            this.bucketSegments.add(i, this.memoryPool.nextSegment());
        }
        this.resetBucketSegments(this.bucketSegments);
        int numBuckets = numBucketSegments * this.numBucketsPerSegment;
        this.log2NumBuckets = MathUtils.log2strict((int)numBuckets);
        this.numBucketsMask = (1 << MathUtils.log2strict((int)numBuckets)) - 1;
        this.numBucketsMask2 = (1 << MathUtils.log2strict((int)(numBuckets >> 1))) - 1;
        this.growthThreshold = (int)((double)numBuckets * 0.75);
    }

    private void resetBucketSegments(List<MemorySegment> resetBucketSegs) {
        for (MemorySegment segment : resetBucketSegs) {
            for (int j = 0; j <= this.lastBucketPosition; j += 16) {
                segment.putLong(j, Long.MAX_VALUE);
            }
        }
    }

    private void growAndRehash() throws EOFException {
        int required = 2 * this.bucketSegments.size();
        if ((long)required * (long)this.numBucketsPerSegment > Integer.MAX_VALUE) {
            LOG.warn("We can't handle more than Integer.MAX_VALUE buckets (eg. because hash functions return int)");
            throw new EOFException();
        }
        ArrayList<MemorySegment> newBucketSegments = new ArrayList<MemorySegment>(required);
        try {
            int needNumFromFreeSegments;
            int numAllocatedSegments = required - this.memoryPool.freePages();
            if (numAllocatedSegments > 0) {
                throw new MemoryAllocationException();
            }
            for (int end = needNumFromFreeSegments = required - newBucketSegments.size(); end > 0; --end) {
                newBucketSegments.add(this.memoryPool.nextSegment());
            }
            this.setBucketVariables(newBucketSegments);
        }
        catch (MemoryAllocationException e) {
            LOG.warn("BytesHashMap can't allocate {} pages, and now used {} pages", (Object)required, (Object)this.reservedNumBuffers);
            throw new EOFException();
        }
        long reHashStartTime = System.currentTimeMillis();
        this.resetBucketSegments(newBucketSegments);
        for (MemorySegment memorySegment : this.bucketSegments) {
            for (int j = 0; j < this.numBucketsPerSegment; ++j) {
                long recordPointer = memorySegment.getLong(j * 16);
                if (recordPointer == Long.MAX_VALUE) continue;
                int hashCode1 = memorySegment.getInt(j * 16 + 8);
                int newPos = hashCode1 & this.numBucketsMask;
                int bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                int bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
                int step = 1;
                long hashCode2 = 0L;
                while (((MemorySegment)newBucketSegments.get(bucketSegmentIndex)).getLong(bucketOffset) != Long.MAX_VALUE) {
                    if (step == 1) {
                        hashCode2 = this.calcSecondHashCode(hashCode1);
                    }
                    newPos = (int)((long)hashCode1 + (long)step * hashCode2 & (long)this.numBucketsMask);
                    bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                    bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
                    ++step;
                }
                ((MemorySegment)newBucketSegments.get(bucketSegmentIndex)).putLong(bucketOffset, recordPointer);
                ((MemorySegment)newBucketSegments.get(bucketSegmentIndex)).putInt(bucketOffset + 8, hashCode1);
            }
        }
        LOG.info("The rehash take {} ms for {} segments", (Object)(System.currentTimeMillis() - reHashStartTime), (Object)required);
        this.memoryPool.returnAll(this.bucketSegments);
        this.bucketSegments = newBucketSegments;
    }

    private void setBucketVariables(List<MemorySegment> bucketSegments) {
        int numBuckets = bucketSegments.size() * this.numBucketsPerSegment;
        this.log2NumBuckets = MathUtils.log2strict((int)numBuckets);
        this.numBucketsMask = (1 << MathUtils.log2strict((int)numBuckets)) - 1;
        this.numBucketsMask2 = (1 << MathUtils.log2strict((int)(numBuckets >> 1))) - 1;
        this.growthThreshold = (int)((double)numBuckets * 0.75);
    }

    public MutableObjectIterator<Entry> getEntryIterator() {
        if (this.destructiveIterator != null) {
            throw new IllegalArgumentException("DestructiveIterator is not null, so this method can't be invoke!");
        }
        return this.recordArea.destructiveEntryIterator();
    }

    public ArrayList<MemorySegment> getRecordAreaMemorySegments() {
        return this.recordArea.segments;
    }

    public List<MemorySegment> getBucketAreaMemorySegments() {
        return this.bucketSegments;
    }

    public void free() {
        this.free(false);
    }

    public void free(boolean reservedRecordMemory) {
        this.returnSegments(this.bucketSegments);
        this.bucketSegments.clear();
        this.recordArea.release();
        if (!reservedRecordMemory) {
            this.memoryPool.close();
        }
        this.numElements = 0L;
        this.destructiveIterator = null;
    }

    public void reset() {
        this.setBucketVariables(this.bucketSegments);
        this.recordArea.reset();
        this.resetBucketSegments(this.bucketSegments);
        this.numElements = 0L;
        this.destructiveIterator = null;
        LOG.info("reset BytesHashMap with record memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.memoryPool.freePages(), this.memoryPool.freePages() * this.segmentSize, this.bucketSegments.size()});
    }

    private void returnSegments(List<MemorySegment> segments) {
        this.memoryPool.returnAll(segments);
    }

    public static final class Entry {
        private final BinaryRowData key;
        private final BinaryRowData value;

        public Entry(BinaryRowData key, BinaryRowData value) {
            this.key = key;
            this.value = value;
        }

        public BinaryRowData getKey() {
            return this.key;
        }

        public BinaryRowData getValue() {
            return this.value;
        }
    }

    public static final class LookupInfo {
        private boolean found = false;
        private BinaryRowData key = null;
        private BinaryRowData value = null;
        private int keyHashCode = -1;
        private int bucketSegmentIndex = -1;
        private int bucketOffset = -1;

        LookupInfo() {
        }

        void set(boolean found, int keyHashCode, BinaryRowData key, BinaryRowData value, int bucketSegmentIndex, int bucketOffset) {
            this.found = found;
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
            this.bucketSegmentIndex = bucketSegmentIndex;
            this.bucketOffset = bucketOffset;
        }

        public boolean isFound() {
            return this.found;
        }

        public BinaryRowData getValue() {
            return this.value;
        }
    }

    private final class RecordArea {
        private final ArrayList<MemorySegment> segments = new ArrayList();
        private final RandomAccessInputView inView;
        private final SimpleCollectingOutputView outView;

        RecordArea() {
            this.outView = new SimpleCollectingOutputView(this.segments, (MemorySegmentSource)BytesHashMap.this.memoryPool, BytesHashMap.this.segmentSize);
            this.inView = new RandomAccessInputView(this.segments, BytesHashMap.this.segmentSize);
        }

        void release() {
            BytesHashMap.this.returnSegments(this.segments);
            this.segments.clear();
        }

        void reset() {
            this.release();
            this.outView.reset();
            this.inView.setReadPosition(0L);
        }

        private long appendRecord(BinaryRowData key, BinaryRowData value) throws IOException {
            long oldLastPosition = this.outView.getCurrentOffset();
            int skip = BytesHashMap.this.keySerializer.serializeToPages(key, (AbstractPagedOutputView)this.outView);
            BytesHashMap.this.valueSerializer.serializeToPages(value, (AbstractPagedOutputView)this.outView);
            return oldLastPosition + (long)skip;
        }

        void setReadPosition(long position) {
            this.inView.setReadPosition(position);
        }

        boolean readKeyAndEquals(BinaryRowData lookup) throws IOException {
            BytesHashMap.this.reusedKey = BytesHashMap.this.keySerializer.mapFromPages(BytesHashMap.this.reusedKey, (AbstractPagedInputView)this.inView);
            return lookup.equals(BytesHashMap.this.reusedKey);
        }

        void skipKey() throws IOException {
            this.inView.skipBytes(this.inView.readInt());
        }

        BinaryRowData readValue(BinaryRowData reuse) throws IOException {
            return BytesHashMap.this.valueSerializer.mapFromPages(reuse, (AbstractPagedInputView)this.inView);
        }

        private MutableObjectIterator<Entry> destructiveEntryIterator() {
            return new DestructiveEntryIterator();
        }

        private final class DestructiveEntryIterator
        extends AbstractPagedInputView
        implements MutableObjectIterator<Entry> {
            private int count;
            private int currentSegmentIndex;

            private DestructiveEntryIterator() {
                super((MemorySegment)RecordArea.this.segments.get(0), BytesHashMap.this.segmentSize, 0);
                this.count = 0;
                this.currentSegmentIndex = 0;
                BytesHashMap.this.destructiveIterator = this;
            }

            public boolean hasNext() {
                return (long)this.count < BytesHashMap.this.numElements;
            }

            public Entry next(Entry reuse) throws IOException {
                if (this.hasNext()) {
                    ++this.count;
                    BytesHashMap.this.keySerializer.mapFromPages(reuse.getKey(), (AbstractPagedInputView)this);
                    BytesHashMap.this.valueSerializer.mapFromPages(reuse.getValue(), (AbstractPagedInputView)this);
                    return reuse;
                }
                return null;
            }

            public Entry next() {
                throw new UnsupportedOperationException("");
            }

            protected int getLimitForSegment(MemorySegment segment) {
                return BytesHashMap.this.segmentSize;
            }

            protected MemorySegment nextSegment(MemorySegment current) {
                return (MemorySegment)RecordArea.this.segments.get(++this.currentSegmentIndex);
            }
        }
    }
}

