/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.util.TimestampStringUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001E\u0011ADU3y\u001d>$W\rV8FqB\u0014Xm]:j_:\u001cuN\u001c<feR,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007m\u0001#%D\u0001\u001d\u0015\tib$A\u0002sKbT!a\b\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0011\u0005\b\u0002\u000b%\u0016Dh+[:ji>\u0014\bcA\u0012'Q5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004PaRLwN\u001c\t\u0003S1j\u0011A\u000b\u0006\u0003W!\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011QF\u000b\u0002\u0013%\u0016\u001cx\u000e\u001c<fI\u0016C\bO]3tg&|g\u000e\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003)Ig\u000e];u\u001d\u0006lWm\u001d\t\u0004GE\u001a\u0014B\u0001\u001a%\u0005\u0015\t%O]1z!\t!4H\u0004\u00026sA\u0011a\u0007J\u0007\u0002o)\u0011\u0001\bE\u0001\u0007yI|w\u000e\u001e \n\u0005i\"\u0013A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!A\u000f\u0013\t\u0011}\u0002!\u0011!Q\u0001\n\u0001\u000bqBZ;oGRLwN\\\"bi\u0006dwn\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\"\tqaY1uC2|w-\u0003\u0002F\u0005\nya)\u001e8di&|gnQ1uC2|w\r\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"!Q%\n\u0005)\u0013%AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\u0006AA/[7f5>tW\r\u0005\u0002O#6\tqJ\u0003\u0002Q-\u0005!Q\u000f^5m\u0013\t\u0011vJ\u0001\u0005US6,'l\u001c8f\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019a\u0014N\\5u}Q)a\u000bW-[7B\u0011q\u000bA\u0007\u0002\u0005!)qf\u0015a\u0001a!)qh\u0015a\u0001\u0001\")qi\u0015a\u0001\u0011\")Aj\u0015a\u0001\u001b\")Q\f\u0001C!=\u0006ia/[:ji&s\u0007/\u001e;SK\u001a$\"AI0\t\u000b\u0001d\u0006\u0019A1\u0002\u0011%t\u0007/\u001e;SK\u001a\u0004\"a\u00072\n\u0005\rd\"a\u0003*fq&s\u0007/\u001e;SK\u001aDQ!\u001a\u0001\u0005B\u0019\f!C^5tSR$\u0016M\u00197f\u0013:\u0004X\u000f\u001e*fMR\u0011!e\u001a\u0005\u0006Q\u0012\u0004\r![\u0001\u0011e\u0016DH+\u00192mK&s\u0007/\u001e;SK\u001a\u0004\"a\u00076\n\u0005-d\"\u0001\u0005*fqR\u000b'\r\\3J]B,HOU3g\u0011\u0015i\u0007\u0001\"\u0011o\u000351\u0018n]5u\u0019>\u001c\u0017\r\u001c*fMR\u0011!e\u001c\u0005\u0006a2\u0004\r!]\u0001\tY>\u001c\u0017\r\u001c*fMB\u00111D]\u0005\u0003gr\u00111BU3y\u0019>\u001c\u0017\r\u001c*fM\")Q\u000f\u0001C!m\u0006aa/[:ji2KG/\u001a:bYR\u0011!e\u001e\u0005\u0006qR\u0004\r!_\u0001\bY&$XM]1m!\tY\"0\u0003\u0002|9\tQ!+\u001a=MSR,'/\u00197\t\u000bu\u0004A\u0011\t@\u0002\u0013YL7/\u001b;DC2dGC\u0001\u0012\u0000\u0011\u001d\t\t\u0001 a\u0001\u0003\u0007\tqA]3y\u0007\u0006dG\u000eE\u0002\u001c\u0003\u000bI1!a\u0002\u001d\u0005\u001d\u0011V\r_\"bY2Dq!a\u0003\u0001\t\u0003\ni!\u0001\twSNLGOR5fY\u0012\f5mY3tgR\u0019!%a\u0004\t\u0011\u0005E\u0011\u0011\u0002a\u0001\u0003'\t1BZ5fY\u0012\f5mY3tgB\u00191$!\u0006\n\u0007\u0005]AD\u0001\bSKb4\u0015.\u001a7e\u0003\u000e\u001cWm]:\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u0005\u0019b/[:ji\u000e{'O]3m-\u0006\u0014\u0018.\u00192mKR\u0019!%a\b\t\u0011\u0005\u0005\u0012\u0011\u0004a\u0001\u0003G\tabY8se\u0016dg+\u0019:jC\ndW\rE\u0002\u001c\u0003KI1!a\n\u001d\u0005E\u0011V\r_\"peJ,GNV1sS\u0006\u0014G.\u001a\u0005\b\u0003W\u0001A\u0011IA\u0017\u000351\u0018n]5u%\u0006tw-\u001a*fMR\u0019!%a\f\t\u0011\u0005E\u0012\u0011\u0006a\u0001\u0003g\t\u0001B]1oO\u0016\u0014VM\u001a\t\u00047\u0005U\u0012bAA\u001c9\tY!+\u001a=SC:<WMU3g\u0011\u001d\tY\u0004\u0001C!\u0003{\tQB^5tSR\u001cVOY)vKJLHc\u0001\u0012\u0002@!A\u0011\u0011IA\u001d\u0001\u0004\t\u0019%\u0001\u0005tk\n\fV/\u001a:z!\rY\u0012QI\u0005\u0004\u0003\u000fb\"a\u0003*fqN+(-U;fefDq!a\u0013\u0001\t\u0003\ni%A\twSNLG\u000fR=oC6L7\rU1sC6$2AIA(\u0011!\t\t&!\u0013A\u0002\u0005M\u0013\u0001\u00043z]\u0006l\u0017n\u0019)be\u0006l\u0007cA\u000e\u0002V%\u0019\u0011q\u000b\u000f\u0003\u001fI+\u0007\u0010R=oC6L7\rU1sC6Dq!a\u0017\u0001\t\u0003\ni&A\u0005wSNLGo\u0014<feR\u0019!%a\u0018\t\u0011\u0005\u0005\u0014\u0011\fa\u0001\u0003G\nAa\u001c<feB\u00191$!\u001a\n\u0007\u0005\u001dDDA\u0004SKb|e/\u001a:\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n\u0005!b/[:jiB\u000bG\u000f^3s]\u001aKW\r\u001c3SK\u001a$2AIA8\u0011!\t\t(!\u001bA\u0002\u0005M\u0014\u0001\u00034jK2$'+\u001a4\u0011\u0007m\t)(C\u0002\u0002xq\u0011!CU3y!\u0006$H/\u001a:o\r&,G\u000e\u001a*fM\"9\u00111\u0010\u0001\u0005\n\u0005u\u0014A\u00047p_.,\bOR;oGRLwN\u001c\u000b\bE\u0005}\u0014\u0011RAP\u0011!\t\t)!\u001fA\u0002\u0005\r\u0015AC5eK:$\u0018NZ5feB\u0019\u0011)!\"\n\u0007\u0005\u001d%I\u0001\u000bV]J,7o\u001c7wK\u0012LE-\u001a8uS\u001aLWM\u001d\u0005\t\u0003\u0017\u000bI\b1\u0001\u0002\u000e\u0006Aq\u000e]3sC:$7\u000fE\u0003\u0002\u0010\u0006e\u0005F\u0004\u0003\u0002\u0012\u0006Ueb\u0001\u001c\u0002\u0014&\tQ%C\u0002\u0002\u0018\u0012\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0006u%aA*fc*\u0019\u0011q\u0013\u0013\t\u0011\u0005\u0005\u0016\u0011\u0010a\u0001\u0003G\u000b!b\\;uaV$H+\u001f9f!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAU\u0011\u0005)A/\u001f9fg&!\u0011QVAT\u0005!!\u0015\r^1UsB,\u0007bBAY\u0001\u0011%\u00111W\u0001\be\u0016\u0004H.Y2f)\r\u0019\u0014Q\u0017\u0005\b\u0003o\u000by\u000b1\u00014\u0003\r\u0019HO\u001d")
public class RexNodeToExpressionConverter
implements RexVisitor<Option<ResolvedExpression>> {
    private final String[] inputNames;
    private final FunctionCatalog functionCatalog;
    private final TimeZone timeZone;

    @Override
    public Option<ResolvedExpression> visitInputRef(RexInputRef inputRef) {
        Preconditions.checkArgument((inputRef.getIndex() < this.inputNames.length ? 1 : 0) != 0);
        return new Some((Object)new FieldReferenceExpression(this.inputNames[inputRef.getIndex()], LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(FlinkTypeFactory$.MODULE$.toLogicalType(inputRef.getType())), 0, inputRef.getIndex()));
    }

    @Override
    public Option<ResolvedExpression> visitTableInputRef(RexTableInputRef rexTableInputRef) {
        return this.visitInputRef(rexTableInputRef);
    }

    @Override
    public Option<ResolvedExpression> visitLocalRef(RexLocalRef localRef) {
        throw new TableException("Bug: RexLocalRef should have been expanded");
    }

    @Override
    public Option<ResolvedExpression> visitLiteral(RexLiteral literal) {
        Comparable comparable;
        Comparable comparable2 = literal.getValue();
        if (comparable2 instanceof SqlTrimFunction.Flag) {
            return None$.MODULE$;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        LogicalType literalType = FlinkTypeFactory$.MODULE$.toLogicalType(literal.getType());
        LogicalTypeRoot logicalTypeRoot = literalType.getTypeRoot();
        if (((Object)((Object)LogicalTypeRoot.DATE)).equals((Object)logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            comparable = (Comparable)DataFormatConverters.LocalDateConverter.INSTANCE.toExternal(v);
        } else if (((Object)((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE)).equals((Object)logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            comparable = (Comparable)DataFormatConverters.LocalTimeConverter.INSTANCE.toExternal(v);
        } else if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)).equals((Object)logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            comparable = TimestampStringUtils.toLocalDateTime(v);
        } else if (((Object)((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            comparable = TimestampStringUtils.toLocalDateTime(v).atZone(this.timeZone.toZoneId()).toInstant();
        } else {
            boolean bl;
            comparable = ((Object)((Object)LogicalTypeRoot.TINYINT)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Byte.class) : (((Object)((Object)LogicalTypeRoot.SMALLINT)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Short.class) : (((Object)((Object)LogicalTypeRoot.INTEGER)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Integer.class) : (((Object)((Object)LogicalTypeRoot.BIGINT)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Long.class) : (((Object)((Object)LogicalTypeRoot.FLOAT)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Float.class) : (((Object)((Object)LogicalTypeRoot.DOUBLE)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Double.class) : ((bl = ((Object)((Object)LogicalTypeRoot.VARCHAR)).equals((Object)logicalTypeRoot) ? true : ((Object)((Object)LogicalTypeRoot.CHAR)).equals((Object)logicalTypeRoot)) ? (Comparable)((Object)literal.getValueAs(String.class)) : (((Object)((Object)LogicalTypeRoot.BOOLEAN)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(Boolean.class) : (((Object)((Object)LogicalTypeRoot.DECIMAL)).equals((Object)logicalTypeRoot) ? (Comparable)literal.getValueAs(BigDecimal.class) : literal.getValue()))))))));
        }
        Comparable literalValue = comparable;
        return new Some((Object)ApiExpressionUtils.valueLiteral(literalValue, (DataType)LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(literalType).notNull()));
    }

    @Override
    public Option<ResolvedExpression> visitCall(RexCall rexCall) {
        None$ none$;
        Buffer operands = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)operand -> (ResolvedExpression)operand.accept(this).orNull(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom());
        DataType outputType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(FlinkTypeFactory$.MODULE$.toLogicalType(rexCall.getType()));
        if (operands.contains(null)) {
            none$ = None$.MODULE$;
        } else {
            Option<ResolvedExpression> option;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.OR;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
                option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> new CallExpression(BuiltInFunctionDefinitions.OR, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{l, r}))), outputType)));
            } else {
                SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.AND;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> new CallExpression(BuiltInFunctionDefinitions.AND, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{l, r}))), outputType)));
                } else {
                    SqlFunction sqlFunction = SqlStdOperatorTable.CAST;
                    SqlOperator sqlOperator4 = sqlOperator;
                    if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator4) : sqlOperator4 != null)) {
                        option = Option$.MODULE$.apply((Object)new CallExpression(BuiltInFunctionDefinitions.CAST, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)operands.head(), ApiExpressionUtils.typeLiteral(outputType)}))), outputType));
                    } else {
                        boolean bl = sqlOperator instanceof SqlFunction ? true : sqlOperator instanceof SqlPostfixOperator;
                        if (bl) {
                            ArrayList<String> names = new ArrayList<String>(rexCall.getOperator().getNameAsId().names);
                            names.set(names.size() - 1, this.replace(names.get(names.size() - 1)));
                            UnresolvedIdentifier id = UnresolvedIdentifier.of((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(names).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
                            option = this.lookupFunction(id, (Seq<ResolvedExpression>)operands, outputType);
                        } else {
                            option = this.lookupFunction(UnresolvedIdentifier.of(this.replace(String.valueOf((Object)sqlOperator.getKind()))), (Seq<ResolvedExpression>)operands, outputType);
                        }
                    }
                }
            }
            none$ = option;
        }
        return none$;
    }

    @Override
    public Option<ResolvedExpression> visitFieldAccess(RexFieldAccess fieldAccess) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitCorrelVariable(RexCorrelVariable correlVariable) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitRangeRef(RexRangeRef rangeRef) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitSubQuery(RexSubQuery subQuery) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitDynamicParam(RexDynamicParam dynamicParam) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitOver(RexOver over) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return None$.MODULE$;
    }

    private Option<ResolvedExpression> lookupFunction(UnresolvedIdentifier identifier, Seq<ResolvedExpression> operands, DataType outputType) {
        None$ none$;
        Success success;
        Optional f;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.functionCatalog.lookupFunction(identifier));
        if (try_ instanceof Success && (f = (Optional)(success = (Success)try_).value()) != null) {
            Optional optional = f;
            none$ = optional.isPresent() ? new Some((Object)new CallExpression(((FunctionLookup.Result)optional.get()).getFunctionDefinition(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(operands), outputType)) : None$.MODULE$;
        } else if (try_ instanceof Failure) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private String replace(String str) {
        return str.replaceAll("\\s|_", "");
    }

    public RexNodeToExpressionConverter(String[] inputNames, FunctionCatalog functionCatalog, CatalogManager catalogManager, TimeZone timeZone) {
        this.inputNames = inputNames;
        this.functionCatalog = functionCatalog;
        this.timeZone = timeZone;
    }
}

