/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.keyselector.BinaryRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.EmptyRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class KeySelectorUtil {
    public static RowDataKeySelector getRowDataSelector(int[] keyFields, RowDataTypeInfo rowType) {
        if (keyFields.length > 0) {
            LogicalType[] inputFieldTypes = rowType.getLogicalTypes();
            LogicalType[] keyFieldTypes = new LogicalType[keyFields.length];
            for (int i = 0; i < keyFields.length; ++i) {
                keyFieldTypes[i] = inputFieldTypes[keyFields[i]];
            }
            RowType returnType = RowType.of(keyFieldTypes);
            RowType inputType = rowType.toRowType();
            GeneratedProjection generatedProjection = ProjectionCodeGenerator.generateProjection(CodeGeneratorContext.apply(new TableConfig()), "KeyProjection", inputType, returnType, keyFields);
            RowDataTypeInfo keyRowType = RowDataTypeInfo.of(returnType);
            return new BinaryRowDataKeySelector(keyRowType, generatedProjection);
        }
        return EmptyRowDataKeySelector.INSTANCE;
    }
}

