/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.plan.utils.BooleanExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.ByteExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.DoubleExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.FloatExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.IntExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.LongExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.MapExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.ObjectExplodeTableFunc;
import org.apache.flink.table.planner.plan.utils.ShortExplodeTableFunc;

public final class ExplodeFunctionUtil$ {
    public static ExplodeFunctionUtil$ MODULE$;

    static {
        new ExplodeFunctionUtil$();
    }

    public TableFunction<?> explodeTableFuncFromType(TypeInformation<?> ti) {
        TableFunction tableFunction;
        TypeInformation<?> typeInformation = ti;
        if (typeInformation instanceof PrimitiveArrayTypeInfo) {
            PrimitiveArrayTypeInfo primitiveArrayTypeInfo = (PrimitiveArrayTypeInfo)typeInformation;
            tableFunction = this.createTableFuncByType(primitiveArrayTypeInfo.getComponentType());
        } else if (typeInformation instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInformation;
            tableFunction = new ObjectExplodeTableFunc(objectArrayTypeInfo.getComponentInfo());
        } else if (typeInformation instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo basicArrayTypeInfo = (BasicArrayTypeInfo)typeInformation;
            tableFunction = new ObjectExplodeTableFunc(basicArrayTypeInfo.getComponentInfo());
        } else if (typeInformation instanceof MultisetTypeInfo) {
            MultisetTypeInfo multisetTypeInfo = (MultisetTypeInfo)typeInformation;
            tableFunction = this.createTableFuncByType(multisetTypeInfo.getElementTypeInfo());
        } else if (typeInformation instanceof MapTypeInfo) {
            tableFunction = new MapExplodeTableFunc();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(17).append(ti.toString()).append(" IS NOT supported").toString());
        }
        return tableFunction;
    }

    public TableFunction<?> createTableFuncByType(TypeInformation<?> typeInfo) {
        TableFunction tableFunction;
        TypeInformation<?> typeInformation = typeInfo;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
            tableFunction = new IntExplodeTableFunc();
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.LONG_TYPE_INFO;
            TypeInformation<?> typeInformation3 = typeInformation;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                tableFunction = new LongExplodeTableFunc();
            } else {
                BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.SHORT_TYPE_INFO;
                TypeInformation<?> typeInformation4 = typeInformation;
                if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(typeInformation4) : typeInformation4 != null)) {
                    tableFunction = new ShortExplodeTableFunc();
                } else {
                    BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.FLOAT_TYPE_INFO;
                    TypeInformation<?> typeInformation5 = typeInformation;
                    if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(typeInformation5) : typeInformation5 != null)) {
                        tableFunction = new FloatExplodeTableFunc();
                    } else {
                        BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                        TypeInformation<?> typeInformation6 = typeInformation;
                        if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(typeInformation6) : typeInformation6 != null)) {
                            tableFunction = new DoubleExplodeTableFunc();
                        } else {
                            BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.BYTE_TYPE_INFO;
                            TypeInformation<?> typeInformation7 = typeInformation;
                            if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(typeInformation7) : typeInformation7 != null)) {
                                tableFunction = new ByteExplodeTableFunc();
                            } else {
                                BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                                TypeInformation<?> typeInformation8 = typeInformation;
                                tableFunction = !(basicTypeInfo7 != null ? !basicTypeInfo7.equals(typeInformation8) : typeInformation8 != null) ? new BooleanExplodeTableFunc() : new ObjectExplodeTableFunc(typeInfo);
                            }
                        }
                    }
                }
            }
        }
        return tableFunction;
    }

    private ExplodeFunctionUtil$() {
        MODULE$ = this;
    }
}

