/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001'\t9\u0003+^:i\r&dG/\u001a:J]R|G*Z4bGf$\u0016M\u00197f'>,(oY3TG\u0006t'+\u001e7f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001635\taC\u0003\u0002\b/)\u0011\u0001DD\u0001\bG\u0006d7-\u001b;f\u0013\tQbC\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b\u0005\u0002A\u0011\t\u0012\u0002\u000f5\fGo\u00195fgR\u00111%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0003\u00051\u0001,\u0003\u0011\u0019\u0017\r\u001c7\u0011\u0005Ua\u0013BA\u0017\u0017\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQa\f\u0001\u0005BA\nqa\u001c8NCR\u001c\u0007\u000e\u0006\u00022iA\u0011AEM\u0005\u0003g\u0015\u0012A!\u00168ji\")!F\fa\u0001W!)a\u0007\u0001C\u0005o\u0005\u0011\u0002/^:i\r&dG/\u001a:J]R|7kY1o)\u0015\t\u0004(O\"K\u0011\u0015QS\u00071\u0001,\u0011\u0015QT\u00071\u0001<\u0003\u00191\u0017\u000e\u001c;feB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005G>\u0014XM\u0003\u0002A/\u0005\u0019!/\u001a7\n\u0005\tk$A\u0002$jYR,'\u000fC\u0003Ek\u0001\u0007Q)\u0001\u0003tG\u0006t\u0007C\u0001$I\u001b\u00059%BA\u0002@\u0013\tIuI\u0001\tM_\u001eL7-\u00197UC\ndWmU2b]\")1*\u000ea\u0001\u0019\u0006Y!/\u001a7PaR$\u0016M\u00197f!\ti\u0005+D\u0001O\u0015\tye!\u0001\u0004tG\",W.Y\u0005\u0003#:\u0013qC\u00127j].\u0004&/\u001a9be&tw\rV1cY\u0016\u0014\u0015m]3\t\u000bM\u0003A\u0011\u0002+\u0002\u001d\u0005\u0004\b\u000f\\=Qe\u0016$\u0017nY1uKR!A*V3g\u0011\u00151&\u000b1\u0001X\u0003)\u0001(/\u001a3jG\u0006$Xm\u001d\t\u00041v{V\"A-\u000b\u0005i[\u0016\u0001B;uS2T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\n!A*[:u!\t\u00017-D\u0001b\u0015\t\u0011'\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u00013b\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006\u0017J\u0003\r\u0001\u0014\u0005\u0006OJ\u0003\r\u0001[\u0001\fif\u0004XMR1di>\u0014\u0018\u0010\u0005\u0002jY6\t!N\u0003\u0002l\u007f\u0005!A/\u001f9f\u0013\ti'N\u0001\nSK2$\u0015\r^1UsB,g)Y2u_JLx!B8\u0003\u0011\u0003\u0001\u0018a\n)vg\"4\u0015\u000e\u001c;fe&sGo\u001c'fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016\u0004\"aH9\u0007\u000b\u0005\u0011\u0001\u0012\u0001:\u0014\u0005E\u001c\bC\u0001\u0013u\u0013\t)XE\u0001\u0004B]f\u0014VM\u001a\u0005\u00069E$\ta\u001e\u000b\u0002a\"9\u00110\u001db\u0001\n\u0003Q\u0018\u0001C%O'R\u000bejQ#\u0016\u0003QAa\u0001`9!\u0002\u0013!\u0012!C%O'R\u000bejQ#!\u0001")
public class PushFilterIntoLegacyTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushFilterIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        TableConfig config = call.getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig();
        if (!config.getConfiguration().getBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_PREDICATE_PUSHDOWN_ENABLED)) {
            return false;
        }
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        LegacyTableSourceTable legacyTableSourceTable = scan.getTable().unwrap(LegacyTableSourceTable.class);
        if (legacyTableSourceTable != null) {
            TableSource tableSource;
            LegacyTableSourceTable legacyTableSourceTable2 = legacyTableSourceTable;
            TableSource tableSource2 = legacyTableSourceTable2.tableSource();
            boolean bl2 = tableSource2 instanceof FilterableTableSource ? !((FilterableTableSource)((Object)(tableSource = tableSource2))).isFilterPushedDown() : false;
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        LegacyTableSourceTable table = (LegacyTableSourceTable)scan.getTable();
        this.pushFilterIntoScan(call, filter, scan, table);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkPreparingTableBase relOptTable) {
        RelBuilder relBuilder = call.builder();
        FlinkContext context = call.getPlanner().getContext().unwrap(FlinkContext.class);
        int maxCnfNodeCount = FlinkRelOptUtil$.MODULE$.getMaxCnfNodeCount(scan);
        Tuple2<Expression[], RexNode[]> tuple2 = RexNodeExtractor$.MODULE$.extractConjunctiveConditions(filter.getCondition(), maxCnfNodeCount, filter.getInput().getRowType().getFieldNames(), relBuilder.getRexBuilder(), context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(scan.getCluster().getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig().getLocalTimeZone()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] predicates = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] predicates2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).isEmpty()) {
            return;
        }
        LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)remainingPredicates.add(e)));
        FlinkPreparingTableBase newRelOptTable = this.applyPredicate(remainingPredicates, relOptTable, relBuilder.getTypeFactory());
        TableSource newTableSource = newRelOptTable.unwrap(LegacyTableSourceTable.class).tableSource();
        TableSource oldTableSource = relOptTable.unwrap(LegacyTableSourceTable.class).tableSource();
        if (((FilterableTableSource)((Object)newTableSource)).isFilterPushedDown() && newTableSource.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push filter into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newRelOptTable);
        if (remainingPredicates.isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)).isEmpty()) {
            call.transformTo(newScan);
        } else {
            relBuilder.push(scan);
            ExpressionConverter converter = new ExpressionConverter(relBuilder);
            Buffer remainingConditions = ((BufferLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(remainingPredicates).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.accept(converter), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)));
            RexNode remainingCondition = (RexNode)remainingConditions.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> relBuilder.and((RexNode)l, (RexNode)r));
            Filter newFilter = filter.copy(filter.getTraitSet(), newScan, remainingCondition);
            call.transformTo(newFilter);
        }
    }

    private FlinkPreparingTableBase applyPredicate(List<Expression> predicates, FlinkPreparingTableBase relOptTable, RelDataTypeFactory typeFactory) {
        FlinkStatistic flinkStatistic;
        int originPredicatesSize = predicates.size();
        LegacyTableSourceTable tableSourceTable = relOptTable.unwrap(LegacyTableSourceTable.class);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)tableSourceTable.tableSource());
        TableSource newTableSource = filterableSource.applyPredicate(predicates);
        int updatedPredicatesSize = predicates.size();
        FlinkStatistic statistic = tableSourceTable.getStatistic();
        if (originPredicatesSize == updatedPredicatesSize) {
            flinkStatistic = statistic;
        } else {
            FlinkStatistic flinkStatistic2 = statistic;
            FlinkStatistic flinkStatistic3 = FlinkStatistic$.MODULE$.UNKNOWN();
            flinkStatistic = !(flinkStatistic2 != null ? !flinkStatistic2.equals(flinkStatistic3) : flinkStatistic3 != null) ? statistic : FlinkStatistic$.MODULE$.builder().statistic(statistic).tableStats(null).build();
        }
        FlinkStatistic newStatistic = flinkStatistic;
        return tableSourceTable.copy(newTableSource, newStatistic);
    }

    public PushFilterIntoLegacyTableSourceScanRule() {
        super(RelOptRule.operand(Filter.class, RelOptRule.operand(LogicalTableScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoLegacyTableSourceScanRule");
    }
}

