/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.NestedLoopJoinCodeGenerator;
import org.apache.flink.table.planner.delegation.BatchPlanner;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecJoinBase;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001U\u0011qCQ1uG\",\u00050Z2OKN$X\r\u001a'p_BTu.\u001b8\u000b\u0005\r!\u0011!\u00022bi\u000eD'BA\u0003\u0007\u0003!\u0001\b._:jG\u0006d'BA\u0004\t\u0003\u0015qw\u000eZ3t\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0012\u0005\u0006$8\r[#yK\u000eTu.\u001b8CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f\rdWo\u001d;feB\u0011Q$I\u0007\u0002=)\u0011\u0011b\b\u0006\u0003AA\tqaY1mG&$X-\u0003\u0002#=\ti!+\u001a7PaR\u001cE.^:uKJD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\tiJ\f\u0017\u000e^*fiB\u0011QDJ\u0005\u0003Oy\u00111BU3m)J\f\u0017\u000e^*fi\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0004mK\u001a$(+\u001a7\u0011\u0005-rS\"\u0001\u0017\u000b\u00055z\u0012a\u0001:fY&\u0011q\u0006\f\u0002\b%\u0016dgj\u001c3f\u0011!\t\u0004A!A!\u0002\u0013Q\u0013\u0001\u0003:jO\"$(+\u001a7\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011bY8oI&$\u0018n\u001c8\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]z\u0012a\u0001:fq&\u0011\u0011H\u000e\u0002\b%\u0016Dhj\u001c3f\u0011!Y\u0004A!A!\u0002\u0013a\u0014\u0001\u00036pS:$\u0016\u0010]3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}b\u0013\u0001B2pe\u0016L!!\u0011 \u0003\u0017){\u0017N\u001c*fYRK\b/\u001a\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\u0006YA.\u001a4u\u0013N\u0014U/\u001b7e+\u0005)\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u000b\u0006aA.\u001a4u\u0013N\u0014U/\u001b7eA!Aa\n\u0001BC\u0002\u0013\u0005A)A\u0007tS:<G.\u001a*po*{\u0017N\u001c\u0005\t!\u0002\u0011\t\u0011)A\u0005\u000b\u0006q1/\u001b8hY\u0016\u0014vn\u001e&pS:\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016A\u0002\u001fj]&$h\bF\u0005U+Z;\u0006,\u0017.\\9B\u0011q\u0003\u0001\u0005\u00067E\u0003\r\u0001\b\u0005\u0006IE\u0003\r!\n\u0005\u0006SE\u0003\rA\u000b\u0005\u0006cE\u0003\rA\u000b\u0005\u0006gE\u0003\r\u0001\u000e\u0005\u0006wE\u0003\r\u0001\u0010\u0005\u0006\u0007F\u0003\r!\u0012\u0005\u0006\u001dF\u0003\r!\u0012\u0005\u0006=\u0002!\teX\u0001\u0005G>\u0004\u0018\u0010F\u0004aG\u00124\u0007N[6\u0011\u0005u\n\u0017B\u00012?\u0005\u0011Qu.\u001b8\t\u000b\u0011j\u0006\u0019A\u0013\t\u000b\u0015l\u0006\u0019\u0001\u001b\u0002\u001b\r|g\u000eZ5uS>tW\t\u001f9s\u0011\u00159W\f1\u0001+\u0003\u0011aWM\u001a;\t\u000b%l\u0006\u0019\u0001\u0016\u0002\u000bILw\r\u001b;\t\u000bmj\u0006\u0019\u0001\u001f\t\u000b1l\u0006\u0019A#\u0002\u0019M,W.\u001b&pS:$uN\\3\t\u000b9\u0004A\u0011I8\u0002\u0019\u0015D\b\u000f\\1j]R+'/\\:\u0015\u0005A\u001c\bCA\u0016r\u0013\t\u0011HFA\u0005SK2<&/\u001b;fe\")A/\u001ca\u0001a\u0006\u0011\u0001o\u001e\u0005\u0006m\u0002!\te^\u0001\u0010G>l\u0007/\u001e;f'\u0016dgmQ8tiR\u0019\u0001p_@\u0011\u0005uI\u0018B\u0001>\u001f\u0005)\u0011V\r\\(qi\u000e{7\u000f\u001e\u0005\u0006\u0017U\u0004\r\u0001 \t\u0003;uL!A \u0010\u0003\u001bI+Gn\u00149u!2\fgN\\3s\u0011\u001d\t\t!\u001ea\u0001\u0003\u0007\t!!\\9\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003-\u0003!iW\r^1eCR\f\u0017\u0002BA\u0007\u0003\u000f\u0011\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014\u0005\t2\u000f[;gM2,')^5mI\u000e{WO\u001c;\u0015\t\u0005U\u00111\u0004\t\u0004\r\u0006]\u0011bAA\r\u000f\n\u0019\u0011J\u001c;\t\u0011\u0005\u0005\u0011q\u0002a\u0001\u0003\u0007Aq!a\b\u0001\t\u0003\n\t#A\u0007tCRL7OZ=Ue\u0006LGo\u001d\u000b\u0005\u0003G\tI\u0003\u0005\u0003G\u0003KQ\u0013bAA\u0014\u000f\n1q\n\u001d;j_:Dq!a\u000b\u0002\u001e\u0001\u0007Q%\u0001\tsKF,\u0018N]3e)J\f\u0017\u000e^*fi\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012AD4fi\u0012\u000bWNQ3iCZLwN]\u000b\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0005pa\u0016\u0014\u0018\r^8sg*\u0019\u0011Q\b\b\u0002\u000fI,h\u000e^5nK&!\u0011\u0011IA\u001c\u0005-!\u0015-\u001c\"fQ\u00064\u0018n\u001c:\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005iq-\u001a;J]B,HOT8eKN,\"!!\u0013\u0011\r\u0005-\u0013QKA-\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001B;uS2T!!a\u0015\u0002\t)\fg/Y\u0005\u0005\u0003/\niE\u0001\u0003MSN$\b\u0007BA.\u0003o\u0002\u0002\"!\u0018\u0002d\u0005\u001d\u00141O\u0007\u0003\u0003?R1!!\u0019\u0007\u0003\u0011)\u00070Z2\n\t\u0005\u0015\u0014q\f\u0002\t\u000bb,7MT8eKB!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n)\t!\u0002Z3mK\u001e\fG/[8o\u0013\u0011\t\t(a\u001b\u0003\u0019\t\u000bGo\u00195QY\u0006tg.\u001a:\u0011\t\u0005U\u0014q\u000f\u0007\u0001\t1\tI(a\u0011\u0002\u0002\u0003\u0005)\u0011AA>\u0005\ryF%M\t\u0005\u0003{\n\u0019\tE\u0002G\u0003\u007fJ1!!!H\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ARAC\u0013\r\t9i\u0012\u0002\u0004\u0003:L\bbBAF\u0001\u0011\u0005\u0013QR\u0001\u0011e\u0016\u0004H.Y2f\u0013:\u0004X\u000f\u001e(pI\u0016$b!a$\u0002\u0016\u0006e\u0005c\u0001$\u0002\u0012&\u0019\u00111S$\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003/\u000bI\t1\u0001\u0002\u0016\u0005yqN\u001d3j]\u0006d\u0017J\u001c)be\u0016tG\u000f\u0003\u0005\u0002\u001c\u0006%\u0005\u0019AAO\u00031qWm^%oaV$hj\u001c3fa\u0011\ty*a)\u0011\u0011\u0005u\u00131MA4\u0003C\u0003B!!\u001e\u0002$\u0012a\u0011QUAM\u0003\u0003\u0005\tQ!\u0001\u0002|\t\u0019q\fJ\u001a\t\u000f\u0005%\u0006\u0001\"\u0015\u0002,\u00069BO]1og2\fG/\u001a+p!2\fg.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003[\u000bI\r\u0005\u0004\u00020\u0006e\u0016QX\u0007\u0003\u0003cSA!a-\u00026\u0006\u0019A-Y4\u000b\u0007\u0005]f\"A\u0002ba&LA!a/\u00022\nqAK]1og\u001a|'/\\1uS>t\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rG\"\u0001\u0003eCR\f\u0017\u0002BAd\u0003\u0003\u0014qAU8x\t\u0006$\u0018\rC\u0004\f\u0003O\u0003\r!a\u001a")
public class BatchExecNestedLoopJoin
extends BatchExecJoinBase {
    private final RelOptCluster cluster;
    private final RexNode condition;
    private final boolean leftIsBuild;
    private final boolean singleRowJoin;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean singleRowJoin() {
        return this.singleRowJoin;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchExecNestedLoopJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.singleRowJoin());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("build", this.leftIsBuild() ? "left" : "right").itemIf("singleRowJoin", BoxesRunTime.boxToBoolean((boolean)this.singleRowJoin()), this.singleRowJoin());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        RelNode buildRel = this.leftIsBuild() ? this.getLeft() : this.getRight();
        Double buildRows = mq.getRowCount(buildRel);
        Double buildRowSize = mq.getAverageRowSize(buildRel);
        double memoryCost = Predef$.MODULE$.Double2double(buildRows) * (Predef$.MODULE$.Double2double(buildRowSize) + (double)4) * (double)this.shuffleBuildCount(mq);
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) * Predef$.MODULE$.Double2double(rightRowCnt);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memoryCost);
    }

    private int shuffleBuildCount(RelMetadataQuery mq) {
        int n;
        RelNode probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        Double rowCount = mq.getRowCount(probeRel);
        if (rowCount == null) {
            n = 1;
        } else {
            Double probeRowSize = mq.getAverageRowSize(probeRel);
            n = Math.max(1, (int)(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(probeRowSize) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
        }
        return n;
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    @Override
    public DamBehavior getDamBehavior() {
        return DamBehavior.PIPELINED;
    }

    @Override
    public List<ExecNode<BatchPlanner, ?>> getInputNodes() {
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getInputs()).map((Function1 & Serializable & scala.Serializable)x$1 -> (ExecNode)((Object)x$1), Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public void replaceInputNode(int ordinalInParent, ExecNode<BatchPlanner, ?> newInputNode) {
        this.replaceInput(ordinalInParent, (RelNode)((Object)newInputNode));
    }

    @Override
    public Transformation<RowData> translateToPlanInternal(BatchPlanner planner) {
        Transformation<?> lInput = this.getInputNodes().get(0).translateToPlan(planner);
        Transformation<?> rInput = this.getInputNodes().get(1).translateToPlan(planner);
        RowType lType = ((RowDataTypeInfo)lInput.getOutputType()).toRowType();
        RowType rType = ((RowDataTypeInfo)rInput.getOutputType()).toRowType();
        RowType outputType = FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType());
        CodeGenOperatorFactory<RowData> op = new NestedLoopJoinCodeGenerator(CodeGeneratorContext$.MODULE$.apply(planner.getTableConfig()), this.singleRowJoin(), this.leftIsBuild(), lType, rType, outputType, this.flinkJoinType(), this.condition).gen();
        int parallelism = this.leftIsBuild() ? rInput.getParallelism() : lInput.getParallelism();
        long manageMem = this.singleRowJoin() ? 0L : MemorySize.parse((String)planner.getTableConfig().getConfiguration().getString(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        return ExecNode$.MODULE$.createTwoInputTransformation(lInput, rInput, this.getRelDetailedDescription(), op, RowDataTypeInfo.of(outputType), parallelism, manageMem);
    }

    public BatchExecNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean singleRowJoin) {
        this.cluster = cluster;
        this.condition = condition;
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
    }
}

