/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.calcite;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0003\u0003\u0019\"\u0001\u0002*b].T!a\u0001\u0003\u0002\u000f\r\fGnY5uK*\u0011QAB\u0001\u0006]>$Wm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UIR\"\u0001\f\u000b\u0005]A\u0012a\u0001:fY*\u00111AD\u0005\u00035Y\u0011\u0011bU5oO2,'+\u001a7\t\u0011q\u0001!\u0011!Q\u0001\nu\tqa\u00197vgR,'\u000f\u0005\u0002\u001fA5\tqD\u0003\u0002\b1%\u0011\u0011e\b\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003=\u0015J!AJ\u0010\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005)\u0011N\u001c9viB\u0011QCK\u0005\u0003WY\u0011qAU3m\u001d>$W\r\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u00031\u0001\u0018M\u001d;ji&|gnS3z+\u0005y\u0003C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0019\u0003\u0011)H/\u001b7\n\u0005Q\n$aD%n[V$\u0018M\u00197f\u0005&$8+\u001a;\t\u0011Y\u0002!\u0011!Q\u0001\n=\nQ\u0002]1si&$\u0018n\u001c8LKf\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u001d\u0002\u0011=\u0014H-\u001a:LKf,\u0012A\u000f\t\u0003+mJ!\u0001\u0010\f\u0003\u0019I+GnQ8mY\u0006$\u0018n\u001c8\t\u0011y\u0002!\u0011!Q\u0001\ni\n\u0011b\u001c:eKJ\\U-\u001f\u0011\t\u0011\u0001\u0003!Q1A\u0005\u0002\u0005\u000b\u0001B]1oWRK\b/Z\u000b\u0002\u0005B\u00111IS\u0007\u0002\t*\u0011QIR\u0001\u0005e\u0006t7N\u0003\u0002H\u0011\u0006Iq\u000e]3sCR|'o\u001d\u0006\u0003\u0013*\tqA];oi&lW-\u0003\u0002L\t\nA!+\u00198l)f\u0004X\r\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003C\u0003%\u0011\u0018M\\6UsB,\u0007\u0005\u0003\u0005P\u0001\t\u0015\r\u0011\"\u0001Q\u0003%\u0011\u0018M\\6SC:<W-F\u0001R!\t\u0019%+\u0003\u0002T\t\nI!+\u00198l%\u0006tw-\u001a\u0005\t+\u0002\u0011\t\u0011)A\u0005#\u0006Q!/\u00198l%\u0006tw-\u001a\u0011\t\u0011]\u0003!Q1A\u0005\u0002a\u000baB]1oW:+XNY3s)f\u0004X-F\u0001Z!\tQV,D\u0001\\\u0015\taf#\u0001\u0003usB,\u0017B\u00010\\\u0005A\u0011V\r\u001c#bi\u0006$\u0016\u0010]3GS\u0016dG\r\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003Z\u0003=\u0011\u0018M\\6Ok6\u0014WM\u001d+za\u0016\u0004\u0003\u0002\u00032\u0001\u0005\u000b\u0007I\u0011A2\u0002!=,H\u000f];u%\u0006t7NT;nE\u0016\u0014X#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\u000f\t{w\u000e\\3b]\"A1\u000e\u0001B\u0001B\u0003%A-A\tpkR\u0004X\u000f\u001e*b].tU/\u001c2fe\u0002BQ!\u001c\u0001\u0005\u00029\fa\u0001P5oSRtDCC8reN$XO^<ysB\u0011\u0001\u000fA\u0007\u0002\u0005!)A\u0004\u001ca\u0001;!)1\u0005\u001ca\u0001I!)\u0001\u0006\u001ca\u0001S!)Q\u0006\u001ca\u0001_!)\u0001\b\u001ca\u0001u!)\u0001\t\u001ca\u0001\u0005\")q\n\u001ca\u0001#\")q\u000b\u001ca\u00013\")!\r\u001ca\u0001I\")1\u0010\u0001C!y\u0006iA-\u001a:jm\u0016\u0014vn\u001e+za\u0016$\u0012! \t\u00035zL!a`.\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u00031)\u0007\u0010\u001d7bS:$VM]7t)\u0011\t9!!\u0004\u0011\u0007U\tI!C\u0002\u0002\fY\u0011\u0011BU3m/JLG/\u001a:\t\u0011\u0005=\u0011\u0011\u0001a\u0001\u0003\u000f\t!\u0001]<\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016\u0005\u0001Rm\u001d;j[\u0006$XMU8x\u0007>,h\u000e\u001e\u000b\u0005\u0003/\ti\u0002E\u0002f\u00033I1!a\u0007g\u0005\u0019!u.\u001e2mK\"A\u0011qDA\t\u0001\u0004\t\t#\u0001\u0002ncB!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(Y\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003W\t)C\u0001\tSK2lU\r^1eCR\f\u0017+^3ss\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012aD2p[B,H/Z*fY\u001a\u001cun\u001d;\u0015\r\u0005M\u0012\u0011HA!!\rq\u0012QG\u0005\u0004\u0003oy\"A\u0003*fY>\u0003HoQ8ti\"9\u0011\"!\fA\u0002\u0005m\u0002c\u0001\u0010\u0002>%\u0019\u0011qH\u0010\u0003\u001bI+Gn\u00149u!2\fgN\\3s\u0011!\ty\"!\fA\u0002\u0005\u0005\u0002")
public abstract class Rank
extends SingleRel {
    private final RelOptCluster cluster;
    private final RelNode input;
    private final ImmutableBitSet partitionKey;
    private final RelCollation orderKey;
    private final RankType rankType;
    private final RankRange rankRange;
    private final RelDataTypeField rankNumberType;
    private final boolean outputRankNumber;

    public ImmutableBitSet partitionKey() {
        return this.partitionKey;
    }

    public RelCollation orderKey() {
        return this.orderKey;
    }

    public RankType rankType() {
        return this.rankType;
    }

    public RankRange rankRange() {
        return this.rankRange;
    }

    public RelDataTypeField rankNumberType() {
        return this.rankNumberType;
    }

    public boolean outputRankNumber() {
        return this.outputRankNumber;
    }

    @Override
    public RelDataType deriveRowType() {
        if (!this.outputRankNumber()) {
            return this.input.getRowType();
        }
        RelDataTypeFactory typeFactory = this.cluster.getRexBuilder().getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.input.getRowType().getFieldList()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> typeBuilder.add((RelDataTypeField)x$1));
        typeBuilder.add(this.rankNumberType());
        return typeBuilder.build();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String select = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldNames()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = new StringBuilder(2).append(name).append("=$").append(idx).toString();
            return string;
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        return super.explainTerms(pw).item("rankType", (Object)this.rankType()).item("rankRange", this.rankRange()).item("partitionBy", ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)this.partitionKey()).map((Function1 & Serializable & scala.Serializable)i -> new StringBuilder(1).append("$").append(i).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(",")).item("orderBy", RelExplainUtil$.MODULE$.collationToString(this.orderKey())).item("select", select);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double d;
        Double countPerGroup = FlinkRelMdUtil$.MODULE$.getRankRangeNdv(this.rankRange());
        if (this.partitionKey().isEmpty()) {
            d = Predef$.MODULE$.Double2double(countPerGroup);
        } else {
            Double inputRowCount = mq.getRowCount(this.input);
            Double numOfGroup = mq.getDistinctRowCount(this.input, this.partitionKey(), null);
            d = numOfGroup != null ? Predef$.MODULE$.Double2double(NumberUtil.min(Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(numOfGroup) * Predef$.MODULE$.Double2double(countPerGroup)), inputRowCount)) : Predef$.MODULE$.Double2double(NumberUtil.min(Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(mq.getRowCount(this.input)) * 0.1), inputRowCount));
        }
        return d;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double rowCount;
        Double cpuCost = rowCount = mq.getRowCount(this.input);
        return planner.getCostFactory().makeCost(Predef$.MODULE$.Double2double(rowCount), Predef$.MODULE$.Double2double(cpuCost), 0.0);
    }

    public Rank(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet partitionKey, RelCollation orderKey, RankType rankType, RankRange rankRange, RelDataTypeField rankNumberType, boolean outputRankNumber) {
        this.cluster = cluster;
        this.input = input;
        this.partitionKey = partitionKey;
        this.orderKey = orderKey;
        this.rankType = rankType;
        this.rankRange = rankRange;
        this.rankNumberType = rankNumberType;
        this.outputRankNumber = outputRankNumber;
        super(cluster, traitSet, input);
        if (orderKey.getFieldCollations().isEmpty()) {
            throw new TableException("orderKey should not be empty.");
        }
        RankRange rankRange2 = rankRange;
        if (rankRange2 instanceof ConstantRankRange) {
            ConstantRankRange constantRankRange = (ConstantRankRange)rankRange2;
            if (constantRankRange.getRankEnd() <= 0L) {
                throw new TableException(new StringBuilder(50).append("Rank end can't smaller than zero. The rank end is ").append(constantRankRange.getRankEnd()).toString());
            }
            if (constantRankRange.getRankStart() > constantRankRange.getRankEnd()) {
                throw new TableException(new StringBuilder(45).append("Rank start '").append(constantRankRange.getRankStart()).append("' can't greater than rank end '").append(constantRankRange.getRankEnd()).append("'.").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (rankRange2 instanceof VariableRankRange) {
            VariableRankRange variableRankRange = (VariableRankRange)rankRange2;
            if (variableRankRange.getRankEndIndex() < 0) {
                throw new TableException("Rank end index can't smaller than zero.");
            }
            if (variableRankRange.getRankEndIndex() >= input.getRowType().getFieldCount()) {
                throw new TableException("Rank end index can't greater than input field count.");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)rankRange2);
        }
    }
}

