/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableCorrelate;
import org.apache.calcite.adapter.enumerable.EnumerableHashJoin;
import org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import org.apache.calcite.adapter.enumerable.EnumerableNestedLoopJoin;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.LinkedListMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Ordering;

public class FlinkRelMdCollation
implements MetadataHandler<BuiltInMetadata.Collation> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLLATIONS.method, new FlinkRelMdCollation());

    private FlinkRelMdCollation() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Collation> getDef() {
        return BuiltInMetadata.Collation.DEF;
    }

    public ImmutableList<RelCollation> collations(TableScan scan, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.table(scan.getTable()));
    }

    public ImmutableList<RelCollation> collations(Values values, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.values(mq, values.getRowType(), values.getTuples()));
    }

    public ImmutableList<RelCollation> collations(Project project, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.project(mq, project.getInput(), project.getProjects()));
    }

    public ImmutableList<RelCollation> collations(Filter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(Calc calc, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.calc(mq, calc.getInput(), calc.getProgram()));
    }

    public ImmutableList<RelCollation> collations(SortExchange sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.sort(sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(Sort sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.sort(sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(Window rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.window(mq, rel.getInput(), rel.groups));
    }

    public ImmutableList<RelCollation> collations(EnumerableCorrelate join, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.enumerableCorrelate(mq, join.getLeft(), join.getRight(), join.getJoinType()));
    }

    public ImmutableList<RelCollation> collations(EnumerableMergeJoin join, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.mergeJoin(mq, join.getLeft(), join.getRight(), join.analyzeCondition().leftKeys, join.analyzeCondition().rightKeys));
    }

    public ImmutableList<RelCollation> collations(EnumerableHashJoin join, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.enumerableHashJoin(mq, join.getLeft(), join.getRight(), join.getJoinType()));
    }

    public ImmutableList<RelCollation> collations(EnumerableNestedLoopJoin join, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.enumerableNestedLoopJoin(mq, join.getLeft(), join.getRight(), join.getJoinType()));
    }

    public ImmutableList<RelCollation> collations(Match rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(FlinkRelMdCollation.match(mq, rel.getInput(), rel.getRowType(), rel.getPattern(), rel.isStrictStart(), rel.isStrictEnd(), rel.getPatternDefinitions(), rel.getMeasures(), rel.getAfter(), rel.getSubsets(), rel.isAllRows(), rel.getPartitionKeys(), rel.getOrderKeys(), rel.getInterval()));
    }

    public ImmutableList<RelCollation> collations(TableModify rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.collations(rel.getCurrentRel());
    }

    public ImmutableList<RelCollation> collations(RelSubset subset, RelMetadataQuery mq) {
        RelNode rel = Util.first(subset.getBest(), subset.getOriginal());
        return mq.collations(rel);
    }

    public ImmutableList<RelCollation> collations(RelNode rel, RelMetadataQuery mq) {
        return ImmutableList.of();
    }

    public static List<RelCollation> table(RelOptTable table) {
        return table.getCollationList();
    }

    public static List<RelCollation> values(RelMetadataQuery mq, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        Util.discard(mq);
        ArrayList<RelCollation> list = new ArrayList<RelCollation>();
        int n = rowType.getFieldCount();
        ArrayList<Pair<RelFieldCollation, Ordering<List<RexLiteral>>>> pairs = new ArrayList<Pair<RelFieldCollation, Ordering<List<RexLiteral>>>>();
        block0: for (int i = 0; i < n; ++i) {
            pairs.clear();
            for (int j = i; j < n; ++j) {
                RelFieldCollation fieldCollation = new RelFieldCollation(j);
                Ordering<List<RexLiteral>> comparator = FlinkRelMdCollation.comparator(fieldCollation);
                Ordering<List<RexLiteral>> ordering = pairs.isEmpty() ? comparator : ((Ordering)((Pair)Util.last(pairs)).right).compound(comparator);
                pairs.add(Pair.of(fieldCollation, ordering));
                if (ordering.isOrdered(tuples)) continue;
                if (j == i) continue block0;
                pairs.remove(pairs.size() - 1);
            }
            if (pairs.isEmpty()) continue;
            list.add(RelCollations.of(Pair.left(pairs)));
        }
        return list;
    }

    private static Ordering<List<RexLiteral>> comparator(RelFieldCollation fieldCollation) {
        final int nullComparison = fieldCollation.nullDirection.nullComparison;
        final int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Ordering<List<RexLiteral>>(){

                    @Override
                    public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                        Comparable c1 = o1.get(x).getValueAs(Comparable.class);
                        Comparable c2 = o2.get(x).getValueAs(Comparable.class);
                        return RelFieldCollation.compare(c1, c2, nullComparison);
                    }
                };
            }
        }
        return new Ordering<List<RexLiteral>>(){

            @Override
            public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                Comparable c1 = o1.get(x).getValueAs(Comparable.class);
                Comparable c2 = o2.get(x).getValueAs(Comparable.class);
                return RelFieldCollation.compare(c2, c1, -nullComparison);
            }
        };
    }

    public static List<RelCollation> project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        TreeSet<RelCollation> collations = new TreeSet<RelCollation>();
        ImmutableList<RelCollation> inputCollations = mq.collations(input);
        if (inputCollations == null || inputCollations.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedListMultimap<Integer, Integer> targets = LinkedListMultimap.create();
        HashMap<Integer, SqlMonotonicity> targetsWithMonotonicity = new HashMap<Integer, SqlMonotonicity>();
        for (Ord<? extends RexNode> ord : Ord.zip(projects)) {
            if (ord.e instanceof RexInputRef) {
                targets.put(((RexInputRef)ord.e).getIndex(), ord.i);
                continue;
            }
            if (!(ord.e instanceof RexCall)) continue;
            RexCall call = (RexCall)ord.e;
            RexCallBinding binding = RexCallBinding.create(input.getCluster().getTypeFactory(), call, inputCollations);
            targetsWithMonotonicity.put(ord.i, call.getOperator().getMonotonicity(binding));
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        block4: for (RelCollation ic : inputCollations) {
            if (ic.getFieldCollations().isEmpty()) continue;
            fieldCollations.clear();
            for (RelFieldCollation ifc : ic.getFieldCollations()) {
                Collection integers = targets.get(ifc.getFieldIndex());
                if (integers.isEmpty()) continue block4;
                fieldCollations.add(ifc.withFieldIndex((Integer)integers.iterator().next()));
            }
            assert (!fieldCollations.isEmpty());
            collations.add(RelCollations.of(fieldCollations));
        }
        ArrayList<RelFieldCollation> arrayList = new ArrayList<RelFieldCollation>();
        block6: for (Map.Entry entry : targetsWithMonotonicity.entrySet()) {
            SqlMonotonicity value = (SqlMonotonicity)((Object)entry.getValue());
            switch (value) {
                case NOT_MONOTONIC: 
                case CONSTANT: {
                    continue block6;
                }
            }
            arrayList.add(new RelFieldCollation((Integer)entry.getKey(), RelFieldCollation.Direction.of(value)));
        }
        if (!arrayList.isEmpty()) {
            collations.add(RelCollations.of(arrayList));
        }
        return ImmutableList.copyOf(collations);
    }

    public static List<RelCollation> filter(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        List projects = program.getProjectList().stream().map(program::expandLocalRef).collect(Collectors.toList());
        return FlinkRelMdCollation.project(mq, input, projects);
    }

    public static List<RelCollation> snapshot(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> sort(RelCollation collation) {
        return ImmutableList.of(collation);
    }

    public static List<RelCollation> limit(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> window(RelMetadataQuery mq, RelNode input, ImmutableList<Window.Group> groups) {
        return mq.collations(input);
    }

    public static List<RelCollation> match(RelMetadataQuery mq, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        return mq.collations(input);
    }

    public static List<RelCollation> mergeJoin(RelMetadataQuery mq, RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList<RelCollation> leftCollations = mq.collations(left);
        assert (RelCollations.contains(leftCollations, leftKeys)) : "cannot merge join: left input is not sorted on left keys";
        builder.addAll(leftCollations);
        ImmutableList<RelCollation> rightCollations = mq.collations(right);
        assert (RelCollations.contains(rightCollations, rightKeys)) : "cannot merge join: right input is not sorted on right keys";
        int leftFieldCount = left.getRowType().getFieldCount();
        for (RelCollation collation : rightCollations) {
            builder.add(RelCollations.shift(collation, leftFieldCount));
        }
        return builder.build();
    }

    public static List<RelCollation> enumerableHashJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        if (joinType == JoinRelType.SEMI) {
            return FlinkRelMdCollation.enumerableSemiJoin(mq, left, right);
        }
        return FlinkRelMdCollation.enumerableJoin0(mq, left, right, joinType);
    }

    public static List<RelCollation> enumerableNestedLoopJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return FlinkRelMdCollation.enumerableJoin0(mq, left, right, joinType);
    }

    public static List<RelCollation> enumerableCorrelate(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return mq.collations(left);
    }

    public static List<RelCollation> enumerableSemiJoin(RelMetadataQuery mq, RelNode left, RelNode right) {
        return mq.collations(left);
    }

    public static List<RelCollation> enumerableBatchNestedLoopJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return mq.collations(left);
    }

    private static List<RelCollation> enumerableJoin0(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        ImmutableList<RelCollation> leftCollations = mq.collations(left);
        switch (joinType) {
            case SEMI: 
            case ANTI: 
            case INNER: 
            case LEFT: {
                return leftCollations;
            }
            case RIGHT: 
            case FULL: {
                for (RelCollation collation : leftCollations) {
                    for (RelFieldCollation field : collation.getFieldCollations()) {
                        if (RelFieldCollation.NullDirection.LAST == field.nullDirection) continue;
                        return ImmutableList.of();
                    }
                }
                return leftCollations;
            }
        }
        return ImmutableList.of();
    }
}

