/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.bridging;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingUtils;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@Internal
public final class BridgingSqlFunction
extends SqlFunction {
    private final DataTypeFactory dataTypeFactory;
    private final FlinkTypeFactory typeFactory;
    @Nullable
    private final FunctionIdentifier identifier;
    private final FunctionDefinition definition;
    private final TypeInference typeInference;

    private BridgingSqlFunction(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, SqlKind kind, @Nullable FunctionIdentifier identifier, FunctionDefinition definition, TypeInference typeInference) {
        super(BridgingUtils.createName(identifier, definition), BridgingUtils.createSqlIdentifier(identifier), kind, BridgingUtils.createSqlReturnTypeInference(dataTypeFactory, definition, typeInference), BridgingUtils.createSqlOperandTypeInference(dataTypeFactory, definition, typeInference), BridgingUtils.createSqlOperandTypeChecker(dataTypeFactory, definition, typeInference), BridgingUtils.createParamTypes(typeFactory, typeInference), BridgingUtils.createSqlFunctionCategory(identifier));
        this.dataTypeFactory = dataTypeFactory;
        this.typeFactory = typeFactory;
        this.identifier = identifier;
        this.definition = definition;
        this.typeInference = typeInference;
    }

    public static BridgingSqlFunction of(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, SqlKind kind, @Nullable FunctionIdentifier identifier, FunctionDefinition definition, TypeInference typeInference) {
        Preconditions.checkState((definition.getKind() == FunctionKind.SCALAR || definition.getKind() == FunctionKind.TABLE ? 1 : 0) != 0, (Object)"Scalar or table function kind expected.");
        return new BridgingSqlFunction(dataTypeFactory, typeFactory, kind, identifier, definition, typeInference);
    }

    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public Optional<FunctionIdentifier> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public FunctionDefinition getDefinition() {
        return this.definition;
    }

    public TypeInference getTypeInference() {
        return this.typeInference;
    }

    @Override
    public List<String> getParamNames() {
        if (this.typeInference.getNamedArguments().isPresent()) {
            return this.typeInference.getNamedArguments().get();
        }
        return super.getParamNames();
    }

    @Override
    public boolean isDeterministic() {
        return this.definition.isDeterministic();
    }
}

