/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.TimestampDataTypeInfo;

public abstract class MinWithRetractAggFunction<T extends Comparable>
extends AggregateFunction<T, MinWithRetractAccumulator<T>> {
    private static final long serialVersionUID = 4253774292802374843L;

    @Override
    public MinWithRetractAccumulator<T> createAccumulator() {
        MinWithRetractAccumulator acc = new MinWithRetractAccumulator();
        acc.min = null;
        acc.mapSize = 0L;
        acc.map = new MapView(this.getValueTypeInfo(), (TypeInformation<?>)BasicTypeInfo.LONG_TYPE_INFO);
        return acc;
    }

    public void accumulate(MinWithRetractAccumulator<T> acc, Object value) throws Exception {
        if (value != null) {
            Long count;
            Comparable v = (Comparable)value;
            if (acc.mapSize == 0L || ((Comparable)acc.min).compareTo(v) > 0) {
                acc.min = v;
            }
            if ((count = acc.map.get(v)) == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count + 1L)) == 0L) {
                acc.map.remove(v);
            } else {
                acc.map.put(v, count);
            }
            if (count == 1L) {
                MinWithRetractAccumulator<T> minWithRetractAccumulator = acc;
                minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize + 1L;
            }
        }
    }

    public void retract(MinWithRetractAccumulator<T> acc, Object value) throws Exception {
        if (value != null) {
            Comparable v = (Comparable)value;
            Long count = acc.map.get(v);
            if (count == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count - 1L)) == 0L) {
                acc.map.remove(v);
                MinWithRetractAccumulator<T> minWithRetractAccumulator = acc;
                minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize - 1L;
                if (acc.mapSize == 0L) {
                    acc.min = null;
                    return;
                }
                if (v.equals(acc.min)) {
                    this.updateMin(acc);
                }
            } else {
                acc.map.put(v, count);
            }
        }
    }

    private void updateMin(MinWithRetractAccumulator<T> acc) throws Exception {
        boolean hasMin = false;
        for (Comparable key : acc.map.keys()) {
            if (hasMin && ((Comparable)acc.min).compareTo(key) <= 0) continue;
            acc.min = key;
            hasMin = true;
        }
        if (!hasMin) {
            acc.mapSize = 0L;
            acc.min = null;
        }
    }

    public void merge(MinWithRetractAccumulator<T> acc, Iterable<MinWithRetractAccumulator<T>> its) throws Exception {
        boolean needUpdateMin = false;
        for (MinWithRetractAccumulator<T> a : its) {
            if (acc.mapSize == 0L || a.mapSize > 0L && a.min != null && ((Comparable)acc.min).compareTo(a.min) > 0) {
                acc.min = a.min;
            }
            for (Map.Entry entry : a.map.entries()) {
                MinWithRetractAccumulator<T> minWithRetractAccumulator;
                long mergedCount;
                Comparable key = (Comparable)entry.getKey();
                Long otherCount = entry.getValue();
                Long thisCount = acc.map.get(key);
                if (thisCount == null) {
                    thisCount = 0L;
                }
                if ((mergedCount = otherCount + thisCount) == 0L) {
                    acc.map.remove(key);
                    if (thisCount <= 0L) continue;
                    minWithRetractAccumulator = acc;
                    Long.valueOf(minWithRetractAccumulator.mapSize - 1L);
                    minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.min)) continue;
                    needUpdateMin = true;
                    continue;
                }
                if (mergedCount < 0L) {
                    acc.map.put(key, mergedCount);
                    if (thisCount <= 0L) continue;
                    minWithRetractAccumulator = acc;
                    Long.valueOf(minWithRetractAccumulator.mapSize - 1L);
                    minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.min)) continue;
                    needUpdateMin = true;
                    continue;
                }
                acc.map.put(key, mergedCount);
                if (thisCount > 0L) continue;
                minWithRetractAccumulator = acc;
                Long.valueOf(minWithRetractAccumulator.mapSize + 1L);
                minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize;
            }
        }
        if (needUpdateMin) {
            this.updateMin(acc);
        }
    }

    public void resetAccumulator(MinWithRetractAccumulator<T> acc) {
        acc.min = null;
        acc.mapSize = 0L;
        acc.map.clear();
    }

    @Override
    public T getValue(MinWithRetractAccumulator<T> acc) {
        if (acc.mapSize > 0L) {
            return (T)((Comparable)acc.min);
        }
        return null;
    }

    @Override
    public TypeInformation<MinWithRetractAccumulator<T>> getAccumulatorType() {
        PojoTypeInfo pojoType = (PojoTypeInfo)TypeExtractor.createTypeInfo(MinWithRetractAccumulator.class);
        ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
        for (int i = 0; i < pojoType.getTotalFields(); ++i) {
            PojoField field = pojoType.getPojoFieldAt(i);
            if (field.getField().getName().equals("min")) {
                pojoFields.add(new PojoField(field.getField(), this.getValueTypeInfo()));
                continue;
            }
            pojoFields.add(field);
        }
        return new PojoTypeInfo(pojoType.getTypeClass(), pojoFields);
    }

    @Override
    public TypeInformation<T> getResultType() {
        return this.getValueTypeInfo();
    }

    protected abstract TypeInformation<T> getValueTypeInfo();

    public static class TimeMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Time> {
        private static final long serialVersionUID = -6908371577415696291L;

        @Override
        protected TypeInformation<Time> getValueTypeInfo() {
            return Types.SQL_TIME;
        }
    }

    public static class DateMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Date> {
        private static final long serialVersionUID = 604406649989470870L;

        @Override
        protected TypeInformation<Date> getValueTypeInfo() {
            return Types.SQL_DATE;
        }
    }

    public static class TimestampMinWithRetractAggFunction
    extends MinWithRetractAggFunction<TimestampData> {
        private static final long serialVersionUID = -7494198823345305907L;
        private final int precision;

        public TimestampMinWithRetractAggFunction(int precision) {
            this.precision = precision;
        }

        public void accumulate(MinWithRetractAccumulator<TimestampData> acc, TimestampData value) throws Exception {
            super.accumulate(acc, value);
        }

        public void retract(MinWithRetractAccumulator<TimestampData> acc, TimestampData value) throws Exception {
            super.retract(acc, value);
        }

        @Override
        protected TypeInformation<TimestampData> getValueTypeInfo() {
            return new TimestampDataTypeInfo(this.precision);
        }
    }

    public static class StringMinWithRetractAggFunction
    extends MinWithRetractAggFunction<StringData> {
        private static final long serialVersionUID = -6402993104400269468L;

        public void accumulate(MinWithRetractAccumulator<StringData> acc, StringData value) throws Exception {
            super.accumulate(acc, value);
        }

        public void retract(MinWithRetractAccumulator<StringData> acc, StringData value) throws Exception {
            super.retract(acc, value);
        }

        @Override
        protected TypeInformation<StringData> getValueTypeInfo() {
            return StringDataTypeInfo.INSTANCE;
        }
    }

    public static class DecimalMinWithRetractAggFunction
    extends MinWithRetractAggFunction<DecimalData> {
        private static final long serialVersionUID = -7984016112363017960L;
        private DecimalDataTypeInfo decimalType;

        public DecimalMinWithRetractAggFunction(DecimalDataTypeInfo decimalType) {
            this.decimalType = decimalType;
        }

        public void accumulate(MinWithRetractAccumulator<DecimalData> acc, DecimalData value) throws Exception {
            super.accumulate(acc, value);
        }

        public void retract(MinWithRetractAccumulator<DecimalData> acc, DecimalData value) throws Exception {
            super.retract(acc, value);
        }

        @Override
        protected TypeInformation<DecimalData> getValueTypeInfo() {
            return this.decimalType;
        }
    }

    public static class BooleanMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Boolean> {
        private static final long serialVersionUID = -4667566512148979776L;

        @Override
        protected TypeInformation<Boolean> getValueTypeInfo() {
            return BasicTypeInfo.BOOLEAN_TYPE_INFO;
        }
    }

    public static class DoubleMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Double> {
        private static final long serialVersionUID = -9107897474595423074L;

        @Override
        protected TypeInformation<Double> getValueTypeInfo() {
            return BasicTypeInfo.DOUBLE_TYPE_INFO;
        }
    }

    public static class FloatMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Float> {
        private static final long serialVersionUID = 6683867851550125554L;

        @Override
        protected TypeInformation<Float> getValueTypeInfo() {
            return BasicTypeInfo.FLOAT_TYPE_INFO;
        }
    }

    public static class LongMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Long> {
        private static final long serialVersionUID = -3224670103852172282L;

        @Override
        protected TypeInformation<Long> getValueTypeInfo() {
            return BasicTypeInfo.LONG_TYPE_INFO;
        }
    }

    public static class IntMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Integer> {
        private static final long serialVersionUID = -3187801696860321834L;

        @Override
        protected TypeInformation<Integer> getValueTypeInfo() {
            return BasicTypeInfo.INT_TYPE_INFO;
        }
    }

    public static class ShortMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Short> {
        private static final long serialVersionUID = -4877567451203730974L;

        @Override
        protected TypeInformation<Short> getValueTypeInfo() {
            return BasicTypeInfo.SHORT_TYPE_INFO;
        }
    }

    public static class ByteMinWithRetractAggFunction
    extends MinWithRetractAggFunction<Byte> {
        private static final long serialVersionUID = 3170462557144510063L;

        @Override
        protected TypeInformation<Byte> getValueTypeInfo() {
            return BasicTypeInfo.BYTE_TYPE_INFO;
        }
    }

    public static class MinWithRetractAccumulator<T> {
        public T min;
        public Long mapSize;
        public MapView<T, Long> map;
    }
}

