/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.dataview.ListViewTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.WrappingRuntimeException;

public final class ListAggWithRetractAggFunction
extends AggregateFunction<StringData, ListAggWithRetractAccumulator> {
    private static final long serialVersionUID = -2836795091288790955L;
    private static final BinaryStringData lineDelimiter = BinaryStringData.fromString(",");

    @Override
    public TypeInformation<StringData> getResultType() {
        return StringDataTypeInfo.INSTANCE;
    }

    @Override
    public TypeInformation<ListAggWithRetractAccumulator> getAccumulatorType() {
        try {
            Class<ListAggWithRetractAccumulator> clazz = ListAggWithRetractAccumulator.class;
            ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
            pojoFields.add(new PojoField(clazz.getDeclaredField("list"), new ListViewTypeInfo<StringData>(StringDataTypeInfo.INSTANCE)));
            pojoFields.add(new PojoField(clazz.getDeclaredField("retractList"), new ListViewTypeInfo<StringData>(StringDataTypeInfo.INSTANCE)));
            return new PojoTypeInfo(clazz, pojoFields);
        }
        catch (NoSuchFieldException e) {
            throw new WrappingRuntimeException((Throwable)e);
        }
    }

    @Override
    public ListAggWithRetractAccumulator createAccumulator() {
        return new ListAggWithRetractAccumulator();
    }

    public void accumulate(ListAggWithRetractAccumulator acc, StringData value) throws Exception {
        if (value != null) {
            acc.list.add(value);
        }
    }

    public void retract(ListAggWithRetractAccumulator acc, StringData value) throws Exception {
        if (value != null && !acc.list.remove(value)) {
            acc.retractList.add(value);
        }
    }

    public void merge(ListAggWithRetractAccumulator acc, Iterable<ListAggWithRetractAccumulator> its) throws Exception {
        for (ListAggWithRetractAccumulator otherAcc : its) {
            ArrayList<StringData> buffer = new ArrayList<StringData>();
            for (StringData stringData : acc.list.get()) {
                buffer.add(stringData);
            }
            for (StringData stringData : otherAcc.list.get()) {
                buffer.add(stringData);
            }
            ArrayList<StringData> retractBuffer = new ArrayList<StringData>();
            for (StringData binaryString3 : acc.retractList.get()) {
                retractBuffer.add(binaryString3);
            }
            for (StringData binaryString : otherAcc.retractList.get()) {
                retractBuffer.add(binaryString);
            }
            ArrayList<StringData> arrayList = new ArrayList<StringData>();
            for (StringData binaryString4 : retractBuffer) {
                if (buffer.remove(binaryString4)) continue;
                arrayList.add(binaryString4);
            }
            acc.list.clear();
            acc.list.addAll(buffer);
            acc.retractList.clear();
            acc.retractList.addAll(arrayList);
        }
    }

    @Override
    public StringData getValue(ListAggWithRetractAccumulator acc) {
        try {
            Iterable<StringData> accList = acc.list.get();
            if (accList == null || !accList.iterator().hasNext()) {
                return null;
            }
            return BinaryStringDataUtil.concatWs(lineDelimiter, accList);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ListAggWithRetractAccumulator acc) {
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ListAggWithRetractAccumulator {
        public ListView<StringData> list = new ListView(StringDataTypeInfo.INSTANCE);
        public ListView<StringData> retractList = new ListView(StringDataTypeInfo.INSTANCE);

        @VisibleForTesting
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListAggWithRetractAccumulator that = (ListAggWithRetractAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList);
        }
    }
}

