/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class FirstValueAggFunction<T>
extends AggregateFunction<T, GenericRowData> {
    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public GenericRowData createAccumulator() {
        GenericRowData acc = new GenericRowData(2);
        acc.setField(0, null);
        acc.setField(1, Long.MAX_VALUE);
        return acc;
    }

    public void accumulate(GenericRowData acc, Object value) {
        if (value != null && acc.getLong(1) == Long.MAX_VALUE) {
            acc.setField(0, value);
            acc.setField(1, System.currentTimeMillis());
        }
    }

    public void accumulate(GenericRowData acc, Object value, Long order) {
        if (value != null && acc.getLong(1) > order) {
            acc.setField(0, value);
            acc.setField(1, order);
        }
    }

    public void resetAccumulator(GenericRowData acc) {
        acc.setField(0, null);
        acc.setField(1, Long.MAX_VALUE);
    }

    @Override
    public T getValue(GenericRowData acc) {
        return (T)acc.getField(0);
    }

    @Override
    public TypeInformation<GenericRowData> getAccumulatorType() {
        LogicalType[] fieldTypes = new LogicalType[]{TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(this.getResultType()), new BigIntType()};
        String[] fieldNames = new String[]{"value", "time"};
        return new RowDataTypeInfo(fieldTypes, fieldNames);
    }

    public static class StringFirstValueAggFunction
    extends FirstValueAggFunction<StringData> {
        @Override
        public TypeInformation<StringData> getResultType() {
            return StringDataTypeInfo.INSTANCE;
        }

        public void accumulate(GenericRowData acc, StringData value) {
            if (value != null) {
                super.accumulate(acc, ((BinaryStringData)value).copy());
            }
        }

        public void accumulate(GenericRowData acc, StringData value, Long order) {
            if (value != null) {
                super.accumulate(acc, ((BinaryStringData)value).copy(), order);
            }
        }
    }

    public static class DecimalFirstValueAggFunction
    extends FirstValueAggFunction<DecimalData> {
        private DecimalDataTypeInfo decimalTypeInfo;

        public DecimalFirstValueAggFunction(DecimalDataTypeInfo decimalTypeInfo) {
            this.decimalTypeInfo = decimalTypeInfo;
        }

        public void accumulate(GenericRowData acc, DecimalData value) {
            super.accumulate(acc, value);
        }

        public void accumulate(GenericRowData acc, DecimalData value, Long order) {
            super.accumulate(acc, value, order);
        }

        @Override
        public TypeInformation<DecimalData> getResultType() {
            return this.decimalTypeInfo;
        }
    }

    public static class BooleanFirstValueAggFunction
    extends FirstValueAggFunction<Boolean> {
        @Override
        public TypeInformation<Boolean> getResultType() {
            return Types.BOOLEAN;
        }
    }

    public static class DoubleFirstValueAggFunction
    extends FirstValueAggFunction<Double> {
        @Override
        public TypeInformation<Double> getResultType() {
            return Types.DOUBLE;
        }
    }

    public static class FloatFirstValueAggFunction
    extends FirstValueAggFunction<Float> {
        @Override
        public TypeInformation<Float> getResultType() {
            return Types.FLOAT;
        }
    }

    public static class LongFirstValueAggFunction
    extends FirstValueAggFunction<Long> {
        @Override
        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }
    }

    public static class IntFirstValueAggFunction
    extends FirstValueAggFunction<Integer> {
        @Override
        public TypeInformation<Integer> getResultType() {
            return Types.INT;
        }
    }

    public static class ShortFirstValueAggFunction
    extends FirstValueAggFunction<Short> {
        @Override
        public TypeInformation<Short> getResultType() {
            return Types.SHORT;
        }
    }

    public static class ByteFirstValueAggFunction
    extends FirstValueAggFunction<Byte> {
        @Override
        public TypeInformation<Byte> getResultType() {
            return Types.BYTE;
        }
    }
}

