/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataview.MapViewTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.util.WrappingRuntimeException;

public class CollectAggFunction<T>
extends AggregateFunction<Map<T, Integer>, CollectAccumulator<T>> {
    private static final long serialVersionUID = -5860934997657147836L;
    private final TypeInformation<T> elementType;

    public CollectAggFunction(TypeInformation<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public CollectAccumulator<T> createAccumulator() {
        CollectAccumulator acc = new CollectAccumulator();
        acc.map = new MapView(this.elementType, Types.INT);
        return acc;
    }

    public void resetAccumulator(CollectAccumulator<T> accumulator) {
        accumulator.map.clear();
    }

    public void accumulate(CollectAccumulator<T> accumulator, T value) throws Exception {
        if (value != null) {
            Integer count = accumulator.map.get(value);
            if (count != null) {
                accumulator.map.put(value, count + 1);
            } else {
                accumulator.map.put(value, 1);
            }
        }
    }

    public void retract(CollectAccumulator<T> accumulator, T value) throws Exception {
        if (value != null) {
            Integer count = accumulator.map.get(value);
            if (count != null) {
                if (count == 1) {
                    accumulator.map.remove(value);
                } else {
                    accumulator.map.put(value, count - 1);
                }
            } else {
                accumulator.map.put(value, -1);
            }
        }
    }

    public void merge(CollectAccumulator<T> accumulator, Iterable<CollectAccumulator<T>> others) throws Exception {
        for (CollectAccumulator<T> other : others) {
            for (Map.Entry entry : other.map.entries()) {
                Object key = entry.getKey();
                Integer newCount = entry.getValue();
                Integer oldCount = accumulator.map.get(key);
                if (oldCount == null) {
                    accumulator.map.put(key, newCount);
                    continue;
                }
                accumulator.map.put(key, oldCount + newCount);
            }
        }
    }

    @Override
    public Map<T, Integer> getValue(CollectAccumulator<T> accumulator) {
        HashMap result = new HashMap();
        try {
            for (Map.Entry entry : accumulator.map.entries()) {
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TypeInformation<Map<T, Integer>> getResultType() {
        return new MapTypeInfo(this.elementType, Types.INT);
    }

    @Override
    public TypeInformation<CollectAccumulator<T>> getAccumulatorType() {
        try {
            Class<CollectAccumulator> clazz = CollectAccumulator.class;
            ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
            pojoFields.add(new PojoField(clazz.getDeclaredField("map"), new MapViewTypeInfo(this.elementType, BasicTypeInfo.INT_TYPE_INFO)));
            return new PojoTypeInfo(clazz, pojoFields);
        }
        catch (NoSuchFieldException e) {
            throw new WrappingRuntimeException((Throwable)e);
        }
    }

    public static class CollectAccumulator<T> {
        public MapView<T, Integer> map = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectAccumulator that = (CollectAccumulator)o;
            return Objects.equals(this.map, that.map);
        }
    }
}

