/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.SelectTableSink;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.delegation.StreamExecutor;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.StreamExecNode;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.ExecNodePlanDumper$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.sinks.StreamSelectTableSink;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import org.apache.flink.table.planner.utils.ExecutorUtils;
import org.apache.flink.table.planner.utils.PlanUtil$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001=\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005-\u0001F.\u00198oKJ\u0014\u0015m]3\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u0007\u0019I!A\u0007\r\u0003\u0011\u0015CXmY;u_JD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0007G>tg-[4\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011aA1qS&\u0011!e\b\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\rC\u0005%\u0001\t\u0005\t\u0015!\u0003&W\u0005ya-\u001e8di&|gnQ1uC2|w\r\u0005\u0002'S5\tqE\u0003\u0002)\r\u000591-\u0019;bY><\u0017B\u0001\u0016(\u0005=1UO\\2uS>t7)\u0019;bY><\u0017B\u0001\u0013\u0013\u0011%i\u0003A!A!\u0002\u0013q\u0013'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0019z\u0013B\u0001\u0019(\u00059\u0019\u0015\r^1m_\u001el\u0015M\\1hKJL!!\f\n\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\u0015)dg\u000e\u001d:!\t\t\u0002\u0001C\u0003\u0016e\u0001\u0007a\u0003C\u0003\u001de\u0001\u0007Q\u0004C\u0003%e\u0001\u0007Q\u0005C\u0003.e\u0001\u0007a\u0006C\u0003<\u0001\u0011EC(\u0001\u0007hKR$&/Y5u\t\u001647/F\u0001>!\rq\u0014iQ\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t)\u0011I\u001d:bsB\u0012AI\u0014\t\u0004\u000b*cU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00029mC:T!!\u0013\u0006\u0002\u000f\r\fGnY5uK&\u00111J\u0012\u0002\f%\u0016dGK]1ji\u0012+g\r\u0005\u0002N\u001d2\u0001A!C(;\u0003\u0003\u0005\tQ!\u0001Q\u0005\ryF%M\t\u0003#R\u0003\"A\u0010*\n\u0005M{$a\u0002(pi\"Lgn\u001a\t\u0003\u000bVK!A\u0016$\u0003\u0011I+G\u000e\u0016:bSRDQ\u0001\u0017\u0001\u0005Re\u000bAbZ3u\u001fB$\u0018.\\5{KJ,\u0012A\u0017\t\u00037~k\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001b\u001c9uS6L'0\u001a\u0006\u0003\u000f\u0012I!\u0001\u0019/\u0003\u0013=\u0003H/[7ju\u0016\u0014\b\"\u00022\u0001\t#\u001a\u0017a\u0004;sC:\u001cH.\u0019;f)>\u0004F.\u00198\u0015\u0005\u0011\\\bcA3kY6\taM\u0003\u0002hQ\u0006!Q\u000f^5m\u0015\u0005I\u0017\u0001\u00026bm\u0006L!a\u001b4\u0003\t1K7\u000f\u001e\u0019\u0003[V\u00042A\u001c:u\u001b\u0005y'B\u00019r\u0003\r!\u0017m\u001a\u0006\u0003A!I!a]8\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B\u0011Q*\u001e\u0003\nm\u0006\f\t\u0011!A\u0003\u0002]\u00141a\u0018\u00135#\t\t\u0006\u0010\u0005\u0002?s&\u0011!p\u0010\u0002\u0004\u0003:L\b\"\u0002?b\u0001\u0004i\u0018!C3yK\u000etu\u000eZ3t!\r)'N \u0019\u0006\u007f\u0006E\u0011q\u0003\t\t\u0003\u0003\tY!a\u0004\u0002\u00165\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003fq\u0016\u001c'bAA\u0005=\u0006)an\u001c3fg&!\u0011QBA\u0002\u0005!)\u00050Z2O_\u0012,\u0007cA'\u0002\u0012\u0011Q\u00111C>\u0002\u0002\u0003\u0005)\u0011A<\u0003\u0007}##\u0007E\u0002N\u0003/!!\"!\u0007|\u0003\u0003\u0005\tQ!\u0001x\u0005\ryFe\r\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003U\u0019'/Z1uKN+G.Z2u)\u0006\u0014G.Z*j].$B!!\t\u0002.A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(}\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003W\t)CA\bTK2,7\r\u001e+bE2,7+\u001b8l\u0011!\ty#a\u0007A\u0002\u0005E\u0012a\u0003;bE2,7k\u00195f[\u0006\u00042AHA\u001a\u0013\r\t)d\b\u0002\f)\u0006\u0014G.Z*dQ\u0016l\u0017\rC\u0004\u0002:\u0001!\t%a\u000f\u0002\u000f\u0015D\b\u000f\\1j]R1\u0011QHA*\u0003G\u0002B!a\u0010\u0002N9!\u0011\u0011IA%!\r\t\u0019eP\u0007\u0003\u0003\u000bR1!a\u0012\u000f\u0003\u0019a$o\\8u}%\u0019\u00111J \u0002\rA\u0013X\rZ3g\u0013\u0011\ty%!\u0015\u0003\rM#(/\u001b8h\u0015\r\tYe\u0010\u0005\t\u0003+\n9\u00041\u0001\u0002X\u0005Qq\u000e]3sCRLwN\\:\u0011\t\u0015T\u0017\u0011\f\t\u0005\u00037\ny&\u0004\u0002\u0002^)\u0019\u0011Q\u000b\u0004\n\t\u0005\u0005\u0014Q\f\u0002\n\u001fB,'/\u0019;j_:D\u0001\"!\u001a\u00028\u0001\u0007\u0011qM\u0001\rKb$(/\u0019#fi\u0006LGn\u001d\t\u0006}\u0005%\u0014QN\u0005\u0004\u0003Wz$A\u0003\u001fsKB,\u0017\r^3e}A\u0019a$a\u001c\n\u0007\u0005EtDA\u0007FqBd\u0017-\u001b8EKR\f\u0017\u000e\u001c\u0005\b\u0003k\u0002A\u0011BA<\u0003I\u0019'/Z1uK\u0012+X.\\=QY\u0006tg.\u001a:\u0015\u0003U\u0002")
public class StreamPlanner
extends PlannerBase {
    private final TableConfig config;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), MiniBatchIntervalTraitDef$.MODULE$.INSTANCE(), ModifyKindSetTraitDef$.MODULE$.INSTANCE(), UpdateKindTraitDef$.MODULE$.INSTANCE()});
    }

    @Override
    public Optimizer getOptimizer() {
        return new StreamCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public List<Transformation<?>> translateToPlan(List<ExecNode<?, ?>> execNodes) {
        StreamPlanner planner = this.createDummyPlanner();
        planner.overrideEnvParallelism();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execNodes).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecNode execNode = x0$2;
            if (!(execNode instanceof StreamExecNode)) {
                throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            StreamExecNode streamExecNode = (StreamExecNode)execNode;
            Transformation transformation = streamExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public SelectTableSink createSelectTableSink(TableSchema tableSchema) {
        return new StreamSelectTableSink(tableSchema);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            RelNode relNode;
            Operation operation = x0$3;
            if (operation instanceof QueryOperation) {
                RelNode relNode2;
                QueryOperation queryOperation = (QueryOperation)operation;
                RelNode relNode3 = this.getRelBuilder().queryOperation(queryOperation).build();
                RelNode relNode4 = relNode3;
                if (relNode4 instanceof LogicalTableModify) {
                    LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                    List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                    Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0 & Serializable & scala.Serializable)() -> "the length of qualified name should be 3.");
                    CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of(qualifiedName.get(0), qualifiedName.get(1), qualifiedName.get(2)), new PlannerQueryOperation(logicalTableModify.getInput()));
                    relNode2 = this.translateToRel(modifyOperation);
                } else {
                    relNode2 = relNode3;
                }
                relNode = relNode2;
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                relNode = this.translateToRel(modifyOperation);
            } else {
                throw new TableException(new java.lang.StringBuilder(23).append("Unsupported operation: ").append(operation.getClass().getCanonicalName()).toString());
            }
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        List<ExecNode<?, ?>> execNodes = this.translateToExecNodePlan(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execNodes);
        StreamGraph streamGraph = ExecutorUtils.generateStreamGraph(this.getExecEnv(), transformations);
        String executionPlan = PlanUtil$.MODULE$.explainStreamGraph(streamGraph);
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Logical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.DIGEST_ATTRIBUTES;
        boolean withChangelogTraits = extraDetails.contains((Object)ExplainDetail.CHANGELOG_MODE);
        Buffer x$1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execNodes);
        SqlExplainLevel x$2 = explainLevel;
        boolean x$3 = withChangelogTraits;
        boolean x$4 = ExecNodePlanDumper$.MODULE$.dagToString$default$3();
        boolean x$5 = ExecNodePlanDumper$.MODULE$.dagToString$default$5();
        boolean x$6 = ExecNodePlanDumper$.MODULE$.dagToString$default$6();
        sb.append(ExecNodePlanDumper$.MODULE$.dagToString((Seq<ExecNode<?, ?>>)x$1, x$2, x$4, x$3, x$5, x$6));
        sb.append(System.lineSeparator());
        sb.append("== Physical Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(executionPlan);
        return sb.toString();
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        StreamExecutor executor = new StreamExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.config, super.functionCatalog(), super.catalogManager());
    }

    @Override
    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.config = config;
        super(executor, config, functionCatalog, catalogManager, true);
    }
}

