/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TemporalTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Option;

public class CatalogSchemaTable
extends AbstractTable
implements TemporalTable {
    private final ObjectIdentifier tableIdentifier;
    private final CatalogManager.TableLookupResult lookupResult;
    private final FlinkStatistic statistic;
    private final boolean isStreamingMode;
    private final Catalog catalog;

    public CatalogSchemaTable(ObjectIdentifier tableIdentifier, CatalogManager.TableLookupResult lookupResult, FlinkStatistic statistic, Catalog catalog, boolean isStreaming) {
        this.tableIdentifier = tableIdentifier;
        this.lookupResult = lookupResult;
        this.statistic = statistic;
        this.catalog = catalog;
        this.isStreamingMode = isStreaming;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public CatalogBaseTable getCatalogTable() {
        return this.lookupResult.getTable();
    }

    public boolean isTemporary() {
        return this.lookupResult.isTemporary();
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        TableSource<?> source;
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        TableSchema tableSchema = this.lookupResult.getResolvedSchema();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        CatalogBaseTable catalogTable = this.lookupResult.getTable();
        if (!this.isStreamingMode && catalogTable instanceof ConnectorCatalogTable && ((ConnectorCatalogTable)catalogTable).getTableSource().isPresent()) {
            for (int i = 0; i < fieldDataTypes.length; ++i) {
                LogicalType lt = fieldDataTypes[i].getLogicalType();
                if (!(lt instanceof TimestampType) || ((TimestampType)lt).getKind() != TimestampKind.PROCTIME && ((TimestampType)lt).getKind() != TimestampKind.ROWTIME) continue;
                int precision = ((TimestampType)lt).getPrecision();
                fieldDataTypes[i] = DataTypes.TIMESTAMP(precision);
            }
        }
        Optional<TableSource<?>> sourceOpt = this.findAndCreateTableSource();
        if (this.isStreamingMode && tableSchema.getTableColumns().stream().noneMatch(TableColumn::isGenerated) && tableSchema.getWatermarkSpecs().isEmpty() && sourceOpt.isPresent() && (TableSourceValidation.hasProctimeAttribute(source = sourceOpt.get()) || TableSourceValidation.hasRowtimeAttribute(source))) {
            tableSchema = ConnectorCatalogTable.calculateSourceSchema(source, false);
        }
        return TableSourceUtil.getSourceRowType(flinkTypeFactory, tableSchema, Option.empty(), this.isStreamingMode);
    }

    @Override
    public FlinkStatistic getStatistic() {
        return this.statistic;
    }

    @Override
    public String getSysStartFieldName() {
        return "sys_start";
    }

    @Override
    public String getSysEndFieldName() {
        return "sys_end";
    }

    private Optional<TableSource<?>> findAndCreateTableSource() {
        Optional<TableSource<Object>> tableSource;
        block4: {
            tableSource = Optional.empty();
            try {
                if (!(this.lookupResult.getTable() instanceof CatalogTable)) break block4;
                Configuration config = new Configuration();
                TableSourceFactoryContextImpl context = new TableSourceFactoryContextImpl(this.tableIdentifier, (CatalogTable)this.lookupResult.getTable(), (ReadableConfig)config);
                TableSource source = TableFactoryUtil.findAndCreateTableSource(context);
                if (source instanceof StreamTableSource) {
                    if (!this.isStreamingMode && !((StreamTableSource)source).isBounded()) {
                        throw new ValidationException("Cannot query on an unbounded source in batch mode, but " + this.tableIdentifier.asSummaryString() + " is unbounded.");
                    }
                    tableSource = Optional.of(source);
                    break block4;
                }
                throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource.");
            }
            catch (Exception e) {
                tableSource = Optional.empty();
            }
        }
        return tableSource;
    }
}

