/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class UserDefinedFunctionHelper {
    public static final String SCALAR_EVAL = "eval";
    public static final String TABLE_EVAL = "eval";
    public static final String AGGREGATE_ACCUMULATE = "accumulate";
    public static final String AGGREGATE_RETRACT = "retract";
    public static final String AGGREGATE_MERGE = "merge";
    public static final String AGGREGATE_RESET = "resetAccumulator";
    public static final String TABLE_AGGREGATE_ACCUMULATE = "accumulate";
    public static final String TABLE_AGGREGATE_RETRACT = "retract";
    public static final String TABLE_AGGREGATE_EMIT = "emitValue";
    public static final String TABLE_AGGREGATE_EMIT_RETRACT = "emitUpdateWithRetract";
    public static final String ASYNC_TABLE_EVAL = "eval";

    public static <T, ACC> TypeInformation<T> getReturnTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction) {
        return UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(aggregateFunction, null);
    }

    public static <T, ACC> TypeInformation<T> getReturnTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction, TypeInformation<T> scalaType) {
        TypeInformation<T> userProvidedType = aggregateFunction.getResultType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(aggregateFunction, UserDefinedAggregateFunction.class, aggregateFunction.getClass(), (int)0);
    }

    public static <T, ACC> TypeInformation<ACC> getAccumulatorTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction) {
        return UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(aggregateFunction, null);
    }

    public static <T, ACC> TypeInformation<ACC> getAccumulatorTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction, TypeInformation<ACC> scalaType) {
        TypeInformation<ACC> userProvidedType = aggregateFunction.getAccumulatorType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(aggregateFunction, UserDefinedAggregateFunction.class, aggregateFunction.getClass(), (int)1);
    }

    public static <T> TypeInformation<T> getReturnTypeOfTableFunction(TableFunction<T> tableFunction) {
        return UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tableFunction, null);
    }

    public static <T> TypeInformation<T> getReturnTypeOfTableFunction(TableFunction<T> tableFunction, TypeInformation<T> scalaType) {
        TypeInformation<T> userProvidedType = tableFunction.getResultType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(tableFunction, TableFunction.class, tableFunction.getClass(), (int)0);
    }

    public static UserDefinedFunction instantiateFunction(Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunctionHelper.validateClass(functionClass, true);
        try {
            return functionClass.newInstance();
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Cannot instantiate user-defined function class '%s'.", functionClass.getName()), e);
        }
    }

    public static void prepareInstance(ReadableConfig config, UserDefinedFunction function) {
        UserDefinedFunctionHelper.validateClass(function.getClass(), false);
        UserDefinedFunctionHelper.cleanFunction(config, function);
    }

    public static void validateClass(Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunctionHelper.validateClass(functionClass, true);
    }

    private static void validateClass(Class<? extends UserDefinedFunction> functionClass, boolean requiresDefaultConstructor) {
        if (TableFunction.class.isAssignableFrom(functionClass)) {
            UserDefinedFunctionHelper.validateNotSingleton(functionClass);
        }
        UserDefinedFunctionHelper.validateInstantiation(functionClass, requiresDefaultConstructor);
        UserDefinedFunctionHelper.validateImplementationMethods(functionClass);
    }

    private static void validateNotSingleton(Class<?> clazz) {
        if (Arrays.stream(clazz.getFields()).anyMatch(f -> f.getName().equals("MODULE$"))) {
            throw new ValidationException(String.format("Function implemented by class %s is a Scala object. This is forbidden because of concurrency problems when using them.", clazz.getName()));
        }
    }

    private static void validateImplementationMethods(Class<? extends UserDefinedFunction> functionClass) {
        if (ScalarFunction.class.isAssignableFrom(functionClass)) {
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, false, false, "eval");
        } else if (TableFunction.class.isAssignableFrom(functionClass)) {
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, false, "eval");
        } else if (AggregateFunction.class.isAssignableFrom(functionClass)) {
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, false, "accumulate");
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, true, "retract");
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, true, AGGREGATE_MERGE);
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, true, AGGREGATE_RESET);
        } else if (TableAggregateFunction.class.isAssignableFrom(functionClass)) {
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, false, "accumulate");
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, true, "retract");
            UserDefinedFunctionHelper.validateImplementationMethod(functionClass, true, false, TABLE_AGGREGATE_EMIT, TABLE_AGGREGATE_EMIT_RETRACT);
        }
    }

    private static void validateImplementationMethod(Class<? extends UserDefinedFunction> clazz, boolean rejectStatic, boolean isOptional, String ... methodNameOptions) {
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(methodNameOptions));
        List methods = TypeExtractionUtils.getAllDeclaredMethods(clazz);
        boolean found = false;
        for (Method method : methods) {
            if (!nameSet.contains(method.getName())) continue;
            found = true;
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier)) {
                throw new ValidationException(String.format("Method '%s' of function class '%s' is not public.", method.getName(), clazz.getName()));
            }
            if (Modifier.isAbstract(modifier)) {
                throw new ValidationException(String.format("Method '%s' of function class '%s' must not be abstract.", method.getName(), clazz.getName()));
            }
            if (!rejectStatic || !Modifier.isStatic(modifier)) continue;
            throw new ValidationException(String.format("Method '%s' of function class '%s' must not be static.", method.getName(), clazz.getName()));
        }
        if (!found && !isOptional) {
            throw new ValidationException(String.format("Function class '%s' does not implement a method named %s.", clazz.getName(), nameSet.stream().map(s -> "'" + s + "'").collect(Collectors.joining(" or "))));
        }
    }

    private static void validateInstantiation(Class<?> clazz, boolean requiresDefaultConstructor) {
        if (!InstantiationUtil.isPublic(clazz)) {
            throw new ValidationException(String.format("Function class '%s' is not public.", clazz.getName()));
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            throw new ValidationException(String.format("Function class '%s' is not a proper class. It is either abstract, an interface, or a primitive type.", clazz.getName()));
        }
        if (requiresDefaultConstructor && !InstantiationUtil.hasPublicNullaryConstructor(clazz)) {
            throw new ValidationException(String.format("Function class '%s' must have a public default constructor.", clazz.getName()));
        }
    }

    private static void cleanFunction(ReadableConfig config, UserDefinedFunction function) {
        ExecutionConfig.ClosureCleanerLevel level = (ExecutionConfig.ClosureCleanerLevel)config.get(PipelineOptions.CLOSURE_CLEANER_LEVEL);
        try {
            ClosureCleaner.clean((Object)function, (ExecutionConfig.ClosureCleanerLevel)level, (boolean)true);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Function class '%s' is not serializable. Make sure that the class is self-contained (i.e. no references to outer classes) and all inner fields are serializable as well.", function.getClass()), t);
        }
    }

    private UserDefinedFunctionHelper() {
    }
}

