/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.io.File;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.MetricGroup;

@PublicEvolving
public class FunctionContext {
    private RuntimeContext context;

    public FunctionContext(RuntimeContext context) {
        this.context = context;
    }

    public MetricGroup getMetricGroup() {
        return this.context.getMetricGroup();
    }

    public File getCachedFile(String name) {
        return this.context.getDistributedCache().getFile(name);
    }

    public String getJobParameter(String key, String defaultValue) {
        ExecutionConfig.GlobalJobParameters conf = this.context.getExecutionConfig().getGlobalJobParameters();
        if (conf != null && conf.toMap().containsKey(key)) {
            return (String)conf.toMap().get(key);
        }
        return defaultValue;
    }

    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        return this.context.getExternalResourceInfos(resourceName);
    }
}

