/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.types.Row;

@Internal
public class RowPartitionComputer
implements PartitionComputer<Row> {
    private static final long serialVersionUID = 1L;
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    private final int[] nonPartitionIndexes;
    protected final int[] partitionIndexes;

    public RowPartitionComputer(String defaultPartValue, String[] columnNames, String[] partitionColumns) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        List<String> columnList = Arrays.asList(columnNames);
        this.partitionIndexes = Arrays.stream(partitionColumns).mapToInt(columnList::indexOf).toArray();
        List partitionIndexList = Arrays.stream(this.partitionIndexes).boxed().collect(Collectors.toList());
        this.nonPartitionIndexes = IntStream.range(0, columnNames.length).filter(c -> !partitionIndexList.contains(c)).toArray();
    }

    @Override
    public LinkedHashMap<String, String> generatePartValues(Row in) throws Exception {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionIndexes.length; ++i) {
            String partitionValue;
            int index = this.partitionIndexes[i];
            Object field = in.getField(index);
            String string = partitionValue = field != null ? field.toString() : null;
            if (partitionValue == null || "".equals(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }

    @Override
    public Row projectColumnsToWrite(Row in) {
        return this.partitionIndexes.length == 0 ? in : Row.project((Row)in, (int[])this.nonPartitionIndexes);
    }

    public static Object restorePartValueFromType(String valStr, DataType type) {
        if (valStr == null) {
            return null;
        }
        LogicalTypeRoot typeRoot = type.getLogicalType().getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: {
                return valStr;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(valStr);
            }
            case TINYINT: {
                return Integer.valueOf(valStr).byteValue();
            }
            case SMALLINT: {
                return Short.valueOf(valStr);
            }
            case INTEGER: {
                return Integer.valueOf(valStr);
            }
            case BIGINT: {
                return Long.valueOf(valStr);
            }
            case FLOAT: {
                return Float.valueOf(valStr);
            }
            case DOUBLE: {
                return Double.valueOf(valStr);
            }
            case DATE: {
                return LocalDate.parse(valStr);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return LocalDateTime.parse(valStr);
            }
        }
        throw new RuntimeException(String.format("Can not convert %s to type %s for partition value", valStr, type));
    }
}

