/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.LinkedHashMap;
import org.apache.flink.table.filesystem.PartitionCommitPolicy;
import org.apache.flink.table.filesystem.TableMetaStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreCommitPolicy
implements PartitionCommitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreCommitPolicy.class);
    private TableMetaStoreFactory.TableMetaStore metaStore;

    public void setMetastore(TableMetaStoreFactory.TableMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    @Override
    public void commit(PartitionCommitPolicy.Context context) throws Exception {
        LinkedHashMap<String, String> partitionSpec = context.partitionSpec();
        this.metaStore.createOrAlterPartition(partitionSpec, context.partitionPath());
        LOG.info("Committed partition {} to metastore", partitionSpec);
    }
}

