/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.InputFormatSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.filesystem.FileSystemTableFactory;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.LimitableTableSource;
import org.apache.flink.table.sources.PartitionableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.table.utils.TableConnectorUtils;

public class FileSystemTableSource
implements StreamTableSource<RowData>,
PartitionableTableSource,
ProjectableTableSource<RowData>,
LimitableTableSource<RowData>,
FilterableTableSource<RowData> {
    private final TableSchema schema;
    private final Path path;
    private final List<String> partitionKeys;
    private final String defaultPartName;
    private final Map<String, String> properties;
    private final int[] selectFields;
    private final Long limit;
    private final List<Expression> filters;
    private List<Map<String, String>> readPartitions;

    public FileSystemTableSource(TableSchema schema, Path path, List<String> partitionKeys, String defaultPartName, Map<String, String> properties) {
        this(schema, path, partitionKeys, defaultPartName, properties, null, null, null, null);
    }

    private FileSystemTableSource(TableSchema schema, Path path, List<String> partitionKeys, String defaultPartName, Map<String, String> properties, List<Map<String, String>> readPartitions, int[] selectFields, Long limit, List<Expression> filters) {
        this.schema = schema;
        this.path = path;
        this.partitionKeys = partitionKeys;
        this.defaultPartName = defaultPartName;
        this.properties = properties;
        this.readPartitions = readPartitions;
        this.selectFields = selectFields;
        this.limit = limit;
        this.filters = filters;
    }

    @Override
    public DataStream<RowData> getDataStream(StreamExecutionEnvironment execEnv) {
        TypeInformation<?> typeInfo = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(this.getProducedDataType());
        InputFormatSourceFunction func = new InputFormatSourceFunction(this.getInputFormat(), typeInfo);
        DataStreamSource source = execEnv.addSource((SourceFunction)func, this.explainSource(), typeInfo);
        return source.name(this.explainSource());
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    private InputFormat<RowData, ?> getInputFormat() {
        if (!this.partitionKeys.isEmpty() && this.getOrFetchPartitions().isEmpty()) {
            return new CollectionInputFormat(new ArrayList(), null);
        }
        final FileSystemFormatFactory formatFactory = FileSystemTableFactory.createFormatFactory(this.properties);
        final Configuration conf = new Configuration();
        this.properties.forEach((arg_0, arg_1) -> ((Configuration)conf).setString(arg_0, arg_1));
        return formatFactory.createReader(new FileSystemFormatFactory.ReaderContext(){

            @Override
            public TableSchema getSchema() {
                return FileSystemTableSource.this.schema;
            }

            @Override
            public ReadableConfig getFormatOptions() {
                return new DelegatingConfiguration(conf, formatFactory.factoryIdentifier() + ".");
            }

            @Override
            public List<String> getPartitionKeys() {
                return FileSystemTableSource.this.partitionKeys;
            }

            @Override
            public String getDefaultPartName() {
                return FileSystemTableSource.this.defaultPartName;
            }

            @Override
            public Path[] getPaths() {
                if (FileSystemTableSource.this.partitionKeys.isEmpty()) {
                    return new Path[]{FileSystemTableSource.this.path};
                }
                return (Path[])FileSystemTableSource.this.getOrFetchPartitions().stream().map(x$0 -> FileSystemTableSource.this.toFullLinkedPartSpec(x$0)).map(PartitionPathUtils::generatePartitionPath).map(n -> new Path(FileSystemTableSource.this.path, n)).toArray(Path[]::new);
            }

            @Override
            public int[] getProjectFields() {
                return FileSystemTableSource.this.readFields();
            }

            @Override
            public long getPushedDownLimit() {
                return FileSystemTableSource.this.limit == null ? Long.MAX_VALUE : FileSystemTableSource.this.limit;
            }

            @Override
            public List<Expression> getPushedDownFilters() {
                return FileSystemTableSource.this.filters == null ? Collections.emptyList() : FileSystemTableSource.this.filters;
            }
        });
    }

    private List<Map<String, String>> getOrFetchPartitions() {
        if (this.readPartitions == null) {
            this.readPartitions = this.getPartitions();
        }
        return this.readPartitions;
    }

    private LinkedHashMap<String, String> toFullLinkedPartSpec(Map<String, String> part) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String k : this.partitionKeys) {
            if (!part.containsKey(k)) {
                throw new TableException("Partition keys are: " + this.partitionKeys + ", incomplete partition spec: " + part);
            }
            map.put(k, part.get(k));
        }
        return map;
    }

    @Override
    public List<Map<String, String>> getPartitions() {
        try {
            return PartitionPathUtils.searchPartSpecAndPaths(this.path.getFileSystem(), this.path, this.partitionKeys.size()).stream().map(tuple2 -> (LinkedHashMap)tuple2.f0).map(spec -> {
                LinkedHashMap ret = new LinkedHashMap();
                spec.forEach((k, v) -> ret.put(k, this.defaultPartName.equals(v) ? null : v));
                return ret;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new TableException("Fetch partitions fail.", e);
        }
    }

    @Override
    public FileSystemTableSource applyPartitionPruning(List<Map<String, String>> remainingPartitions) {
        return new FileSystemTableSource(this.schema, this.path, this.partitionKeys, this.defaultPartName, this.properties, remainingPartitions, this.selectFields, this.limit, this.filters);
    }

    public FileSystemTableSource projectFields(int[] fields) {
        return new FileSystemTableSource(this.schema, this.path, this.partitionKeys, this.defaultPartName, this.properties, this.readPartitions, fields, this.limit, this.filters);
    }

    public FileSystemTableSource applyLimit(long limit) {
        return new FileSystemTableSource(this.schema, this.path, this.partitionKeys, this.defaultPartName, this.properties, this.readPartitions, this.selectFields, limit, this.filters);
    }

    @Override
    public boolean isLimitPushedDown() {
        return this.limit != null;
    }

    public FileSystemTableSource applyPredicate(List<Expression> predicates) {
        return new FileSystemTableSource(this.schema, this.path, this.partitionKeys, this.defaultPartName, this.properties, this.readPartitions, this.selectFields, this.limit, new ArrayList<Expression>(predicates));
    }

    @Override
    public boolean isFilterPushedDown() {
        return this.filters != null;
    }

    private int[] readFields() {
        return this.selectFields == null ? IntStream.range(0, this.schema.getFieldCount()).toArray() : this.selectFields;
    }

    @Override
    public DataType getProducedDataType() {
        int[] fields = this.readFields();
        String[] schemaFieldNames = this.schema.getFieldNames();
        DataType[] schemaTypes = this.schema.getFieldDataTypes();
        return (DataType)DataTypes.ROW((DataTypes.Field[])Arrays.stream(fields).mapToObj(i -> DataTypes.FIELD(schemaFieldNames[i], schemaTypes[i])).toArray(DataTypes.Field[]::new)).bridgedTo(RowData.class);
    }

    @Override
    public TableSchema getTableSchema() {
        return this.schema;
    }

    @Override
    public String explainSource() {
        return TableConnectorUtils.generateRuntimeName(this.getClass(), this.getTableSchema().getFieldNames()) + (this.readPartitions == null ? "" : ", readPartitions=" + this.readPartitions) + (this.selectFields == null ? "" : ", selectFields=" + Arrays.toString(this.selectFields)) + (this.limit == null ? "" : ", limit=" + this.limit) + (this.filters == null ? "" : ", filters=" + this.filtersString());
    }

    private String filtersString() {
        return this.filters.stream().map(Expression::asSummaryString).collect(Collectors.joining(","));
    }
}

