/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.FileSystemTableSink;
import org.apache.flink.table.filesystem.FileSystemTableSource;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.TableSchemaUtils;

public class FileSystemTableFactory
implements TableSourceFactory<RowData>,
TableSinkFactory<RowData> {
    public static final String IDENTIFIER = "filesystem";

    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector", IDENTIFIER);
        return context;
    }

    @Override
    public List<String> supportedProperties() {
        return Collections.singletonList("*");
    }

    @Override
    public TableSource<RowData> createTableSource(TableSourceFactory.Context context) {
        Configuration conf = new Configuration();
        context.getTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)conf).setString(arg_0, arg_1));
        return new FileSystemTableSource(TableSchemaUtils.getPhysicalSchema(context.getTable().getSchema()), FileSystemTableFactory.getPath(conf), context.getTable().getPartitionKeys(), (String)conf.get(FileSystemOptions.PARTITION_DEFAULT_NAME), context.getTable().getProperties());
    }

    @Override
    public TableSink<RowData> createTableSink(TableSinkFactory.Context context) {
        Configuration conf = new Configuration();
        context.getTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)conf).setString(arg_0, arg_1));
        return new FileSystemTableSink(context.getObjectIdentifier(), context.isBounded(), TableSchemaUtils.getPhysicalSchema(context.getTable().getSchema()), FileSystemTableFactory.getPath(conf), context.getTable().getPartitionKeys(), (String)conf.get(FileSystemOptions.PARTITION_DEFAULT_NAME), context.getTable().getOptions());
    }

    private static Path getPath(Configuration conf) {
        return new Path((String)conf.getOptional(FileSystemOptions.PATH).orElseThrow(() -> new ValidationException("Path should be not empty.")));
    }

    public static FileSystemFormatFactory createFormatFactory(Map<String, String> properties) {
        String format = properties.get("format");
        if (format == null) {
            throw new ValidationException(String.format("Table options do not contain an option key '%s' for discovering a format.", "format"));
        }
        return FactoryUtil.discoverFactory(Thread.currentThread().getContextClassLoader(), FileSystemFormatFactory.class, format);
    }
}

