/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RawType;

@Internal
public class RawObjectConverter<T>
implements DataStructureConverter<RawValueData<T>, T> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;

    private RawObjectConverter(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public RawValueData<T> toInternal(T external) {
        return RawValueData.fromObject(external);
    }

    @Override
    public T toExternal(RawValueData<T> internal) {
        return internal.toObject(this.serializer);
    }

    public static RawObjectConverter<?> create(DataType dataType) {
        TypeSerializer serializer = ((RawType)dataType.getLogicalType()).getTypeSerializer();
        return new RawObjectConverter(serializer);
    }
}

