/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.utils.PrintUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

@Internal
class TableResultImpl
implements TableResult {
    public static final TableResult TABLE_RESULT_OK = TableResultImpl.builder().resultKind(ResultKind.SUCCESS).tableSchema(TableSchema.builder().field("result", DataTypes.STRING()).build()).data(Collections.singletonList(Row.of((Object[])new Object[]{"OK"}))).build();
    private final JobClient jobClient;
    private final TableSchema tableSchema;
    private final ResultKind resultKind;
    private final CloseableIterator<Row> data;
    private final PrintStyle printStyle;

    private TableResultImpl(@Nullable JobClient jobClient, TableSchema tableSchema, ResultKind resultKind, CloseableIterator<Row> data, PrintStyle printStyle) {
        this.jobClient = jobClient;
        this.tableSchema = (TableSchema)Preconditions.checkNotNull((Object)tableSchema, (String)"tableSchema should not be null");
        this.resultKind = (ResultKind)((Object)Preconditions.checkNotNull((Object)((Object)resultKind), (String)"resultKind should not be null"));
        this.data = (CloseableIterator)Preconditions.checkNotNull(data, (String)"data should not be null");
        this.printStyle = (PrintStyle)Preconditions.checkNotNull((Object)printStyle, (String)"printStyle should not be null");
    }

    @Override
    public Optional<JobClient> getJobClient() {
        return Optional.ofNullable(this.jobClient);
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public ResultKind getResultKind() {
        return this.resultKind;
    }

    @Override
    public CloseableIterator<Row> collect() {
        return this.data;
    }

    @Override
    public void print() {
        CloseableIterator<Row> it = this.collect();
        if (this.printStyle instanceof TableauStyle) {
            int maxColumnWidth = ((TableauStyle)this.printStyle).getMaxColumnWidth();
            String nullColumn = ((TableauStyle)this.printStyle).getNullColumn();
            boolean deriveColumnWidthByType = ((TableauStyle)this.printStyle).isDeriveColumnWidthByType();
            PrintUtils.printAsTableauForm(this.getTableSchema(), it, new PrintWriter(System.out), maxColumnWidth, nullColumn, deriveColumnWidthByType);
        } else if (this.printStyle instanceof RawContentStyle) {
            while (it.hasNext()) {
                System.out.println(String.join((CharSequence)",", PrintUtils.rowToString((Row)it.next())));
            }
        } else {
            throw new TableException("Unsupported print style: " + this.printStyle);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class RawContentStyle
    implements PrintStyle {
        private RawContentStyle() {
        }
    }

    private static final class TableauStyle
    implements PrintStyle {
        private final boolean deriveColumnWidthByType;
        private final int maxColumnWidth;
        private final String nullColumn;

        private TableauStyle(int maxColumnWidth, String nullColumn, boolean deriveColumnWidthByType) {
            this.deriveColumnWidthByType = deriveColumnWidthByType;
            this.maxColumnWidth = maxColumnWidth;
            this.nullColumn = nullColumn;
        }

        public boolean isDeriveColumnWidthByType() {
            return this.deriveColumnWidthByType;
        }

        int getMaxColumnWidth() {
            return this.maxColumnWidth;
        }

        String getNullColumn() {
            return this.nullColumn;
        }
    }

    public static interface PrintStyle {
        public static PrintStyle tableau(int maxColumnWidth, String nullColumn, boolean deriveColumnWidthByType) {
            Preconditions.checkArgument((maxColumnWidth > 0 ? 1 : 0) != 0, (Object)"maxColumnWidth should be greater than 0");
            Preconditions.checkNotNull((Object)nullColumn, (String)"nullColumn should not be null");
            return new TableauStyle(maxColumnWidth, nullColumn, deriveColumnWidthByType);
        }

        public static PrintStyle rawContent() {
            return new RawContentStyle();
        }
    }

    public static class Builder {
        private JobClient jobClient = null;
        private TableSchema tableSchema = null;
        private ResultKind resultKind = null;
        private CloseableIterator<Row> data = null;
        private PrintStyle printStyle = PrintStyle.tableau(Integer.MAX_VALUE, "(NULL)", false);

        private Builder() {
        }

        public Builder jobClient(JobClient jobClient) {
            this.jobClient = jobClient;
            return this;
        }

        public Builder tableSchema(TableSchema tableSchema) {
            Preconditions.checkNotNull((Object)tableSchema, (String)"tableSchema should not be null");
            this.tableSchema = tableSchema;
            return this;
        }

        public Builder resultKind(ResultKind resultKind) {
            Preconditions.checkNotNull((Object)((Object)resultKind), (String)"resultKind should not be null");
            this.resultKind = resultKind;
            return this;
        }

        public Builder data(CloseableIterator<Row> rowIterator) {
            Preconditions.checkNotNull(rowIterator, (String)"rowIterator should not be null");
            this.data = rowIterator;
            return this;
        }

        public Builder data(List<Row> rowList) {
            Preconditions.checkNotNull(rowList, (String)"listRows should not be null");
            this.data = CloseableIterator.adapterForIterator(rowList.iterator());
            return this;
        }

        public Builder setPrintStyle(PrintStyle printStyle) {
            Preconditions.checkNotNull((Object)printStyle, (String)"printStyle should not be null");
            this.printStyle = printStyle;
            return this;
        }

        public TableResult build() {
            return new TableResultImpl(this.jobClient, this.tableSchema, this.resultKind, this.data, this.printStyle);
        }
    }
}

