/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.flink.annotation.Internal;

@Internal
public final class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        RelDataType type = this.validator.deriveTypeImpl(this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        SqlCallBinding callBinding = new SqlCallBinding(this.validator, this.scope, this.call);
        if (operator instanceof SqlUserDefinedFunction) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table function should have CURSOR type, not " + type;
            SqlUserDefinedTableFunction udf = (SqlUserDefinedTableFunction)operator;
            return udf.getRowType(this.validator.typeFactory, callBinding.operands());
        }
        if (SqlUtil.stripAs(this.enclosingNode).getKind() == SqlKind.COLLECTION_TABLE) {
            return this.toStruct(type, this.getNode());
        }
        return type;
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }
}

