/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.AbstractEnumerable2;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableOrderedQueryable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.ExtendedEnumerable;
import org.apache.calcite.linq4j.Extensions;
import org.apache.calcite.linq4j.Grouping;
import org.apache.calcite.linq4j.JoinType;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Lookup;
import org.apache.calcite.linq4j.LookupImpl;
import org.apache.calcite.linq4j.OrderedEnumerable;
import org.apache.calcite.linq4j.OrderedQueryable;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.TransformedEnumerator;
import org.apache.calcite.linq4j.function.BigDecimalFunction1;
import org.apache.calcite.linq4j.function.DoubleFunction1;
import org.apache.calcite.linq4j.function.EqualityComparer;
import org.apache.calcite.linq4j.function.FloatFunction1;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.function.IntegerFunction1;
import org.apache.calcite.linq4j.function.LongFunction1;
import org.apache.calcite.linq4j.function.NullableBigDecimalFunction1;
import org.apache.calcite.linq4j.function.NullableDoubleFunction1;
import org.apache.calcite.linq4j.function.NullableFloatFunction1;
import org.apache.calcite.linq4j.function.NullableIntegerFunction1;
import org.apache.calcite.linq4j.function.NullableLongFunction1;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.flink.calcite.shaded.com.google.common.base.Supplier;
import org.apache.flink.calcite.shaded.com.google.common.base.Suppliers;
import org.apache.flink.calcite.shaded.com.google.common.collect.HashMultiset;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;

public abstract class EnumerableDefaults {
    private static final Object DUMMY = new Object();

    public static <TSource> TSource aggregate(Enumerable<TSource> source, Function2<TSource, TSource, TSource> func) {
        Object result = null;
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                result = func.apply(result, o);
            }
            Object T0 = result;
            return (TSource)T0;
        }
    }

    public static <TSource, TAccumulate> TAccumulate aggregate(Enumerable<TSource> source, TAccumulate seed, Function2<TAccumulate, TSource, TAccumulate> func) {
        TAccumulate result = seed;
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                result = func.apply(result, o);
            }
            TAccumulate TAccumulate = result;
            return TAccumulate;
        }
    }

    public static <TSource, TAccumulate, TResult> TResult aggregate(Enumerable<TSource> source, TAccumulate seed, Function2<TAccumulate, TSource, TAccumulate> func, Function1<TAccumulate, TResult> selector) {
        TAccumulate accumulate = seed;
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                accumulate = func.apply(accumulate, o);
            }
            TResult TResult = selector.apply(accumulate);
            return TResult;
        }
    }

    public static <TSource> boolean all(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                if (predicate.apply(o)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static boolean any(Enumerable enumerable) {
        return enumerable.enumerator().moveNext();
    }

    public static <TSource> boolean any(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                if (!predicate.apply(o)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static <TSource> Enumerable<TSource> asEnumerable(Enumerable<TSource> enumerable) {
        return enumerable;
    }

    public static <TSource> Queryable<TSource> asQueryable(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> BigDecimal average(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector).divide(BigDecimal.valueOf(EnumerableDefaults.longCount(source)));
    }

    public static <TSource> BigDecimal average(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector).divide(BigDecimal.valueOf(EnumerableDefaults.longCount(source)));
    }

    public static <TSource> double average(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / (double)EnumerableDefaults.longCount(source);
    }

    public static <TSource> Double average(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / (double)EnumerableDefaults.longCount(source);
    }

    public static <TSource> int average(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.count(source);
    }

    public static <TSource> Integer average(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.count(source);
    }

    public static <TSource> long average(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.longCount(source);
    }

    public static <TSource> Long average(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.longCount(source);
    }

    public static <TSource> float average(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / (float)EnumerableDefaults.longCount(source);
    }

    public static <TSource> Float average(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return Float.valueOf(EnumerableDefaults.sum(source, selector).floatValue() / (float)EnumerableDefaults.longCount(source));
    }

    public static <TSource, T2> Enumerable<T2> cast(final Enumerable<TSource> source, final Class<T2> clazz) {
        return new AbstractEnumerable<T2>(){

            @Override
            public Enumerator<T2> enumerator() {
                return new CastingEnumerator(source.enumerator(), clazz);
            }
        };
    }

    public static <TSource> Enumerable<TSource> concat(Enumerable<TSource> enumerable0, Enumerable<TSource> enumerable1) {
        return Linq4j.concat(Arrays.asList(enumerable0, enumerable1));
    }

    public static <TSource> boolean contains(Enumerable<TSource> enumerable, TSource element) {
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                if (!o.equals(element)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static <TSource> boolean contains(Enumerable<TSource> enumerable, TSource element, EqualityComparer<TSource> comparer) {
        for (Object o : enumerable) {
            if (!comparer.equal(o, element)) continue;
            return true;
        }
        return false;
    }

    public static <TSource> int count(Enumerable<TSource> enumerable) {
        return (int)EnumerableDefaults.longCount(enumerable, Functions.truePredicate1());
    }

    public static <TSource> int count(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        return (int)EnumerableDefaults.longCount(enumerable, predicate);
    }

    public static <TSource> Enumerable<TSource> defaultIfEmpty(Enumerable<TSource> enumerable) {
        return EnumerableDefaults.defaultIfEmpty(enumerable, null);
    }

    public static <TSource> Enumerable<TSource> defaultIfEmpty(Enumerable<TSource> enumerable, TSource value) {
        try (final Enumerator os = enumerable.enumerator();){
            if (os.moveNext()) {
                Enumerable enumerable2 = Linq4j.asEnumerable(() -> new Iterator<TSource>(){
                    private boolean nonFirst;
                    private Iterator rest;

                    @Override
                    public boolean hasNext() {
                        return !this.nonFirst || this.rest.hasNext();
                    }

                    @Override
                    public TSource next() {
                        if (this.nonFirst) {
                            return this.rest.next();
                        }
                        Object first = os.current();
                        this.nonFirst = true;
                        this.rest = Linq4j.enumeratorIterator(os);
                        return first;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                });
                return enumerable2;
            }
            Enumerable<TSource> enumerable3 = Linq4j.singletonEnumerable(value);
            return enumerable3;
        }
    }

    public static <TSource> Enumerable<TSource> distinct(Enumerable<TSource> enumerable) {
        Enumerator os = enumerable.enumerator();
        HashSet set = new HashSet();
        while (os.moveNext()) {
            set.add(os.current());
        }
        os.close();
        return Linq4j.asEnumerable(set);
    }

    public static <TSource> Enumerable<TSource> distinct(Enumerable<TSource> enumerable, EqualityComparer<TSource> comparer) {
        if (comparer == Functions.identityComparer()) {
            return EnumerableDefaults.distinct(enumerable);
        }
        HashSet set = new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        enumerable.select(wrapper).into(set);
        return Linq4j.asEnumerable(set).select(unwrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <TSource> TSource elementAt(Enumerable<TSource> enumerable, int index) {
        Linq4j.ListEnumerable list;
        Linq4j.ListEnumerable listEnumerable = list = enumerable instanceof Linq4j.ListEnumerable ? (Linq4j.ListEnumerable)enumerable : null;
        if (list != null) {
            return (TSource)list.toList().get(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        try (Enumerator os = enumerable.enumerator();){
            while (true) {
                if (!os.moveNext()) {
                    throw new IndexOutOfBoundsException();
                }
                if (index == 0) {
                    Object t = os.current();
                    return (TSource)t;
                }
                --index;
                continue;
                break;
            }
        }
    }

    public static <TSource> TSource elementAtOrDefault(Enumerable<TSource> enumerable, int index) {
        Linq4j.ListEnumerable list;
        Linq4j.ListEnumerable listEnumerable = list = enumerable instanceof Linq4j.ListEnumerable ? (Linq4j.ListEnumerable)enumerable : null;
        if (index >= 0) {
            if (list != null) {
                List rawList = list.toList();
                if (index < rawList.size()) {
                    return (TSource)rawList.get(index);
                }
            } else {
                try (Enumerator os = enumerable.enumerator();){
                    while (os.moveNext()) {
                        if (index == 0) {
                            Object t = os.current();
                            return (TSource)t;
                        }
                        --index;
                    }
                }
            }
        }
        return null;
    }

    public static <TSource> Enumerable<TSource> except(Enumerable<TSource> source0, Enumerable<TSource> source1) {
        return EnumerableDefaults.except(source0, source1, false);
    }

    public static <TSource> Enumerable<TSource> except(Enumerable<TSource> source0, Enumerable<TSource> source1, boolean all) {
        AbstractCollection collection = all ? HashMultiset.create() : new HashSet();
        source0.into(collection);
        try (Enumerator os = source1.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                collection.remove(o);
            }
            Enumerable enumerable = Linq4j.asEnumerable(collection);
            return enumerable;
        }
    }

    public static <TSource> Enumerable<TSource> except(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer) {
        return EnumerableDefaults.except(source0, source1, comparer, false);
    }

    public static <TSource> Enumerable<TSource> except(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer, boolean all) {
        if (comparer == Functions.identityComparer()) {
            return EnumerableDefaults.except(source0, source1, all);
        }
        AbstractCollection collection = all ? HashMultiset.create() : new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        source0.select(wrapper).into(collection);
        try (Enumerator os = source1.select(wrapper).enumerator();){
            while (os.moveNext()) {
                Wrapped o = (Wrapped)os.current();
                collection.remove(o);
            }
        }
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        return Linq4j.asEnumerable(collection).select(unwrapper);
    }

    public static <TSource> TSource first(Enumerable<TSource> enumerable) {
        Throwable throwable = null;
        try (Enumerator os = enumerable.enumerator();){
            if (os.moveNext()) {
                Object t = os.current();
                return (TSource)t;
            }
            try {
                throw new NoSuchElementException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static <TSource> TSource first(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        for (Object o : enumerable) {
            if (!predicate.apply(o)) continue;
            return (TSource)o;
        }
        throw new NoSuchElementException();
    }

    public static <TSource> TSource firstOrDefault(Enumerable<TSource> enumerable) {
        try (Enumerator os = enumerable.enumerator();){
            if (os.moveNext()) {
                Object t = os.current();
                return (TSource)t;
            }
            TSource TSource = null;
            return TSource;
        }
    }

    public static <TSource> TSource firstOrDefault(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        for (Object o : enumerable) {
            if (!predicate.apply(o)) continue;
            return (TSource)o;
        }
        return null;
    }

    public static <TSource, TKey> Enumerable<Grouping<TKey, TSource>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector) {
        return enumerable.toLookup(keySelector);
    }

    public static <TSource, TKey> Enumerable<Grouping<TKey, TSource>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, EqualityComparer<TKey> comparer) {
        return enumerable.toLookup(keySelector, comparer);
    }

    public static <TSource, TKey, TElement> Enumerable<Grouping<TKey, TElement>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        return enumerable.toLookup(keySelector, elementSelector);
    }

    public static <TSource, TKey, TElement> Enumerable<Grouping<TKey, TElement>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, EqualityComparer<TKey> comparer) {
        return enumerable.toLookup(keySelector, elementSelector, comparer);
    }

    public static <TSource, TKey, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function2<TKey, Enumerable<TSource>, TResult> resultSelector) {
        return enumerable.toLookup(keySelector).select(group -> resultSelector.apply((Object)group.getKey(), (Enumerable)group));
    }

    public static <TSource, TKey, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function2<TKey, Enumerable<TSource>, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        return enumerable.toLookup(keySelector, comparer).select(group -> resultSelector.apply((Object)group.getKey(), (Enumerable)group));
    }

    public static <TSource, TKey, TElement, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, Function2<TKey, Enumerable<TElement>, TResult> resultSelector) {
        return enumerable.toLookup(keySelector, elementSelector).select(group -> resultSelector.apply((Object)group.getKey(), (Enumerable)group));
    }

    public static <TSource, TKey, TElement, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, Function2<TKey, Enumerable<TElement>, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        return enumerable.toLookup(keySelector, elementSelector, comparer).select(group -> resultSelector.apply((Object)group.getKey(), (Enumerable)group));
    }

    public static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector) {
        return EnumerableDefaults.groupBy_(new HashMap(), enumerable, keySelector, accumulatorInitializer, accumulatorAdder, resultSelector);
    }

    public static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupByMultiple(Enumerable<TSource> enumerable, List<Function1<TSource, TKey>> keySelectors, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector) {
        return EnumerableDefaults.groupByMultiple_(new HashMap(), enumerable, keySelectors, accumulatorInitializer, accumulatorAdder, resultSelector);
    }

    public static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.groupBy_(new WrapMap(() -> new HashMap(), comparer), enumerable, keySelector, accumulatorInitializer, accumulatorAdder, resultSelector);
    }

    private static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupBy_(Map<TKey, TAccumulate> map, Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector) {
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                TKey key = keySelector.apply(o);
                TAccumulate accumulator = map.get(key);
                if (accumulator == null) {
                    accumulator = accumulatorInitializer.apply();
                    accumulator = accumulatorAdder.apply(accumulator, o);
                    map.put(key, accumulator);
                    continue;
                }
                TAccumulate accumulator0 = accumulator;
                if ((accumulator = accumulatorAdder.apply(accumulator, o)) == accumulator0) continue;
                map.put(key, accumulator);
            }
        }
        return new LookupResultEnumerable<TResult, TKey, TAccumulate>(map, resultSelector);
    }

    private static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupByMultiple_(Map<TKey, TAccumulate> map, Enumerable<TSource> enumerable, List<Function1<TSource, TKey>> keySelectors, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector) {
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                for (Function1<TSource, TKey> keySelector : keySelectors) {
                    Object o;
                    TKey key = keySelector.apply(o = os.current());
                    TAccumulate accumulator = map.get(key);
                    if (accumulator == null) {
                        accumulator = accumulatorInitializer.apply();
                        accumulator = accumulatorAdder.apply(accumulator, o);
                        map.put(key, accumulator);
                        continue;
                    }
                    TAccumulate accumulator0 = accumulator;
                    if ((accumulator = accumulatorAdder.apply(accumulator, o)) == accumulator0) continue;
                    map.put(key, accumulator);
                }
            }
        }
        return new LookupResultEnumerable<TResult, TKey, TAccumulate>(map, resultSelector);
    }

    private static <TSource, TKey, TResult> Enumerable<TResult> groupBy_(Set<TKey> map, Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TKey, TResult> resultSelector) {
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                TKey key = keySelector.apply(o);
                map.add(key);
            }
        }
        return Linq4j.asEnumerable(map).select(resultSelector);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> groupJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, Enumerable<TInner>, TResult> resultSelector) {
        return new AbstractEnumerable<TResult>(){
            final Map<TKey, TSource> outerMap;
            final Lookup<TKey, TInner> innerLookup;
            final Enumerator<Map.Entry<TKey, TSource>> entries;
            {
                this.outerMap = outer.toMap(outerKeySelector);
                this.innerLookup = inner.toLookup(innerKeySelector);
                this.entries = Linq4j.enumerator(this.outerMap.entrySet());
            }

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){

                    @Override
                    public TResult current() {
                        Map.Entry entry = entries.current();
                        Enumerable inners = (Enumerable)innerLookup.get(entry.getKey());
                        return resultSelector.apply(entry.getValue(), inners == null ? Linq4j.emptyEnumerable() : inners);
                    }

                    @Override
                    public boolean moveNext() {
                        return entries.moveNext();
                    }

                    @Override
                    public void reset() {
                        entries.reset();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> groupJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, Enumerable<TInner>, TResult> resultSelector, final EqualityComparer<TKey> comparer) {
        return new AbstractEnumerable<TResult>(){
            final Map<TKey, TSource> outerMap;
            final Lookup<TKey, TInner> innerLookup;
            final Enumerator<Map.Entry<TKey, TSource>> entries;
            {
                this.outerMap = outer.toMap(outerKeySelector, comparer);
                this.innerLookup = inner.toLookup(innerKeySelector, comparer);
                this.entries = Linq4j.enumerator(this.outerMap.entrySet());
            }

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){

                    @Override
                    public TResult current() {
                        Map.Entry entry = entries.current();
                        Enumerable inners = (Enumerable)innerLookup.get(entry.getKey());
                        return resultSelector.apply(entry.getValue(), inners == null ? Linq4j.emptyEnumerable() : inners);
                    }

                    @Override
                    public boolean moveNext() {
                        return entries.moveNext();
                    }

                    @Override
                    public void reset() {
                        entries.reset();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public static <TSource> Enumerable<TSource> intersect(Enumerable<TSource> source0, Enumerable<TSource> source1) {
        return EnumerableDefaults.intersect(source0, source1, false);
    }

    public static <TSource> Enumerable<TSource> intersect(Enumerable<TSource> source0, Enumerable<TSource> source1, boolean all) {
        AbstractCollection set1 = all ? HashMultiset.create() : new HashSet();
        source1.into(set1);
        AbstractCollection resultCollection = all ? HashMultiset.create() : new HashSet();
        try (Enumerator os = source0.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                if (!set1.remove(o)) continue;
                resultCollection.add(o);
            }
        }
        return Linq4j.asEnumerable(resultCollection);
    }

    public static <TSource> Enumerable<TSource> intersect(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer) {
        return EnumerableDefaults.intersect(source0, source1, comparer, false);
    }

    public static <TSource> Enumerable<TSource> intersect(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer, boolean all) {
        if (comparer == Functions.identityComparer()) {
            return EnumerableDefaults.intersect(source0, source1, all);
        }
        AbstractCollection collection = all ? HashMultiset.create() : new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        source1.select(wrapper).into(collection);
        AbstractCollection resultCollection = all ? HashMultiset.create() : new HashSet();
        try (Enumerator os = source0.select(wrapper).enumerator();){
            while (os.moveNext()) {
                Wrapped o = (Wrapped)os.current();
                if (!collection.remove(o)) continue;
                resultCollection.add(o);
            }
        }
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        return Linq4j.asEnumerable(resultCollection).select(unwrapper);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> hashJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector) {
        return EnumerableDefaults.hashJoin(outer, inner, outerKeySelector, innerKeySelector, resultSelector, null, false, false);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> hashJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.hashJoin(outer, inner, outerKeySelector, innerKeySelector, resultSelector, comparer, false, false);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> hashJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector, EqualityComparer<TKey> comparer, boolean generateNullsOnLeft, boolean generateNullsOnRight) {
        return EnumerableDefaults.hashEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, resultSelector, comparer, generateNullsOnLeft, generateNullsOnRight);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> hashJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector, EqualityComparer<TKey> comparer, boolean generateNullsOnLeft, boolean generateNullsOnRight, Predicate2<TSource, TInner> predicate) {
        if (predicate == null) {
            return EnumerableDefaults.hashEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, resultSelector, comparer, generateNullsOnLeft, generateNullsOnRight);
        }
        return EnumerableDefaults.hashJoinWithPredicate_(outer, inner, outerKeySelector, innerKeySelector, resultSelector, comparer, generateNullsOnLeft, generateNullsOnRight, predicate);
    }

    private static <TSource, TInner, TKey, TResult> Enumerable<TResult> hashEquiJoin_(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, TInner, TResult> resultSelector, final EqualityComparer<TKey> comparer, final boolean generateNullsOnLeft, final boolean generateNullsOnRight) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                final Lookup innerLookup = comparer == null ? inner.toLookup(innerKeySelector) : inner.toLookup(innerKeySelector, comparer);
                return new Enumerator<TResult>(){
                    Enumerator<TSource> outers;
                    Enumerator<TInner> inners;
                    Set<TKey> unmatchedKeys;
                    {
                        this.outers = outer.enumerator();
                        this.inners = Linq4j.emptyEnumerator();
                        this.unmatchedKeys = generateNullsOnLeft ? new HashSet(innerLookup.keySet()) : null;
                    }

                    @Override
                    public TResult current() {
                        return resultSelector.apply(this.outers.current(), this.inners.current());
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.inners.moveNext()) {
                            ExtendedEnumerable innerEnumerable;
                            if (!this.outers.moveNext()) {
                                if (this.unmatchedKeys != null) {
                                    ArrayList list = new ArrayList();
                                    for (Object key : this.unmatchedKeys) {
                                        for (Object tInner : (Enumerable)innerLookup.get(key)) {
                                            list.add(tInner);
                                        }
                                    }
                                    this.inners = Linq4j.enumerator(list);
                                    this.outers.close();
                                    this.outers = Linq4j.singletonNullEnumerator();
                                    this.outers.moveNext();
                                    this.unmatchedKeys = null;
                                    continue;
                                }
                                return false;
                            }
                            Object outer = this.outers.current();
                            if (outer == null) {
                                innerEnumerable = null;
                            } else {
                                Object outerKey = outerKeySelector.apply(outer);
                                if (outerKey == null) {
                                    innerEnumerable = null;
                                } else {
                                    if (this.unmatchedKeys != null) {
                                        this.unmatchedKeys.remove(outerKey);
                                    }
                                    innerEnumerable = (Enumerable)innerLookup.get(outerKey);
                                }
                            }
                            if (innerEnumerable == null || !innerEnumerable.any()) {
                                if (generateNullsOnRight) {
                                    this.inners = Linq4j.singletonNullEnumerator();
                                    continue;
                                }
                                this.inners = Linq4j.emptyEnumerator();
                                continue;
                            }
                            this.inners = innerEnumerable.enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.outers.reset();
                    }

                    @Override
                    public void close() {
                        this.outers.close();
                    }
                };
            }
        };
    }

    private static <TSource, TInner, TKey, TResult> Enumerable<TResult> hashJoinWithPredicate_(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, TInner, TResult> resultSelector, final EqualityComparer<TKey> comparer, final boolean generateNullsOnLeft, final boolean generateNullsOnRight, final Predicate2<TSource, TInner> predicate) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                final Enumerable innerToLookUp = generateNullsOnLeft ? Linq4j.asEnumerable(inner.toList()) : inner;
                final Lookup innerLookup = comparer == null ? innerToLookUp.toLookup(innerKeySelector) : innerToLookUp.toLookup(innerKeySelector, comparer);
                return new Enumerator<TResult>(){
                    Enumerator<TSource> outers;
                    Enumerator<TInner> inners;
                    List<TInner> innersUnmatched;
                    {
                        this.outers = outer.enumerator();
                        this.inners = Linq4j.emptyEnumerator();
                        this.innersUnmatched = generateNullsOnLeft ? new ArrayList(innerToLookUp.toList()) : null;
                    }

                    @Override
                    public TResult current() {
                        return resultSelector.apply(this.outers.current(), this.inners.current());
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.inners.moveNext()) {
                            Enumerable innerEnumerable;
                            if (!this.outers.moveNext()) {
                                if (this.innersUnmatched != null) {
                                    this.inners = Linq4j.enumerator(this.innersUnmatched);
                                    this.outers.close();
                                    this.outers = Linq4j.singletonNullEnumerator();
                                    this.outers.moveNext();
                                    this.innersUnmatched = null;
                                    continue;
                                }
                                return false;
                            }
                            Object outer = this.outers.current();
                            if (outer == null) {
                                innerEnumerable = null;
                            } else {
                                Object outerKey = outerKeySelector.apply(outer);
                                if (outerKey == null) {
                                    innerEnumerable = null;
                                } else {
                                    innerEnumerable = (Enumerable)innerLookup.get(outerKey);
                                    if (innerEnumerable != null) {
                                        ArrayList matchedInners = new ArrayList();
                                        try (Enumerator innerEnumerator = innerEnumerable.enumerator();){
                                            while (innerEnumerator.moveNext()) {
                                                Object inner = innerEnumerator.current();
                                                if (!predicate.apply(outer, inner)) continue;
                                                matchedInners.add(inner);
                                            }
                                        }
                                        innerEnumerable = Linq4j.asEnumerable(matchedInners);
                                        if (this.innersUnmatched != null) {
                                            this.innersUnmatched.removeAll(matchedInners);
                                        }
                                    }
                                }
                            }
                            if (innerEnumerable == null || !innerEnumerable.any()) {
                                if (generateNullsOnRight) {
                                    this.inners = Linq4j.singletonNullEnumerator();
                                    continue;
                                }
                                this.inners = Linq4j.emptyEnumerator();
                                continue;
                            }
                            this.inners = innerEnumerable.enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.outers.reset();
                    }

                    @Override
                    public void close() {
                        this.outers.close();
                    }
                };
            }
        };
    }

    public static <TSource, TInner, TResult> Enumerable<TResult> correlateJoin(final JoinType joinType, final Enumerable<TSource> outer, final Function1<TSource, Enumerable<TInner>> inner, final Function2<TSource, TInner, TResult> resultSelector) {
        if (joinType == JoinType.RIGHT || joinType == JoinType.FULL) {
            throw new IllegalArgumentException("JoinType " + (Object)((Object)joinType) + " is not valid for correlation");
        }
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    private Enumerator<TSource> outerEnumerator;
                    private Enumerator<TInner> innerEnumerator;
                    TSource outerValue;
                    TInner innerValue;
                    int state;
                    {
                        this.outerEnumerator = outer.enumerator();
                        this.state = 0;
                    }

                    @Override
                    public TResult current() {
                        return resultSelector.apply(this.outerValue, this.innerValue);
                    }

                    @Override
                    public boolean moveNext() {
                        while (true) {
                            block0 : switch (this.state) {
                                case 0: {
                                    if (!this.outerEnumerator.moveNext()) {
                                        return false;
                                    }
                                    this.outerValue = this.outerEnumerator.current();
                                    Enumerable innerEnumerable = (Enumerable)inner.apply(this.outerValue);
                                    if (innerEnumerable == null) {
                                        innerEnumerable = Linq4j.emptyEnumerable();
                                    }
                                    if (this.innerEnumerator != null) {
                                        this.innerEnumerator.close();
                                    }
                                    this.innerEnumerator = innerEnumerable.enumerator();
                                    if (this.innerEnumerator.moveNext()) {
                                        switch (joinType) {
                                            case ANTI: {
                                                break block0;
                                            }
                                            case SEMI: {
                                                return true;
                                            }
                                            default: {
                                                this.innerValue = this.innerEnumerator.current();
                                                this.state = 1;
                                                return true;
                                            }
                                        }
                                    }
                                    this.innerValue = null;
                                    switch (joinType) {
                                        case ANTI: 
                                        case LEFT: {
                                            return true;
                                        }
                                    }
                                    break;
                                }
                                case 1: {
                                    if (this.innerEnumerator.moveNext()) {
                                        this.innerValue = this.innerEnumerator.current();
                                        return true;
                                    }
                                    this.state = 0;
                                }
                            }
                        }
                    }

                    @Override
                    public void reset() {
                        this.state = 0;
                        this.outerEnumerator.reset();
                        this.closeInner();
                    }

                    @Override
                    public void close() {
                        this.outerEnumerator.close();
                        this.closeInner();
                        this.outerValue = null;
                    }

                    private void closeInner() {
                        this.innerValue = null;
                        if (this.innerEnumerator != null) {
                            this.innerEnumerator.close();
                            this.innerEnumerator = null;
                        }
                    }
                };
            }
        };
    }

    public static <TSource> TSource last(Enumerable<TSource> enumerable) {
        Linq4j.ListEnumerable list;
        Linq4j.ListEnumerable listEnumerable = list = enumerable instanceof Linq4j.ListEnumerable ? (Linq4j.ListEnumerable)enumerable : null;
        if (list != null) {
            List rawList = list.toList();
            int count = rawList.size();
            if (count > 0) {
                return (TSource)rawList.get(count - 1);
            }
        } else {
            try (Enumerator os = enumerable.enumerator();){
                if (os.moveNext()) {
                    Object result;
                    do {
                        result = os.current();
                    } while (os.moveNext());
                    Object t = result;
                    return (TSource)t;
                }
            }
        }
        throw new NoSuchElementException();
    }

    public static <TSource, TInner, TResult> Enumerable<TResult> correlateBatchJoin(final JoinType joinType, final Enumerable<TSource> outer, final Function1<List<TSource>, Enumerable<TInner>> inner, final Function2<TSource, TInner, TResult> resultSelector, final Predicate2<TSource, TInner> predicate, final int batchSize) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> outerEnumerator;
                    List<TSource> outerValues;
                    List<TInner> innerValues;
                    TSource outerValue;
                    TInner innerValue;
                    Enumerable<TInner> innerEnumerable;
                    Enumerator<TInner> innerEnumerator;
                    boolean innerEnumHasNext;
                    boolean atLeastOneResult;
                    int i;
                    int j;
                    {
                        this.outerEnumerator = outer.enumerator();
                        this.outerValues = new ArrayList(batchSize);
                        this.innerValues = new ArrayList();
                        this.innerEnumHasNext = false;
                        this.atLeastOneResult = false;
                        this.i = -1;
                        this.j = -1;
                    }

                    @Override
                    public TResult current() {
                        return resultSelector.apply(this.outerValue, this.innerValue);
                    }

                    @Override
                    public boolean moveNext() {
                        while (true) {
                            if (this.i == this.outerValues.size() || this.i == -1) {
                                this.i = 0;
                                this.j = 0;
                                this.outerValues.clear();
                                this.innerValues.clear();
                                while (this.outerValues.size() < batchSize && this.outerEnumerator.moveNext()) {
                                    Object tSource = this.outerEnumerator.current();
                                    this.outerValues.add(tSource);
                                }
                                if (this.outerValues.isEmpty()) {
                                    return false;
                                }
                                this.innerEnumerable = (Enumerable)inner.apply(new AbstractList<TSource>(){

                                    @Override
                                    public TSource get(int index) {
                                        return index < outerValues.size() ? outerValues.get(index) : outerValues.get(0);
                                    }

                                    @Override
                                    public int size() {
                                        return batchSize;
                                    }
                                });
                                if (this.innerEnumerable == null) {
                                    this.innerEnumerable = Linq4j.emptyEnumerable();
                                }
                                this.innerEnumerator = this.innerEnumerable.enumerator();
                                this.innerEnumHasNext = this.innerEnumerator.moveNext();
                                if (!(this.innerEnumHasNext || joinType != JoinType.SEMI && joinType != JoinType.INNER)) {
                                    this.i = this.outerValues.size();
                                    continue;
                                }
                            }
                            if (this.innerHasNext()) {
                                this.outerValue = this.outerValues.get(this.i);
                                this.nextInnerValue();
                                if (!predicate.apply(this.outerValue, this.innerValue)) continue;
                                this.atLeastOneResult = true;
                                if (joinType == JoinType.ANTI || joinType == JoinType.SEMI) {
                                    if (this.i == 0) {
                                        while (this.innerEnumHasNext) {
                                            this.innerValues.add(this.innerEnumerator.current());
                                            this.innerEnumHasNext = this.innerEnumerator.moveNext();
                                        }
                                    } else {
                                        this.j = this.innerValues.size();
                                    }
                                    if (joinType == JoinType.ANTI) continue;
                                }
                                return true;
                            }
                            if (!(this.atLeastOneResult || joinType != JoinType.LEFT && joinType != JoinType.ANTI)) {
                                this.outerValue = this.outerValues.get(this.i);
                                this.innerValue = null;
                                this.nextOuterValue();
                                return true;
                            }
                            this.nextOuterValue();
                        }
                    }

                    public void nextOuterValue() {
                        ++this.i;
                        this.j = 0;
                        this.atLeastOneResult = false;
                    }

                    private void nextInnerValue() {
                        if (this.i == 0) {
                            this.innerValue = this.innerEnumerator.current();
                            this.innerValues.add(this.innerValue);
                            this.innerEnumHasNext = this.innerEnumerator.moveNext();
                        } else {
                            this.innerValue = this.innerValues.get(this.j++);
                        }
                    }

                    private boolean innerHasNext() {
                        return this.i == 0 ? this.innerEnumHasNext : this.j < this.innerValues.size();
                    }

                    @Override
                    public void reset() {
                        this.outerEnumerator.reset();
                        this.innerValue = null;
                        this.outerValue = null;
                        this.outerValues.clear();
                        this.innerValues.clear();
                        this.atLeastOneResult = false;
                        this.i = -1;
                    }

                    @Override
                    public void close() {
                        this.outerEnumerator.close();
                        if (this.innerEnumerator != null) {
                            this.innerEnumerator.close();
                        }
                        this.outerValue = null;
                        this.innerValue = null;
                    }
                };
            }
        };
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector) {
        return EnumerableDefaults.semiEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, null, false);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.semiEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, comparer, false);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, EqualityComparer<TKey> comparer, Predicate2<TSource, TInner> nonEquiPredicate) {
        return EnumerableDefaults.semiJoin(outer, inner, outerKeySelector, innerKeySelector, comparer, false, nonEquiPredicate);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> antiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector) {
        return EnumerableDefaults.semiEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, null, true);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> antiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.semiEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, comparer, true);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> antiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, EqualityComparer<TKey> comparer, Predicate2<TSource, TInner> nonEquiPredicate) {
        return EnumerableDefaults.semiJoin(outer, inner, outerKeySelector, innerKeySelector, comparer, true, nonEquiPredicate);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, EqualityComparer<TKey> comparer, boolean anti, Predicate2<TSource, TInner> nonEquiPredicate) {
        if (nonEquiPredicate == null) {
            return EnumerableDefaults.semiEquiJoin_(outer, inner, outerKeySelector, innerKeySelector, comparer, anti);
        }
        return EnumerableDefaults.semiJoinWithPredicate_(outer, inner, outerKeySelector, innerKeySelector, comparer, anti, nonEquiPredicate);
    }

    private static <TSource, TInner, TKey> Enumerable<TSource> semiJoinWithPredicate_(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final EqualityComparer<TKey> comparer, final boolean anti, final Predicate2<TSource, TInner> nonEquiPredicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                Supplier<Lookup> innerLookup = Suppliers.memoize(() -> comparer == null ? inner.toLookup(innerKeySelector) : inner.toLookup(innerKeySelector, comparer));
                Predicate1<Object> predicate = v0 -> {
                    Object key = outerKeySelector.apply(v0);
                    if (!((Lookup)innerLookup.get()).containsKey(key)) {
                        return anti;
                    }
                    Enumerable innersOfKey = (Enumerable)((Lookup)innerLookup.get()).get(key);
                    try (Enumerator os = innersOfKey.enumerator();){
                        while (os.moveNext()) {
                            Object v1 = os.current();
                            if (!nonEquiPredicate.apply(v0, v1)) continue;
                            boolean bl = !anti;
                            return bl;
                        }
                        boolean bl = anti;
                        return bl;
                    }
                };
                return EnumerableDefaults.where(outer.enumerator(), predicate);
            }
        };
    }

    private static <TSource, TInner, TKey> Enumerable<TSource> semiEquiJoin_(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final EqualityComparer<TKey> comparer, final boolean anti) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                Supplier<Enumerable> innerLookup = Suppliers.memoize(() -> comparer == null ? inner.select(innerKeySelector).distinct() : inner.select(innerKeySelector).distinct(comparer));
                Predicate1<Object> predicate = anti ? v0 -> !((Enumerable)innerLookup.get()).contains(outerKeySelector.apply(v0)) : v0 -> ((Enumerable)innerLookup.get()).contains(outerKeySelector.apply(v0));
                return EnumerableDefaults.where(outer.enumerator(), predicate);
            }
        };
    }

    public static <TSource, TInner, TResult> Enumerable<TResult> nestedLoopJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Predicate2<TSource, TInner> predicate, Function2<TSource, TInner, TResult> resultSelector, JoinType joinType) {
        if (!joinType.generatesNullsOnLeft()) {
            return EnumerableDefaults.nestedLoopJoinOptimized(outer, inner, predicate, resultSelector, joinType);
        }
        return EnumerableDefaults.nestedLoopJoinAsList(outer, inner, predicate, resultSelector, joinType);
    }

    private static <TSource, TInner, TResult> Enumerable<TResult> nestedLoopJoinAsList(Enumerable<TSource> outer, Enumerable<TInner> inner, Predicate2<TSource, TInner> predicate, Function2<TSource, TInner, TResult> resultSelector, JoinType joinType) {
        Set rightUnmatched;
        boolean generateNullsOnLeft = joinType.generatesNullsOnLeft();
        boolean generateNullsOnRight = joinType.generatesNullsOnRight();
        ArrayList<TResult> result = new ArrayList<TResult>();
        List rightList = inner.toList();
        if (generateNullsOnLeft) {
            rightUnmatched = Sets.newIdentityHashSet();
            rightUnmatched.addAll(rightList);
        } else {
            rightUnmatched = null;
        }
        try (Enumerator lefts = outer.enumerator();){
            while (lefts.moveNext()) {
                int leftMatchCount = 0;
                Object left = lefts.current();
                for (Object right : rightList) {
                    if (!predicate.apply(left, right)) continue;
                    ++leftMatchCount;
                    if (joinType == JoinType.ANTI) break;
                    if (rightUnmatched != null) {
                        rightUnmatched.remove(right);
                    }
                    result.add(resultSelector.apply(left, right));
                    if (joinType != JoinType.SEMI) continue;
                    break;
                }
                if (leftMatchCount != 0 || !generateNullsOnRight && joinType != JoinType.ANTI) continue;
                result.add(resultSelector.apply(left, null));
            }
            if (rightUnmatched != null) {
                for (Object right : rightUnmatched) {
                    result.add(resultSelector.apply(null, right));
                }
            }
            Enumerable enumerable = Linq4j.asEnumerable(result);
            return enumerable;
        }
    }

    private static <TSource, TInner, TResult> Enumerable<TResult> nestedLoopJoinOptimized(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Predicate2<TSource, TInner> predicate, final Function2<TSource, TInner, TResult> resultSelector, final JoinType joinType) {
        if (joinType == JoinType.RIGHT || joinType == JoinType.FULL) {
            throw new IllegalArgumentException("JoinType " + (Object)((Object)joinType) + " is unsupported");
        }
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    private Enumerator<TSource> outerEnumerator;
                    private Enumerator<TInner> innerEnumerator;
                    private boolean outerMatch;
                    private TSource outerValue;
                    private TInner innerValue;
                    private int state;
                    {
                        this.outerEnumerator = outer.enumerator();
                        this.innerEnumerator = null;
                        this.outerMatch = false;
                        this.state = 0;
                    }

                    @Override
                    public TResult current() {
                        return resultSelector.apply(this.outerValue, this.innerValue);
                    }

                    @Override
                    public boolean moveNext() {
                        while (true) {
                            switch (this.state) {
                                case 0: {
                                    if (!this.outerEnumerator.moveNext()) {
                                        return false;
                                    }
                                    this.outerValue = this.outerEnumerator.current();
                                    this.closeInner();
                                    this.innerEnumerator = inner.enumerator();
                                    this.outerMatch = false;
                                    this.state = 1;
                                    break;
                                }
                                case 1: {
                                    if (this.innerEnumerator.moveNext()) {
                                        this.innerValue = this.innerEnumerator.current();
                                        if (!predicate.apply(this.outerValue, this.innerValue)) break;
                                        this.outerMatch = true;
                                        switch (joinType) {
                                            case ANTI: {
                                                this.state = 0;
                                                break;
                                            }
                                            case SEMI: {
                                                this.state = 0;
                                                return true;
                                            }
                                            case LEFT: 
                                            case INNER: {
                                                return true;
                                            }
                                        }
                                        break;
                                    }
                                    this.state = 0;
                                    this.innerValue = null;
                                    if (this.outerMatch || joinType != JoinType.LEFT && joinType != JoinType.ANTI) break;
                                    return true;
                                }
                            }
                        }
                    }

                    @Override
                    public void reset() {
                        this.state = 0;
                        this.outerMatch = false;
                        this.outerEnumerator.reset();
                        this.closeInner();
                    }

                    @Override
                    public void close() {
                        this.outerEnumerator.close();
                        this.closeInner();
                    }

                    private void closeInner() {
                        if (this.innerEnumerator != null) {
                            this.innerEnumerator.close();
                            this.innerEnumerator = null;
                        }
                    }
                };
            }
        };
    }

    public static <TSource, TInner, TKey extends Comparable<TKey>, TResult> Enumerable<TResult> mergeJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, TInner, TResult> resultSelector, boolean generateNullsOnLeft, boolean generateNullsOnRight) {
        if (generateNullsOnLeft) {
            throw new UnsupportedOperationException("not implemented, mergeJoin with generateNullsOnLeft");
        }
        if (generateNullsOnRight) {
            throw new UnsupportedOperationException("not implemented, mergeJoin with generateNullsOnRight");
        }
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new MergeJoinEnumerator(outer.enumerator(), inner.enumerator(), outerKeySelector, innerKeySelector, resultSelector);
            }
        };
    }

    public static <TSource> TSource last(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        Linq4j.ListEnumerable list;
        Linq4j.ListEnumerable listEnumerable = list = enumerable instanceof Linq4j.ListEnumerable ? (Linq4j.ListEnumerable)enumerable : null;
        if (list != null) {
            List rawList = list.toList();
            int count = rawList.size();
            for (int i = count - 1; i >= 0; --i) {
                Object result = rawList.get(i);
                if (!predicate.apply(result)) continue;
                return (TSource)result;
            }
        } else {
            try (Enumerator os = enumerable.enumerator();){
                while (os.moveNext()) {
                    Object result = os.current();
                    if (!predicate.apply(result)) continue;
                    while (os.moveNext()) {
                        Object element = os.current();
                        if (!predicate.apply(element)) continue;
                        result = element;
                    }
                    Object t = result;
                    return (TSource)t;
                }
            }
        }
        throw new NoSuchElementException();
    }

    public static <TSource> TSource lastOrDefault(Enumerable<TSource> enumerable) {
        Linq4j.ListEnumerable list;
        Linq4j.ListEnumerable listEnumerable = list = enumerable instanceof Linq4j.ListEnumerable ? (Linq4j.ListEnumerable)enumerable : null;
        if (list != null) {
            List rawList = list.toList();
            int count = rawList.size();
            if (count > 0) {
                return (TSource)rawList.get(count - 1);
            }
        } else {
            try (Enumerator os = enumerable.enumerator();){
                if (os.moveNext()) {
                    Object result;
                    do {
                        result = os.current();
                    } while (os.moveNext());
                    Object t = result;
                    return (TSource)t;
                }
            }
        }
        return null;
    }

    public static <TSource> TSource lastOrDefault(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        Linq4j.ListEnumerable list;
        Linq4j.ListEnumerable listEnumerable = list = enumerable instanceof Linq4j.ListEnumerable ? (Linq4j.ListEnumerable)enumerable : null;
        if (list != null) {
            List rawList = list.toList();
            int count = rawList.size();
            for (int i = count - 1; i >= 0; --i) {
                Object result = rawList.get(i);
                if (!predicate.apply(result)) continue;
                return (TSource)result;
            }
        } else {
            try (Enumerator os = enumerable.enumerator();){
                while (os.moveNext()) {
                    Object result = os.current();
                    if (!predicate.apply(result)) continue;
                    while (os.moveNext()) {
                        Object element = os.current();
                        if (!predicate.apply(element)) continue;
                        result = element;
                    }
                    Object t = result;
                    return (TSource)t;
                }
            }
        }
        return null;
    }

    public static <TSource> long longCount(Enumerable<TSource> source) {
        return EnumerableDefaults.longCount(source, Functions.truePredicate1());
    }

    public static <TSource> long longCount(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        if (predicate == Predicate1.TRUE && enumerable instanceof Collection) {
            return ((Collection)((Object)enumerable)).size();
        }
        int n = 0;
        try (Enumerator os = enumerable.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                if (!predicate.apply(o)) continue;
                ++n;
            }
        }
        return n;
    }

    public static <TSource extends Comparable<TSource>> TSource max(Enumerable<TSource> source) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return (TSource)((Comparable)EnumerableDefaults.aggregate(source, null, max));
    }

    public static <TSource> BigDecimal max(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, max);
    }

    public static <TSource> BigDecimal max(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, max);
    }

    public static <TSource> double max(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.DOUBLE_MAX);
    }

    public static <TSource> Double max(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.DOUBLE_MAX);
    }

    public static <TSource> int max(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.INTEGER_MAX);
    }

    public static <TSource> Integer max(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.INTEGER_MAX);
    }

    public static <TSource> long max(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.LONG_MAX);
    }

    public static <TSource> Long max(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.LONG_MAX);
    }

    public static <TSource> float max(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.FLOAT_MAX).floatValue();
    }

    public static <TSource> Float max(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.FLOAT_MAX);
    }

    public static <TSource, TResult extends Comparable<TResult>> TResult max(Enumerable<TSource> source, Function1<TSource, TResult> selector) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return (TResult)((Comparable)EnumerableDefaults.aggregate(source.select(selector), null, max));
    }

    public static <TSource extends Comparable<TSource>> TSource min(Enumerable<TSource> source) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return (TSource)((Comparable)EnumerableDefaults.aggregate(source, null, min));
    }

    private static <TSource extends Comparable<TSource>> Function2<TSource, TSource, TSource> minFunction() {
        return Extensions.COMPARABLE_MIN;
    }

    private static <TSource extends Comparable<TSource>> Function2<TSource, TSource, TSource> maxFunction() {
        return Extensions.COMPARABLE_MAX;
    }

    public static <TSource> BigDecimal min(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, min);
    }

    public static <TSource> BigDecimal min(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, min);
    }

    public static <TSource> double min(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.DOUBLE_MIN);
    }

    public static <TSource> Double min(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.DOUBLE_MIN);
    }

    public static <TSource> int min(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.INTEGER_MIN);
    }

    public static <TSource> Integer min(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.INTEGER_MIN);
    }

    public static <TSource> long min(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.LONG_MIN);
    }

    public static <TSource> Long min(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.LONG_MIN);
    }

    public static <TSource> float min(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.FLOAT_MIN).floatValue();
    }

    public static <TSource> Float min(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.FLOAT_MIN);
    }

    public static <TSource, TResult extends Comparable<TResult>> TResult min(Enumerable<TSource> source, Function1<TSource, TResult> selector) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return (TResult)((Comparable)EnumerableDefaults.aggregate(source.select(selector), null, min));
    }

    public static <TSource, TResult> Enumerable<TResult> ofType(Enumerable<TSource> enumerable, Class<TResult> clazz) {
        return EnumerableDefaults.where(enumerable, Functions.ofTypePredicate(clazz));
    }

    public static <TSource, TKey extends Comparable> Enumerable<TSource> orderBy(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.orderBy(source, keySelector, null);
    }

    public static <TSource, TKey> Enumerable<TSource> orderBy(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        TreeMap map = new TreeMap(comparator);
        LookupImpl lookup = EnumerableDefaults.toLookup_(map, source, keySelector, Functions.identitySelector());
        return lookup.valuesEnumerable();
    }

    public static <TSource, TKey extends Comparable> Enumerable<TSource> orderByDescending(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.orderBy(source, keySelector, Collections.reverseOrder());
    }

    public static <TSource, TKey> Enumerable<TSource> orderByDescending(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        return EnumerableDefaults.orderBy(source, keySelector, Collections.reverseOrder(comparator));
    }

    public static <TSource> Enumerable<TSource> reverse(Enumerable<TSource> source) {
        final List<TSource> list = EnumerableDefaults.toList(source);
        final int n = list.size();
        return Linq4j.asEnumerable(new AbstractList<TSource>(){

            @Override
            public TSource get(int index) {
                return list.get(n - 1 - index);
            }

            @Override
            public int size() {
                return n;
            }
        });
    }

    public static <TSource, TResult> Enumerable<TResult> select(final Enumerable<TSource> source, final Function1<TSource, TResult> selector) {
        if (selector == Functions.identitySelector()) {
            return source;
        }
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> enumerator;
                    {
                        this.enumerator = source.enumerator();
                    }

                    @Override
                    public TResult current() {
                        return selector.apply(this.enumerator.current());
                    }

                    @Override
                    public boolean moveNext() {
                        return this.enumerator.moveNext();
                    }

                    @Override
                    public void reset() {
                        this.enumerator.reset();
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> select(final Enumerable<TSource> source, final Function2<TSource, Integer, TResult> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> enumerator;
                    int n;
                    {
                        this.enumerator = source.enumerator();
                        this.n = -1;
                    }

                    @Override
                    public TResult current() {
                        return selector.apply(this.enumerator.current(), this.n);
                    }

                    @Override
                    public boolean moveNext() {
                        if (this.enumerator.moveNext()) {
                            ++this.n;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void reset() {
                        this.enumerator.reset();
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> selectMany(final Enumerable<TSource> source, final Function1<TSource, Enumerable<TResult>> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> sourceEnumerator;
                    Enumerator<TResult> resultEnumerator;
                    {
                        this.sourceEnumerator = source.enumerator();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public TResult current() {
                        return this.resultEnumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.resultEnumerator.moveNext()) {
                            if (!this.sourceEnumerator.moveNext()) {
                                return false;
                            }
                            this.resultEnumerator = ((Enumerable)selector.apply(this.sourceEnumerator.current())).enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.sourceEnumerator.reset();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public void close() {
                        this.sourceEnumerator.close();
                        this.resultEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> selectMany(final Enumerable<TSource> source, final Function2<TSource, Integer, Enumerable<TResult>> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    int index = -1;
                    Enumerator<TSource> sourceEnumerator;
                    Enumerator<TResult> resultEnumerator;
                    {
                        this.sourceEnumerator = source.enumerator();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public TResult current() {
                        return this.resultEnumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.resultEnumerator.moveNext()) {
                            if (!this.sourceEnumerator.moveNext()) {
                                return false;
                            }
                            ++this.index;
                            this.resultEnumerator = ((Enumerable)selector.apply(this.sourceEnumerator.current(), this.index)).enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.sourceEnumerator.reset();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public void close() {
                        this.sourceEnumerator.close();
                        this.resultEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TCollection, TResult> Enumerable<TResult> selectMany(final Enumerable<TSource> source, final Function2<TSource, Integer, Enumerable<TCollection>> collectionSelector, final Function2<TSource, TCollection, TResult> resultSelector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    int index = -1;
                    Enumerator<TSource> sourceEnumerator;
                    Enumerator<TCollection> collectionEnumerator;
                    Enumerator<TResult> resultEnumerator;
                    {
                        this.sourceEnumerator = source.enumerator();
                        this.collectionEnumerator = Linq4j.emptyEnumerator();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public TResult current() {
                        return this.resultEnumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.resultEnumerator.moveNext()) {
                            if (!this.sourceEnumerator.moveNext()) {
                                return false;
                            }
                            ++this.index;
                            final Object sourceElement = this.sourceEnumerator.current();
                            this.collectionEnumerator = ((Enumerable)collectionSelector.apply(sourceElement, this.index)).enumerator();
                            this.resultEnumerator = new TransformedEnumerator<TCollection, TResult>(this.collectionEnumerator){

                                @Override
                                protected TResult transform(TCollection collectionElement) {
                                    return resultSelector.apply(sourceElement, collectionElement);
                                }
                            };
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.sourceEnumerator.reset();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public void close() {
                        this.sourceEnumerator.close();
                        this.resultEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TCollection, TResult> Enumerable<TResult> selectMany(final Enumerable<TSource> source, final Function1<TSource, Enumerable<TCollection>> collectionSelector, final Function2<TSource, TCollection, TResult> resultSelector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> sourceEnumerator;
                    Enumerator<TCollection> collectionEnumerator;
                    Enumerator<TResult> resultEnumerator;
                    {
                        this.sourceEnumerator = source.enumerator();
                        this.collectionEnumerator = Linq4j.emptyEnumerator();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public TResult current() {
                        return this.resultEnumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        boolean incremented = false;
                        while (!this.resultEnumerator.moveNext()) {
                            if (!this.sourceEnumerator.moveNext()) {
                                return false;
                            }
                            final Object sourceElement = this.sourceEnumerator.current();
                            this.collectionEnumerator = ((Enumerable)collectionSelector.apply(sourceElement)).enumerator();
                            this.resultEnumerator = new TransformedEnumerator<TCollection, TResult>(this.collectionEnumerator){

                                @Override
                                protected TResult transform(TCollection collectionElement) {
                                    return resultSelector.apply(sourceElement, collectionElement);
                                }
                            };
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.sourceEnumerator.reset();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public void close() {
                        this.sourceEnumerator.close();
                        this.resultEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource> boolean sequenceEqual(Enumerable<TSource> first, Enumerable<TSource> second) {
        return EnumerableDefaults.sequenceEqual(first, second, null);
    }

    /*
     * Exception decompiling
     */
    public static <TSource> boolean sequenceEqual(Enumerable<TSource> first, Enumerable<TSource> second, EqualityComparer<TSource> comparer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <TSource> TSource single(Enumerable<TSource> source) {
        TSource toRet = null;
        Throwable throwable = null;
        try (Enumerator os = source.enumerator();){
            if (os.moveNext()) {
                toRet = (TSource)os.current();
                if (os.moveNext()) {
                    throw new IllegalStateException();
                }
            }
            if (toRet != null) {
                TSource TSource = toRet;
                return TSource;
            }
            try {
                throw new IllegalStateException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static <TSource> TSource single(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        TSource toRet = null;
        Throwable throwable = null;
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                if (!predicate.apply(os.current())) continue;
                if (toRet == null) {
                    toRet = (TSource)os.current();
                    continue;
                }
                throw new IllegalStateException();
            }
            if (toRet != null) {
                TSource TSource = toRet;
                return TSource;
            }
            try {
                throw new IllegalStateException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static <TSource> TSource singleOrDefault(Enumerable<TSource> source) {
        TSource toRet = null;
        try (Enumerator os = source.enumerator();){
            if (os.moveNext()) {
                toRet = (TSource)os.current();
            }
            if (os.moveNext()) {
                TSource TSource = null;
                return TSource;
            }
            TSource TSource = toRet;
            return TSource;
        }
    }

    public static <TSource> TSource singleOrDefault(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        TSource toRet = null;
        for (Object s : source) {
            if (!predicate.apply(s)) continue;
            if (toRet != null) {
                return null;
            }
            toRet = (TSource)s;
        }
        return toRet;
    }

    public static <TSource> Enumerable<TSource> skip(Enumerable<TSource> source, int count) {
        return EnumerableDefaults.skipWhile(source, (TSource v1, Integer v2) -> v2 < count);
    }

    public static <TSource> Enumerable<TSource> skipWhile(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        return EnumerableDefaults.skipWhile(source, Functions.toPredicate2(predicate));
    }

    public static <TSource> Enumerable<TSource> skipWhile(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new SkipWhileEnumerator(source.enumerator(), predicate);
            }
        };
    }

    public static <TSource> BigDecimal sum(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), BigDecimal.ZERO, Extensions.BIG_DECIMAL_SUM);
    }

    public static <TSource> BigDecimal sum(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), BigDecimal.ZERO, Extensions.BIG_DECIMAL_SUM);
    }

    public static <TSource> double sum(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), 0.0, Extensions.DOUBLE_SUM);
    }

    public static <TSource> Double sum(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), 0.0, Extensions.DOUBLE_SUM);
    }

    public static <TSource> int sum(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), 0, Extensions.INTEGER_SUM);
    }

    public static <TSource> Integer sum(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), 0, Extensions.INTEGER_SUM);
    }

    public static <TSource> long sum(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), 0L, Extensions.LONG_SUM);
    }

    public static <TSource> Long sum(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), 0L, Extensions.LONG_SUM);
    }

    public static <TSource> float sum(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), Float.valueOf(0.0f), Extensions.FLOAT_SUM).floatValue();
    }

    public static <TSource> Float sum(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), Float.valueOf(0.0f), Extensions.FLOAT_SUM);
    }

    public static <TSource> Enumerable<TSource> take(Enumerable<TSource> source, int count) {
        return EnumerableDefaults.takeWhile(source, (TSource v1, Integer v2) -> v2 < count);
    }

    public static <TSource> Enumerable<TSource> take(Enumerable<TSource> source, long count) {
        return EnumerableDefaults.takeWhileLong(source, (v1, v2) -> v2 < count);
    }

    public static <TSource> Enumerable<TSource> takeWhile(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        return EnumerableDefaults.takeWhile(source, Functions.toPredicate2(predicate));
    }

    public static <TSource> Enumerable<TSource> takeWhile(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new TakeWhileEnumerator(source.enumerator(), predicate);
            }
        };
    }

    public static <TSource> Enumerable<TSource> takeWhileLong(final Enumerable<TSource> source, final Predicate2<TSource, Long> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new TakeWhileLongEnumerator(source.enumerator(), predicate);
            }
        };
    }

    public static <TSource, TKey> OrderedEnumerable<TSource> createOrderedEnumerable(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator, boolean descending) {
        throw Extensions.todo();
    }

    public static <TSource, TKey extends Comparable<TKey>> OrderedEnumerable<TSource> thenBy(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, Extensions.comparableComparator(), false);
    }

    public static <TSource, TKey> OrderedEnumerable<TSource> thenBy(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, comparator, false);
    }

    public static <TSource, TKey extends Comparable<TKey>> OrderedEnumerable<TSource> thenByDescending(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, Extensions.comparableComparator(), true);
    }

    public static <TSource, TKey> OrderedEnumerable<TSource> thenByDescending(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, comparator, true);
    }

    public static <TSource, TKey> Map<TKey, TSource> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.toMap(source, keySelector, Functions.identitySelector());
    }

    public static <TSource, TKey> Map<TKey, TSource> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.toMap(source, keySelector, Functions.identitySelector(), comparer);
    }

    public static <TSource, TKey, TElement> Map<TKey, TElement> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        LinkedHashMap<TKey, TElement> map = new LinkedHashMap<TKey, TElement>();
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                map.put(keySelector.apply(o), elementSelector.apply(o));
            }
        }
        return map;
    }

    public static <TSource, TKey, TElement> Map<TKey, TElement> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, EqualityComparer<TKey> comparer) {
        WrapMap<TKey, TElement> map = new WrapMap<TKey, TElement>(() -> new LinkedHashMap(), comparer);
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                map.put(keySelector.apply(o), elementSelector.apply(o));
            }
        }
        return map;
    }

    public static <TSource> List<TSource> toList(Enumerable<TSource> source) {
        if (source instanceof List && source instanceof RandomAccess) {
            return (List)((Object)source);
        }
        return source.into(source instanceof Collection ? new ArrayList(((Collection)((Object)source)).size()) : new ArrayList());
    }

    public static <TSource, TKey> Lookup<TKey, TSource> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.toLookup(source, keySelector, Functions.identitySelector());
    }

    public static <TSource, TKey> Lookup<TKey, TSource> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.toLookup(source, keySelector, Functions.identitySelector(), comparer);
    }

    public static <TSource, TKey, TElement> Lookup<TKey, TElement> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        HashMap map = new HashMap();
        return EnumerableDefaults.toLookup_(map, source, keySelector, elementSelector);
    }

    static <TSource, TKey, TElement> LookupImpl<TKey, TElement> toLookup_(Map<TKey, List<TElement>> map, Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        try (Enumerator os = source.enumerator();){
            while (os.moveNext()) {
                Object o = os.current();
                TKey key = keySelector.apply(o);
                List<TElement> list = map.get(key);
                if (list == null) {
                    list = Collections.singletonList(elementSelector.apply(o));
                } else {
                    if (list.size() == 1) {
                        TElement element = list.get(0);
                        list = new ArrayList<TElement>();
                        list.add(element);
                    }
                    list.add(elementSelector.apply(o));
                }
                map.put(key, list);
            }
        }
        return new LookupImpl<TKey, TElement>(map);
    }

    public static <TSource, TKey, TElement> Lookup<TKey, TElement> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.toLookup_(new WrapMap(() -> new HashMap(), comparer), source, keySelector, elementSelector);
    }

    public static <TSource> Enumerable<TSource> union(Enumerable<TSource> source0, Enumerable<TSource> source1) {
        HashSet set = new HashSet();
        source0.into(set);
        source1.into(set);
        return Linq4j.asEnumerable(set);
    }

    public static <TSource> Enumerable<TSource> union(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer) {
        if (comparer == Functions.identityComparer()) {
            return EnumerableDefaults.union(source0, source1);
        }
        HashSet set = new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        source0.select(wrapper).into(set);
        source1.select(wrapper).into(set);
        return Linq4j.asEnumerable(set).select(unwrapper);
    }

    private static <TSource> Function1<Wrapped<TSource>, TSource> unwrapper() {
        return a0 -> ((Wrapped)a0).element;
    }

    private static <TSource> Function1<TSource, Wrapped<TSource>> wrapperFor(EqualityComparer<TSource> comparer) {
        return a0 -> Wrapped.upAs(comparer, a0);
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate1<TSource> predicate) {
        assert (predicate != null);
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                Enumerator enumerator = source.enumerator();
                return EnumerableDefaults.where(enumerator, predicate);
            }
        };
    }

    private static <TSource> Enumerator<TSource> where(final Enumerator<TSource> enumerator, final Predicate1<TSource> predicate) {
        return new Enumerator<TSource>(){

            @Override
            public TSource current() {
                return enumerator.current();
            }

            @Override
            public boolean moveNext() {
                while (enumerator.moveNext()) {
                    if (!predicate.apply(enumerator.current())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                enumerator.reset();
            }

            @Override
            public void close() {
                enumerator.close();
            }
        };
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new Enumerator<TSource>(){
                    final Enumerator<TSource> enumerator;
                    int n;
                    {
                        this.enumerator = source.enumerator();
                        this.n = -1;
                    }

                    @Override
                    public TSource current() {
                        return this.enumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (this.enumerator.moveNext()) {
                            ++this.n;
                            if (!predicate.apply(this.enumerator.current(), this.n)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void reset() {
                        this.enumerator.reset();
                        this.n = -1;
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <T0, T1, TResult> Enumerable<TResult> zip(final Enumerable<T0> first, final Enumerable<T1> second, final Function2<T0, T1, TResult> resultSelector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<T0> e1;
                    final Enumerator<T1> e2;
                    {
                        this.e1 = first.enumerator();
                        this.e2 = second.enumerator();
                    }

                    @Override
                    public TResult current() {
                        return resultSelector.apply(this.e1.current(), this.e2.current());
                    }

                    @Override
                    public boolean moveNext() {
                        return this.e1.moveNext() && this.e2.moveNext();
                    }

                    @Override
                    public void reset() {
                        this.e1.reset();
                        this.e2.reset();
                    }

                    @Override
                    public void close() {
                        this.e1.close();
                        this.e2.close();
                    }
                };
            }
        };
    }

    public static <T> OrderedQueryable<T> asOrderedQueryable(Enumerable<T> source) {
        return source instanceof OrderedQueryable ? (OrderedQueryable<Object>)source : new EnumerableOrderedQueryable<Object>(source, Object.class, null, null);
    }

    public static <T, C extends Collection<? super T>> C into(Enumerable<T> source, C sink) {
        try (Enumerator enumerator = source.enumerator();){
            while (enumerator.moveNext()) {
                Object t = enumerator.current();
                sink.add(t);
            }
        }
        return sink;
    }

    public static <T, C extends Collection<? super T>> C remove(Enumerable<T> source, C sink) {
        ArrayList tempList = new ArrayList();
        source.into(tempList);
        sink.removeAll(tempList);
        return sink;
    }

    public static <TSource> Enumerable<TSource> repeatUnion(final Enumerable<TSource> seed, final Enumerable<TSource> iteration, final int iterationLimit, final boolean all, final EqualityComparer<TSource> comparer) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new Enumerator<TSource>(){
                    private TSource current = EnumerableDefaults.access$400();
                    private boolean seedProcessed = false;
                    private int currentIteration = 0;
                    private final Enumerator<TSource> seedEnumerator;
                    private Enumerator<TSource> iterativeEnumerator;
                    private final Set<Wrapped<TSource>> processed;
                    private final Function1<TSource, Wrapped<TSource>> wrapper;
                    {
                        this.seedEnumerator = seed.enumerator();
                        this.iterativeEnumerator = null;
                        this.processed = new HashSet();
                        this.wrapper = EnumerableDefaults.wrapperFor(comparer);
                    }

                    @Override
                    public TSource current() {
                        if (this.current == DUMMY) {
                            throw new NoSuchElementException();
                        }
                        return this.current;
                    }

                    private boolean checkValue(TSource value) {
                        if (all) {
                            return true;
                        }
                        Wrapped wrapped = this.wrapper.apply(value);
                        if (!this.processed.contains(wrapped)) {
                            this.processed.add(wrapped);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean moveNext() {
                        Object value;
                        while (!this.seedProcessed) {
                            if (this.seedEnumerator.moveNext()) {
                                value = this.seedEnumerator.current();
                                if (!this.checkValue(value)) continue;
                                this.current = value;
                                return true;
                            }
                            this.seedProcessed = true;
                        }
                        while (true) {
                            if (iterationLimit >= 0 && this.currentIteration == iterationLimit) {
                                this.current = DUMMY;
                                return false;
                            }
                            if (this.iterativeEnumerator == null) {
                                this.iterativeEnumerator = iteration.enumerator();
                            }
                            while (this.iterativeEnumerator.moveNext()) {
                                value = this.iterativeEnumerator.current();
                                if (!this.checkValue(value)) continue;
                                this.current = value;
                                return true;
                            }
                            if (this.current == DUMMY) {
                                return false;
                            }
                            this.current = DUMMY;
                            this.iterativeEnumerator.close();
                            this.iterativeEnumerator = null;
                            ++this.currentIteration;
                        }
                    }

                    @Override
                    public void reset() {
                        this.seedEnumerator.reset();
                        this.seedProcessed = false;
                        this.processed.clear();
                        if (this.iterativeEnumerator != null) {
                            this.iterativeEnumerator.close();
                            this.iterativeEnumerator = null;
                        }
                        this.currentIteration = 0;
                    }

                    @Override
                    public void close() {
                        this.seedEnumerator.close();
                        if (this.iterativeEnumerator != null) {
                            this.iterativeEnumerator.close();
                        }
                    }
                };
            }
        };
    }

    public static <TSource> Enumerable<TSource> lazyCollectionSpool(final Collection<TSource> outputCollection, final Enumerable<TSource> input) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new Enumerator<TSource>(){
                    private TSource current = EnumerableDefaults.access$400();
                    private final Enumerator<TSource> inputEnumerator;
                    private final Collection<TSource> collection;
                    private final Collection<TSource> tempCollection;
                    {
                        this.inputEnumerator = input.enumerator();
                        this.collection = outputCollection;
                        this.tempCollection = new ArrayList();
                    }

                    @Override
                    public TSource current() {
                        if (this.current == DUMMY) {
                            throw new NoSuchElementException();
                        }
                        return this.current;
                    }

                    @Override
                    public boolean moveNext() {
                        if (this.inputEnumerator.moveNext()) {
                            this.current = this.inputEnumerator.current();
                            this.tempCollection.add(this.current);
                            return true;
                        }
                        this.flush();
                        return false;
                    }

                    private void flush() {
                        this.collection.clear();
                        this.collection.addAll(this.tempCollection);
                        this.tempCollection.clear();
                    }

                    @Override
                    public void reset() {
                        this.inputEnumerator.reset();
                        this.collection.clear();
                        this.tempCollection.clear();
                    }

                    @Override
                    public void close() {
                        this.inputEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> tumbling(final Enumerable<TSource> inputEnumerable, final Function1<TSource, TResult> outSelector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> inputs;
                    {
                        this.inputs = inputEnumerable.enumerator();
                    }

                    @Override
                    public TResult current() {
                        return outSelector.apply(this.inputs.current());
                    }

                    @Override
                    public boolean moveNext() {
                        return this.inputs.moveNext();
                    }

                    @Override
                    public void reset() {
                        this.inputs.reset();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    private static class MergeJoinEnumerator<TResult, TSource, TInner, TKey extends Comparable<TKey>>
    implements Enumerator<TResult> {
        final List<TSource> lefts = new ArrayList<TSource>();
        final List<TInner> rights = new ArrayList<TInner>();
        private final Enumerator<TSource> leftEnumerator;
        private final Enumerator<TInner> rightEnumerator;
        private final Function1<TSource, TKey> outerKeySelector;
        private final Function1<TInner, TKey> innerKeySelector;
        private final Function2<TSource, TInner, TResult> resultSelector;
        boolean done;
        Enumerator<List<Object>> cartesians;

        MergeJoinEnumerator(Enumerator<TSource> leftEnumerator, Enumerator<TInner> rightEnumerator, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector) {
            this.leftEnumerator = leftEnumerator;
            this.rightEnumerator = rightEnumerator;
            this.outerKeySelector = outerKeySelector;
            this.innerKeySelector = innerKeySelector;
            this.resultSelector = resultSelector;
            this.start();
        }

        private void start() {
            if (!(this.leftEnumerator.moveNext() && this.rightEnumerator.moveNext() && this.advance())) {
                this.done = true;
                this.cartesians = Linq4j.emptyEnumerator();
            }
        }

        private boolean advance() {
            int c;
            int c2;
            TSource left = this.leftEnumerator.current();
            Comparable leftKey = (Comparable)this.outerKeySelector.apply(left);
            TInner right = this.rightEnumerator.current();
            Comparable rightKey = (Comparable)this.innerKeySelector.apply(right);
            while ((c2 = leftKey.compareTo(rightKey)) != 0) {
                if (c2 < 0) {
                    if (!this.leftEnumerator.moveNext()) {
                        this.done = true;
                        return false;
                    }
                    left = this.leftEnumerator.current();
                    leftKey = (Comparable)this.outerKeySelector.apply(left);
                    continue;
                }
                if (!this.rightEnumerator.moveNext()) {
                    this.done = true;
                    return false;
                }
                right = this.rightEnumerator.current();
                rightKey = (Comparable)this.innerKeySelector.apply(right);
            }
            this.lefts.clear();
            this.lefts.add(left);
            while (true) {
                if (!this.leftEnumerator.moveNext()) {
                    this.done = true;
                    break;
                }
                left = this.leftEnumerator.current();
                Comparable leftKey2 = (Comparable)this.outerKeySelector.apply(left);
                c = leftKey.compareTo(leftKey2);
                if (c != 0) {
                    if (c <= 0) break;
                    throw new IllegalStateException("mergeJoin assumes inputs sorted in ascending order, however " + leftKey + " is greater than " + leftKey2);
                }
                this.lefts.add(left);
            }
            this.rights.clear();
            this.rights.add(right);
            while (true) {
                if (!this.rightEnumerator.moveNext()) {
                    this.done = true;
                    break;
                }
                right = this.rightEnumerator.current();
                Comparable rightKey2 = (Comparable)this.innerKeySelector.apply(right);
                c = rightKey.compareTo(rightKey2);
                if (c != 0) {
                    if (c <= 0) break;
                    throw new IllegalStateException("mergeJoin assumes input sorted in ascending order, however " + rightKey + " is greater than " + rightKey2);
                }
                this.rights.add(right);
            }
            this.cartesians = Linq4j.product(ImmutableList.of(Linq4j.enumerator(this.lefts), Linq4j.enumerator(this.rights)));
            return true;
        }

        @Override
        public TResult current() {
            List<Object> list = this.cartesians.current();
            Object left = list.get(0);
            Object right = list.get(1);
            return this.resultSelector.apply(left, right);
        }

        @Override
        public boolean moveNext() {
            do {
                if (this.cartesians.moveNext()) {
                    return true;
                }
                if (!this.done) continue;
                return false;
            } while (this.advance());
            return false;
        }

        @Override
        public void reset() {
            this.done = false;
            this.leftEnumerator.reset();
            this.rightEnumerator.reset();
            this.start();
        }

        @Override
        public void close() {
        }
    }

    private static class LookupResultEnumerable<TResult, TKey, TAccumulate>
    extends AbstractEnumerable2<TResult> {
        private final Map<TKey, TAccumulate> map;
        private final Function2<TKey, TAccumulate, TResult> resultSelector;

        LookupResultEnumerable(Map<TKey, TAccumulate> map, Function2<TKey, TAccumulate, TResult> resultSelector) {
            this.map = map;
            this.resultSelector = resultSelector;
        }

        @Override
        public Iterator<TResult> iterator() {
            final Iterator<Map.Entry<TKey, TAccumulate>> iterator = this.map.entrySet().iterator();
            return new Iterator<TResult>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public TResult next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return resultSelector.apply(entry.getKey(), entry.getValue());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class WrapMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<Wrapped<K>, V> map;
        private final EqualityComparer<K> comparer;

        protected WrapMap(Function0<Map<Wrapped<K>, V>> mapProvider, EqualityComparer<K> comparer) {
            this.map = mapProvider.apply();
            this.comparer = comparer;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final Iterator iterator = map.entrySet().iterator();
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry next = (Map.Entry)iterator.next();
                            return new AbstractMap.SimpleEntry(((Wrapped)next.getKey()).element, next.getValue());
                        }

                        @Override
                        public void remove() {
                            iterator.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return map.size();
                }
            };
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(this.wrap(key));
        }

        private Wrapped<K> wrap(K key) {
            return Wrapped.upAs(this.comparer, key);
        }

        @Override
        public V get(Object key) {
            return this.map.get(this.wrap(key));
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(this.wrap(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(this.wrap(key));
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }
    }

    private static class Wrapped<T> {
        private final EqualityComparer<T> comparer;
        private final T element;

        private Wrapped(EqualityComparer<T> comparer, T element) {
            this.comparer = comparer;
            this.element = element;
        }

        static <T> Wrapped<T> upAs(EqualityComparer<T> comparer, T element) {
            return new Wrapped<T>(comparer, element);
        }

        public int hashCode() {
            return this.comparer.hashCode(this.element);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Wrapped && this.comparer.equal(this.element, ((Wrapped)obj).element);
        }

        public T unwrap() {
            return this.element;
        }
    }

    static class CastingEnumerator<T>
    implements Enumerator<T> {
        private final Enumerator<?> enumerator;
        private final Class<T> clazz;

        CastingEnumerator(Enumerator<?> enumerator, Class<T> clazz) {
            this.enumerator = enumerator;
            this.clazz = clazz;
        }

        @Override
        public T current() {
            return this.clazz.cast(this.enumerator.current());
        }

        @Override
        public boolean moveNext() {
            return this.enumerator.moveNext();
        }

        @Override
        public void reset() {
            this.enumerator.reset();
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    static class SkipWhileEnumerator<TSource>
    implements Enumerator<TSource> {
        private final Enumerator<TSource> enumerator;
        private final Predicate2<TSource, Integer> predicate;
        boolean started = false;
        int n = -1;

        SkipWhileEnumerator(Enumerator<TSource> enumerator, Predicate2<TSource, Integer> predicate) {
            this.enumerator = enumerator;
            this.predicate = predicate;
        }

        @Override
        public TSource current() {
            return this.enumerator.current();
        }

        @Override
        public boolean moveNext() {
            do {
                if (!this.enumerator.moveNext()) {
                    return false;
                }
                if (!this.started) continue;
                return true;
            } while (this.predicate.apply(this.enumerator.current(), ++this.n));
            this.started = true;
            return true;
        }

        @Override
        public void reset() {
            this.enumerator.reset();
            this.started = false;
            this.n = -1;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    static class TakeWhileLongEnumerator<TSource>
    implements Enumerator<TSource> {
        private final Enumerator<TSource> enumerator;
        private final Predicate2<TSource, Long> predicate;
        boolean done = false;
        long n = -1L;

        TakeWhileLongEnumerator(Enumerator<TSource> enumerator, Predicate2<TSource, Long> predicate) {
            this.enumerator = enumerator;
            this.predicate = predicate;
        }

        @Override
        public TSource current() {
            return this.enumerator.current();
        }

        @Override
        public boolean moveNext() {
            if (!this.done) {
                if (this.enumerator.moveNext() && this.predicate.apply(this.enumerator.current(), ++this.n)) {
                    return true;
                }
                this.done = true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.enumerator.reset();
            this.done = false;
            this.n = -1L;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    static class TakeWhileEnumerator<TSource>
    implements Enumerator<TSource> {
        private final Enumerator<TSource> enumerator;
        private final Predicate2<TSource, Integer> predicate;
        boolean done = false;
        int n = -1;

        TakeWhileEnumerator(Enumerator<TSource> enumerator, Predicate2<TSource, Integer> predicate) {
            this.enumerator = enumerator;
            this.predicate = predicate;
        }

        @Override
        public TSource current() {
            return this.enumerator.current();
        }

        @Override
        public boolean moveNext() {
            if (!this.done) {
                if (this.enumerator.moveNext() && this.predicate.apply(this.enumerator.current(), ++this.n)) {
                    return true;
                }
                this.done = true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.enumerator.reset();
            this.done = false;
            this.n = -1;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }
}

