/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.influxdb.MeasurementInfo;
import org.apache.flink.metrics.influxdb.MetricInfoProvider;
import org.apache.flink.runtime.metrics.groups.FrontMetricGroup;

class MeasurementInfoProvider
implements MetricInfoProvider<MeasurementInfo> {
    @VisibleForTesting
    static final char SCOPE_SEPARATOR = '_';
    private static final CharacterFilter CHARACTER_FILTER = new CharacterFilter(){
        private final Pattern notAllowedCharacters = Pattern.compile("[^a-zA-Z0-9:_]");

        public String filterCharacters(String input) {
            return this.notAllowedCharacters.matcher(input).replaceAll("_");
        }
    };

    @Override
    public MeasurementInfo getMetricInfo(String metricName, MetricGroup group) {
        return new MeasurementInfo(MeasurementInfoProvider.getScopedName(metricName, group), MeasurementInfoProvider.getTags(group));
    }

    private static Map<String, String> getTags(MetricGroup group) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry variable : group.getAllVariables().entrySet()) {
            String name = (String)variable.getKey();
            tags.put(name.substring(1, name.length() - 1), (String)variable.getValue());
        }
        return tags;
    }

    private static String getScopedName(String metricName, MetricGroup group) {
        return MeasurementInfoProvider.getLogicalScope(group) + '_' + metricName;
    }

    private static String getLogicalScope(MetricGroup group) {
        return ((FrontMetricGroup)group).getLogicalScope(CHARACTER_FILTER, '_');
    }
}

