/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.metrics.MetricConfig;
import org.influxdb.InfluxDB;

@Documentation.SuffixOption
public class InfluxdbReporterOptions {
    public static final ConfigOption<String> HOST = ConfigOptions.key((String)"host").noDefaultValue().withDescription("the InfluxDB server host");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").defaultValue((Object)8086).withDescription("the InfluxDB server port");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").noDefaultValue().withDescription("(optional) InfluxDB username used for authentication");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").noDefaultValue().withDescription("(optional) InfluxDB username's password used for authentication");
    public static final ConfigOption<String> DB = ConfigOptions.key((String)"db").noDefaultValue().withDescription("the InfluxDB database to store metrics");
    public static final ConfigOption<String> RETENTION_POLICY = ConfigOptions.key((String)"retentionPolicy").defaultValue((Object)"").withDescription("(optional) the InfluxDB retention policy for metrics");
    public static final ConfigOption<InfluxDB.ConsistencyLevel> CONSISTENCY = ConfigOptions.key((String)"consistency").enumType(InfluxDB.ConsistencyLevel.class).defaultValue((Object)InfluxDB.ConsistencyLevel.ONE).withDescription("(optional) the InfluxDB consistency level for metrics");
    public static final ConfigOption<Integer> CONNECT_TIMEOUT = ConfigOptions.key((String)"connectTimeout").defaultValue((Object)10000).withDescription("(optional) the InfluxDB connect timeout for metrics");
    public static final ConfigOption<Integer> WRITE_TIMEOUT = ConfigOptions.key((String)"writeTimeout").defaultValue((Object)10000).withDescription("(optional) the InfluxDB write timeout for metrics");

    static String getString(MetricConfig config, ConfigOption<String> key) {
        return config.getString(key.key(), (String)key.defaultValue());
    }

    static int getInteger(MetricConfig config, ConfigOption<Integer> key) {
        return config.getInteger(key.key(), ((Integer)key.defaultValue()).intValue());
    }

    static InfluxDB.ConsistencyLevel getConsistencyLevel(MetricConfig config, ConfigOption<InfluxDB.ConsistencyLevel> key) {
        return InfluxDB.ConsistencyLevel.valueOf(config.getProperty(key.key(), ((InfluxDB.ConsistencyLevel)((Object)key.defaultValue())).name()));
    }
}

