/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.shaded.com.ibm.icu.lang.UCharacter;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;

@Internal
public class PrintUtils {
    public static final int MAX_COLUMN_WIDTH = 30;
    public static final String NULL_COLUMN = "(NULL)";
    private static final String COLUMN_TRUNCATED_FLAG = "...";

    private PrintUtils() {
    }

    public static void printAsTableauForm(TableSchema tableSchema, Iterator<Row> it, PrintWriter printWriter) {
        PrintUtils.printAsTableauForm(tableSchema, it, printWriter, 30, NULL_COLUMN, false);
    }

    public static void printAsTableauForm(TableSchema tableSchema, Iterator<Row> it, PrintWriter printWriter, int maxColumnWidth, String nullColumn, boolean deriveColumnWidthByType) {
        int[] colWidths;
        List<TableColumn> columns = tableSchema.getTableColumns();
        String[] columnNames = (String[])columns.stream().map(TableColumn::getName).toArray(String[]::new);
        if (deriveColumnWidthByType) {
            colWidths = PrintUtils.columnWidthsByType(columns, maxColumnWidth, nullColumn, null);
        } else {
            ArrayList<Row> rows = new ArrayList<Row>();
            ArrayList<String[]> content = new ArrayList<String[]>();
            content.add(columnNames);
            while (it.hasNext()) {
                Row row = it.next();
                rows.add(row);
                content.add(PrintUtils.rowToString(row, nullColumn));
            }
            colWidths = PrintUtils.columnWidthsByContent(columnNames, content, maxColumnWidth);
            it = rows.iterator();
        }
        String borderline = PrintUtils.genBorderLine(colWidths);
        printWriter.println(borderline);
        PrintUtils.printSingleRow(colWidths, columnNames, printWriter);
        printWriter.println(borderline);
        printWriter.flush();
        long numRows = 0L;
        while (it.hasNext()) {
            String[] cols = PrintUtils.rowToString((Row)it.next(), nullColumn);
            PrintUtils.printSingleRow(colWidths, cols, printWriter);
            ++numRows;
        }
        if (numRows > 0L) {
            printWriter.println(borderline);
        }
        String rowTerm = numRows > 1L ? "rows" : "row";
        printWriter.println(numRows + " " + rowTerm + " in set");
        printWriter.flush();
    }

    public static String[] rowToString(Row row) {
        return PrintUtils.rowToString(row, NULL_COLUMN);
    }

    public static String[] rowToString(Row row, String nullColumn) {
        String[] fields = new String[row.getArity()];
        for (int i = 0; i < row.getArity(); ++i) {
            Object field = row.getField(i);
            fields[i] = field == null ? nullColumn : StringUtils.arrayAwareToString((Object)field);
        }
        return fields;
    }

    private static int[] columnWidthsByContent(String[] columnNames, List<String[]> rows, int maxColumnWidth) {
        int[] colWidths = Stream.of(columnNames).mapToInt(String::length).toArray();
        for (String[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                colWidths[i] = Math.max(colWidths[i], PrintUtils.getStringDisplayWidth(row[i]));
            }
        }
        for (int i = 0; i < colWidths.length; ++i) {
            colWidths[i] = Math.min(colWidths[i], maxColumnWidth);
        }
        return colWidths;
    }

    public static String genBorderLine(int[] colWidths) {
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        for (int width : colWidths) {
            sb.append(EncodingUtils.repeat('-', width + 1));
            sb.append("-+");
        }
        return sb.toString();
    }

    public static int[] columnWidthsByType(List<TableColumn> columns, int maxColumnWidth, String nullColumn, @Nullable String rowKindColumn) {
        int[] colWidths = columns.stream().mapToInt(col -> col.getName().length()).toArray();
        for (int i = 0; i < columns.size(); ++i) {
            int len;
            LogicalType type = columns.get(i).getType().getLogicalType();
            switch (type.getTypeRoot()) {
                case TINYINT: {
                    len = 4;
                    break;
                }
                case SMALLINT: {
                    len = 6;
                    break;
                }
                case INTEGER: {
                    len = 11;
                    break;
                }
                case BIGINT: {
                    len = 20;
                    break;
                }
                case DECIMAL: {
                    len = ((DecimalType)type).getPrecision() + 2;
                    break;
                }
                case BOOLEAN: {
                    len = 5;
                    break;
                }
                case DATE: {
                    len = 10;
                    break;
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    int precision = ((TimeType)type).getPrecision();
                    len = precision == 0 ? 8 : precision + 9;
                    break;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    int precision = ((TimestampType)type).getPrecision();
                    len = PrintUtils.timestampTypeColumnWidth(precision);
                    break;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    int precision = ((LocalZonedTimestampType)type).getPrecision();
                    len = PrintUtils.timestampTypeColumnWidth(precision);
                    break;
                }
                default: {
                    len = maxColumnWidth;
                }
            }
            colWidths[i] = Math.max(colWidths[i], Math.max(len, nullColumn.length()));
        }
        if (rowKindColumn != null) {
            int[] ret = new int[columns.size() + 1];
            ret[0] = rowKindColumn.length();
            System.arraycopy(colWidths, 0, ret, 1, columns.size());
            return ret;
        }
        return colWidths;
    }

    private static int timestampTypeColumnWidth(int precision) {
        int base = 19;
        if (precision == 0) {
            return base + 2;
        }
        if (precision <= 3) {
            return base + 4;
        }
        if (precision <= 6) {
            return base + 7;
        }
        return base + 10;
    }

    public static void printSingleRow(int[] colWidths, String[] cols, PrintWriter printWriter) {
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        int idx = 0;
        for (String col : cols) {
            sb.append(" ");
            int displayWidth = PrintUtils.getStringDisplayWidth(col);
            if (displayWidth <= colWidths[idx]) {
                sb.append(EncodingUtils.repeat(' ', colWidths[idx] - displayWidth));
                sb.append(col);
            } else {
                sb.append(PrintUtils.truncateString(col, colWidths[idx] - COLUMN_TRUNCATED_FLAG.length()));
                sb.append(COLUMN_TRUNCATED_FLAG);
            }
            sb.append(" |");
            ++idx;
        }
        printWriter.println(sb.toString());
        printWriter.flush();
    }

    private static String truncateString(String col, int targetWidth) {
        String substring;
        int lackedWidth;
        int i;
        int passedWidth = 0;
        for (i = 0; i < col.length(); ++i) {
            passedWidth = PrintUtils.isFullWidth(Character.codePointAt(col, i)) ? (passedWidth += 2) : ++passedWidth;
            if (passedWidth > targetWidth) break;
        }
        if ((lackedWidth = targetWidth - PrintUtils.getStringDisplayWidth(substring = col.substring(0, i))) > 0) {
            substring = EncodingUtils.repeat(' ', lackedWidth) + substring;
        }
        return substring;
    }

    public static int getStringDisplayWidth(String str) {
        int numOfFullWidthCh = (int)str.codePoints().filter(PrintUtils::isFullWidth).count();
        return str.length() + numOfFullWidthCh;
    }

    public static boolean isFullWidth(int codePoint) {
        int value = UCharacter.getIntPropertyValue(codePoint, 4100);
        switch (value) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
        }
        throw new RuntimeException("unknown UProperty.EAST_ASIAN_WIDTH: " + value);
    }
}

