/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;
import org.apache.flink.util.Preconditions;

@Internal
final class FunctionMappingExtractor {
    private final DataTypeFactory typeFactory;
    private final Class<? extends UserDefinedFunction> function;
    private final String methodName;
    private final SignatureExtraction signatureExtraction;
    @Nullable
    private final ResultExtraction accumulatorExtraction;
    private final ResultExtraction outputExtraction;
    private final MethodVerification verification;

    FunctionMappingExtractor(DataTypeFactory typeFactory, Class<? extends UserDefinedFunction> function, String methodName, SignatureExtraction signatureExtraction, @Nullable ResultExtraction accumulatorExtraction, ResultExtraction outputExtraction, MethodVerification verification) {
        this.typeFactory = typeFactory;
        this.function = function;
        this.methodName = methodName;
        this.signatureExtraction = signatureExtraction;
        this.accumulatorExtraction = accumulatorExtraction;
        this.outputExtraction = outputExtraction;
        this.verification = verification;
    }

    Class<? extends UserDefinedFunction> getFunction() {
        return this.function;
    }

    boolean hasAccumulator() {
        return this.accumulatorExtraction != null;
    }

    Map<FunctionSignatureTemplate, FunctionResultTemplate> extractOutputMapping() {
        try {
            return this.extractResultMappings(this.outputExtraction, FunctionTemplate::getOutputTemplate, this.verification);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in extracting a signature to output mapping.", new Object[0]);
        }
    }

    Map<FunctionSignatureTemplate, FunctionResultTemplate> extractAccumulatorMapping() {
        Preconditions.checkState((boolean)this.hasAccumulator());
        try {
            return this.extractResultMappings(this.accumulatorExtraction, FunctionTemplate::getAccumulatorTemplate, (method, signature, result) -> {
                List<Class<?>> arguments = Stream.concat(Stream.of(result), signature.stream()).collect(Collectors.toList());
                this.verification.verify(method, arguments, null);
            });
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in extracting a signature to accumulator mapping.", new Object[0]);
        }
    }

    private Map<FunctionSignatureTemplate, FunctionResultTemplate> extractResultMappings(ResultExtraction resultExtraction, Function<FunctionTemplate, FunctionResultTemplate> accessor, MethodVerification verification) {
        Set<FunctionTemplate> global = TemplateUtils.extractGlobalFunctionTemplates(this.typeFactory, this.function);
        Set<FunctionResultTemplate> globalResultOnly = TemplateUtils.findResultOnlyTemplates(global, accessor);
        LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings = new LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate>();
        List<Method> methods = ExtractionUtils.collectMethods(this.function, this.methodName);
        if (methods.size() == 0) {
            throw ExtractionUtils.extractionError("Could not find a publicly accessible method named '%s'.", this.methodName);
        }
        for (Method method : methods) {
            try {
                Method correctMethod = FunctionMappingExtractor.correctVarArgMethod(method);
                Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod = this.collectMethodMappings(correctMethod, global, globalResultOnly, resultExtraction, accessor);
                this.verifyMappingForMethod(correctMethod, collectedMappingsPerMethod, verification);
                collectedMappingsPerMethod.forEach((signature, result) -> this.putMapping((Map<FunctionSignatureTemplate, FunctionResultTemplate>)collectedMappings, (FunctionSignatureTemplate)signature, (FunctionResultTemplate)result));
            }
            catch (Throwable t) {
                throw ExtractionUtils.extractionError(t, "Unable to extract a type inference from method:\n%s", method.toString());
            }
        }
        return collectedMappings;
    }

    private static Method correctVarArgMethod(Method method) {
        int paramCount = method.getParameterCount();
        Class<?>[] paramClasses = method.getParameterTypes();
        if (paramCount > 0 && paramClasses[paramCount - 1].getName().equals("scala.collection.Seq")) {
            Type[] paramTypes = method.getGenericParameterTypes();
            ParameterizedType seqType = (ParameterizedType)paramTypes[paramCount - 1];
            Type varArgType = seqType.getActualTypeArguments()[0];
            return ExtractionUtils.collectMethods(method.getDeclaringClass(), method.getName()).stream().filter(Method::isVarArgs).filter(candidate -> candidate.getParameterCount() == paramCount).filter(candidate -> {
                Type[] candidateParamTypes = candidate.getGenericParameterTypes();
                for (int i = 0; i < paramCount - 1; ++i) {
                    if (candidateParamTypes[i] == paramTypes[i]) continue;
                    return false;
                }
                Class<?> candidateVarArgType = candidate.getParameterTypes()[paramCount - 1];
                return candidateVarArgType.isArray() && (varArgType == Object.class || candidateVarArgType.getComponentType() == varArgType);
            }).findAny().orElse(method);
        }
        return method;
    }

    private Map<FunctionSignatureTemplate, FunctionResultTemplate> collectMethodMappings(Method method, Set<FunctionTemplate> global, Set<FunctionResultTemplate> globalResultOnly, ResultExtraction resultExtraction, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod = new LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate>();
        Set<FunctionTemplate> local = TemplateUtils.extractLocalFunctionTemplates(this.typeFactory, method);
        Set<FunctionResultTemplate> localResultOnly = TemplateUtils.findResultOnlyTemplates(local, accessor);
        Set<FunctionTemplate> explicitMappings = TemplateUtils.findResultMappingTemplates(global, local, accessor);
        FunctionResultTemplate resultOnly = TemplateUtils.findResultOnlyTemplate(globalResultOnly, localResultOnly, explicitMappings, accessor);
        Set<FunctionSignatureTemplate> inputOnly = TemplateUtils.findInputOnlyTemplates(global, local, accessor);
        this.putExplicitMappings(collectedMappingsPerMethod, explicitMappings, inputOnly, accessor);
        this.putUniqueResultMappings(collectedMappingsPerMethod, resultOnly, inputOnly, method);
        this.putExtractedResultMappings(collectedMappingsPerMethod, inputOnly, resultExtraction, method);
        return collectedMappingsPerMethod;
    }

    private void putExplicitMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, Set<FunctionTemplate> explicitMappings, Set<FunctionSignatureTemplate> signatureOnly, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        explicitMappings.forEach(t -> Stream.concat(signatureOnly.stream(), Stream.of(t.getSignatureTemplate())).forEach(v -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)v, (FunctionResultTemplate)accessor.apply((FunctionTemplate)t))));
    }

    private void putUniqueResultMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, @Nullable FunctionResultTemplate uniqueResult, Set<FunctionSignatureTemplate> signatureOnly, Method method) {
        if (uniqueResult == null) {
            return;
        }
        if (!signatureOnly.isEmpty()) {
            signatureOnly.forEach(s -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)s, uniqueResult));
        } else {
            this.putMapping(collectedMappings, this.signatureExtraction.extract(this, method), uniqueResult);
        }
    }

    private void putExtractedResultMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, Set<FunctionSignatureTemplate> inputOnly, ResultExtraction resultExtraction, Method method) {
        if (!collectedMappings.isEmpty()) {
            return;
        }
        FunctionResultTemplate result = resultExtraction.extract(this, method);
        if (!inputOnly.isEmpty()) {
            inputOnly.forEach(signature -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)signature, result));
        } else {
            FunctionSignatureTemplate signature2 = this.signatureExtraction.extract(this, method);
            this.putMapping(collectedMappings, signature2, result);
        }
    }

    private void putMapping(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, FunctionSignatureTemplate signature, FunctionResultTemplate result) {
        FunctionResultTemplate existingResult = collectedMappings.get(signature);
        if (existingResult == null) {
            collectedMappings.put(signature, result);
        } else if (!existingResult.equals(result)) {
            throw ExtractionUtils.extractionError("Function hints with same input definition but different result types are not allowed.", new Object[0]);
        }
    }

    private void verifyMappingForMethod(Method method, Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod, MethodVerification verification) {
        collectedMappingsPerMethod.forEach((signature, result) -> verification.verify(method, signature.toClass(), result.toClass()));
    }

    static SignatureExtraction createParameterSignatureExtraction(int offset) {
        return (extractor, method) -> {
            List<FunctionArgumentTemplate> parameterTypes = FunctionMappingExtractor.extractArgumentTemplates(extractor.typeFactory, extractor.function, method, offset);
            String[] argumentNames = FunctionMappingExtractor.extractArgumentNames(method, offset);
            return FunctionSignatureTemplate.of(parameterTypes, method.isVarArgs(), argumentNames);
        };
    }

    private static List<FunctionArgumentTemplate> extractArgumentTemplates(DataTypeFactory typeFactory, Class<? extends UserDefinedFunction> function, Method method, int offset) {
        return IntStream.range(offset, method.getParameterCount()).mapToObj(i -> FunctionMappingExtractor.tryExtractInputGroupArgument(method, i).orElseGet(() -> FunctionMappingExtractor.extractDataTypeArgument(typeFactory, function, method, i))).collect(Collectors.toList());
    }

    private static Optional<FunctionArgumentTemplate> tryExtractInputGroupArgument(Method method, int paramPos) {
        Parameter parameter = method.getParameters()[paramPos];
        DataTypeHint hint = parameter.getAnnotation(DataTypeHint.class);
        if (hint != null) {
            DataTypeTemplate template = DataTypeTemplate.fromAnnotation(hint, null);
            if (template.inputGroup != null) {
                return Optional.of(FunctionArgumentTemplate.of(template.inputGroup));
            }
        }
        return Optional.empty();
    }

    private static FunctionArgumentTemplate extractDataTypeArgument(DataTypeFactory typeFactory, Class<? extends UserDefinedFunction> function, Method method, int paramPos) {
        DataType type = DataTypeExtractor.extractFromMethodParameter(typeFactory, function, method, paramPos);
        if (method.isVarArgs() && paramPos == method.getParameterCount() - 1) {
            if (type instanceof CollectionDataType) {
                return FunctionArgumentTemplate.of(((CollectionDataType)type).getElementDataType());
            }
            if (type.equals(DataTypes.BYTES())) {
                return FunctionArgumentTemplate.of((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE));
            }
        }
        return FunctionArgumentTemplate.of(type);
    }

    @Nullable
    private static String[] extractArgumentNames(Method method, int offset) {
        List<String> methodParameterNames = ExtractionUtils.extractMethodParameterNames(method);
        if (methodParameterNames != null) {
            return methodParameterNames.subList(offset, methodParameterNames.size()).toArray(new String[0]);
        }
        return null;
    }

    static ResultExtraction createReturnTypeResultExtraction() {
        return (extractor, method) -> {
            DataType dataType = DataTypeExtractor.extractFromMethodOutput(extractor.typeFactory, extractor.function, method);
            return FunctionResultTemplate.of(dataType);
        };
    }

    static ResultExtraction createGenericResultExtraction(Class<? extends UserDefinedFunction> baseClass, int genericPos) {
        return (extractor, method) -> {
            DataType dataType = DataTypeExtractor.extractFromGeneric(extractor.typeFactory, baseClass, genericPos, extractor.function);
            return FunctionResultTemplate.of(dataType);
        };
    }

    static MethodVerification createParameterAndReturnTypeVerification() {
        return (method, signature, result) -> {
            boolean isValid;
            Class[] parameters = signature.toArray(new Class[0]);
            Class<?> returnType = method.getReturnType();
            boolean bl = isValid = ExtractionUtils.isInvokable(method, parameters) && ExtractionUtils.isAssignable(result, returnType, true);
            if (!isValid) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, result);
            }
        };
    }

    static MethodVerification createParameterWithAccumulatorVerification() {
        return (method, signature, result) -> {
            if (result != null) {
                FunctionMappingExtractor.createParameterWithArgumentVerification(null).verify(method, signature, result);
            } else {
                FunctionMappingExtractor.createParameterVerification().verify(method, signature, null);
            }
        };
    }

    static MethodVerification createParameterWithArgumentVerification(@Nullable Class<?> argumentClass) {
        return (method, signature, result) -> {
            Class[] parameters = (Class[])Stream.concat(Stream.of(argumentClass), signature.stream()).toArray(Class[]::new);
            if (!ExtractionUtils.isInvokable(method, parameters)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, null);
            }
        };
    }

    static MethodVerification createParameterVerification() {
        return (method, signature, result) -> {
            Class[] parameters = signature.toArray(new Class[0]);
            if (!ExtractionUtils.isInvokable(method, parameters)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, null);
            }
        };
    }

    private static ValidationException createMethodNotFoundError(String methodName, Class<?>[] parameters, @Nullable Class<?> returnType) {
        return ExtractionUtils.extractionError("Considering all hints, the method should comply with the signature:\n%s", ExtractionUtils.createMethodSignatureString(methodName, parameters, returnType));
    }

    static interface MethodVerification {
        public void verify(Method var1, List<Class<?>> var2, Class<?> var3);
    }

    static interface ResultExtraction {
        @Nullable
        public FunctionResultTemplate extract(FunctionMappingExtractor var1, Method var2);
    }

    static interface SignatureExtraction {
        public FunctionSignatureTemplate extract(FunctionMappingExtractor var1, Method var2);
    }
}

