/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CollectionDataType
extends DataType {
    private final DataType elementDataType;

    public CollectionDataType(LogicalType logicalType, @Nullable Class<?> conversionClass, DataType elementDataType) {
        super(logicalType, CollectionDataType.ensureArrayConversionClass(logicalType, elementDataType, conversionClass));
        this.elementDataType = (DataType)Preconditions.checkNotNull((Object)elementDataType, (String)"Element data type must not be null.");
    }

    public CollectionDataType(LogicalType logicalType, DataType elementDataType) {
        this(logicalType, null, elementDataType);
    }

    public DataType getElementDataType() {
        return this.elementDataType;
    }

    @Override
    public DataType notNull() {
        return new CollectionDataType(this.logicalType.copy(false), this.conversionClass, this.elementDataType);
    }

    @Override
    public DataType nullable() {
        return new CollectionDataType(this.logicalType.copy(true), this.conversionClass, this.elementDataType);
    }

    @Override
    public DataType bridgedTo(Class<?> newConversionClass) {
        return new CollectionDataType(this.logicalType, (Class)Preconditions.checkNotNull(newConversionClass, (String)"New conversion class must not be null."), this.ensureElementConversionClass(this.elementDataType, newConversionClass));
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.singletonList(this.elementDataType);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollectionDataType that = (CollectionDataType)o;
        return this.elementDataType.equals(that.elementDataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementDataType);
    }

    private static Class<?> ensureArrayConversionClass(LogicalType logicalType, DataType elementDataType, @Nullable Class<?> clazz) {
        if (logicalType.getTypeRoot() == LogicalTypeRoot.ARRAY && clazz == null) {
            return Array.newInstance(elementDataType.getConversionClass(), 0).getClass();
        }
        return clazz;
    }

    private DataType ensureElementConversionClass(DataType elementDataType, Class<?> clazz) {
        if (this.logicalType.getTypeRoot() == LogicalTypeRoot.ARRAY && clazz.isArray()) {
            return (DataType)elementDataType.bridgedTo(clazz.getComponentType());
        }
        return elementDataType;
    }
}

