/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001=\u00111\u0004\u0015:pGRKW.Z*peR\u0004&o\\2fgN4UO\\2uS>t'BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0003!u\u0019\"\u0001A\t\u0011\u000bII2$K\u0015\u000e\u0003MQ!\u0001F\u000b\u0002\u0013\u0019,hn\u0019;j_:\u001c(B\u0001\f\u0018\u0003\r\t\u0007/\u001b\u0006\u00031!\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005i\u0019\"\u0001F&fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0002\u001d;1\u0001A!\u0002\u0010\u0001\u0005\u0004y\"!A&\u0012\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#a\u0002(pi\"Lgn\u001a\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\u0007\u0005s\u0017\u0010\u0005\u0002+[5\t1F\u0003\u0002-\t\u0005)A/\u001f9fg&\u0011af\u000b\u0002\u0005\u0007J{w\u000f\u0003\u00051\u0001\t\u0015\r\u0011\"\u00032\u00031Ig\u000e];u%><H+\u001f9f+\u0005\u0011\u0004C\u0001\u00164\u0013\t!4F\u0001\u0007D%><H+\u001f9f\u0013:4w\u000e\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u00035Ig\u000e];u%><H+\u001f9fA!A\u0001\b\u0001BC\u0002\u0013%\u0011(A\u0007s_^\u001cu.\u001c9be\u0006$xN]\u000b\u0002uA\u00111\bP\u0007\u0002\u0005%\u0011QH\u0001\u0002\u0018\u0007>dG.Z2uS>t'k\\<D_6\u0004\u0018M]1u_JD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IAO\u0001\u000fe><8i\\7qCJ\fGo\u001c:!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q\u00191\tR#\u0011\u0007m\u00021\u0004C\u00031\u0001\u0002\u0007!\u0007C\u00039\u0001\u0002\u0007!\bC\u0005H\u0001\u0001\u0007\t\u0019!C\u0005\u0011\u0006q!-\u001e4gKJ,G-\u0012<f]R\u001cX#A%\u0011\u0007)\u0003&+D\u0001L\u0015\taU*A\u0003ti\u0006$XM\u0003\u0002O\u001f\u000611m\\7n_:T!A\u0006\u0005\n\u0005E[%!\u0003'jgR\u001cF/\u0019;f!\t\u0019V+D\u0001U\u0015\ta\u0003\"\u0003\u0002W)\n\u0019!k\\<\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0013I\u0016A\u00052vM\u001a,'/\u001a3Fm\u0016tGo]0%KF$\"AW/\u0011\u0005\u0005Z\u0016B\u0001/#\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0001\u0004\u0001\u0019!A!B\u0013I\u0015a\u00042vM\u001a,'/\u001a3Fm\u0016tGo\u001d\u0011\t\u000f\t\u0004!\u0019!C\u0005G\u0006Q1o\u001c:u\u0005V4g-\u001a:\u0016\u0003\u0011\u00042!\u001a6S\u001b\u00051'BA4i\u0003\u0011)H/\u001b7\u000b\u0003%\fAA[1wC&\u00111N\u001a\u0002\n\u0003J\u0014\u0018-\u001f'jgRDa!\u001c\u0001!\u0002\u0013!\u0017aC:peR\u0014UO\u001a4fe\u0002B\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00029\u0002\u000f=,H\u000f];u\u0007V\t\u0011\u0006C\u0005s\u0001\u0001\u0007\t\u0019!C\u0005g\u0006Yq.\u001e;qkR\u001cu\fJ3r)\tQF\u000fC\u0004_c\u0006\u0005\t\u0019A\u0015\t\u0013Y\u0004\u0001\u0019!A!B\u0013I\u0013\u0001C8viB,Ho\u0011\u0011\t\u000ba\u0004A\u0011I=\u0002\t=\u0004XM\u001c\u000b\u00035jDQa_<A\u0002q\faaY8oM&<\u0007cA?\u0002\u00025\taP\u0003\u0002\u0000\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L1!a\u0001\u007f\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\b5\u0006-\u0011qBA\r\u0011\u001d\ti!!\u0002A\u0002%\na!\u001b8qkR\u001c\u0005\u0002CA\t\u0003\u000b\u0001\r!a\u0005\u0002\u0007\r$\b\u0010E\u0002\u0012\u0003+I1!a\u0006\u001a\u0005\u001d\u0019uN\u001c;fqRD\u0001\"a\u0007\u0002\u0006\u0001\u0007\u0011QD\u0001\u0004_V$\b#BA\u0010\u0003GISBAA\u0011\u0015\t9\u0007\"\u0003\u0003\u0002&\u0005\u0005\"!C\"pY2,7\r^8s\u0011\u001d\tI\u0003\u0001C!\u0003W\tqa\u001c8US6,'\u000fF\u0004[\u0003[\t9$a\u0010\t\u0011\u0005=\u0012q\u0005a\u0001\u0003c\t\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\u0005\n\u0019$C\u0002\u00026\t\u0012A\u0001T8oO\"A\u0011\u0011CA\u0014\u0001\u0004\tI\u0004E\u0002\u0012\u0003wI1!!\u0010\u001a\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"a\u0007\u0002(\u0001\u0007\u0011Q\u0004")
public class ProcTimeSortProcessFunction<K>
extends KeyedProcessFunction<K, CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final CollectionRowComparator rowComparator;
    private ListState<Row> bufferedEvents;
    private final ArrayList<Row> sortBuffer;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private CollectionRowComparator rowComparator() {
        return this.rowComparator;
    }

    private ListState<Row> bufferedEvents() {
        return this.bufferedEvents;
    }

    private void bufferedEvents_$eq(ListState<Row> x$1) {
        this.bufferedEvents = x$1;
    }

    private ArrayList<Row> sortBuffer() {
        return this.sortBuffer;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        ListStateDescriptor sortDescriptor = new ListStateDescriptor("sortState", (TypeInformation)this.inputRowType().rowType());
        this.bufferedEvents_$eq((ListState<Row>)this.getRuntimeContext().getListState(sortDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        long currentTime = ctx.timerService().currentProcessingTime();
        this.bufferedEvents().add((Object)input);
        ctx.timerService().registerProcessingTimeTimer(currentTime + 1L);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator iter = ((Iterable)this.bufferedEvents().get()).iterator();
        this.sortBuffer().clear();
        while (iter.hasNext()) {
            this.sortBuffer().add((Row)iter.next());
        }
        Collections.sort(this.sortBuffer(), this.rowComparator());
        for (int i = 0; i < this.sortBuffer().size(); ++i) {
            this.outputC().row_$eq(this.sortBuffer().get(i));
            out.collect((Object)this.outputC());
        }
        this.bufferedEvents().clear();
    }

    public ProcTimeSortProcessFunction(CRowTypeInfo inputRowType, CollectionRowComparator rowComparator) {
        this.inputRowType = inputRowType;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull((Object)rowComparator);
        this.sortBuffer = new ArrayList();
    }
}

