/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001=\u0011q\u0003\u0015:pGRKW.\u001a\"pk:$W\r\u001a*poN|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002\u001fA\u0014XmY3eS:<wJ\u001a4tKR\u0004\"a\u0007!\n\u0005\u0005c\"\u0001\u0002'p]\u001eD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u0013C\u001e<'/Z4bi\u0016\u001cH+\u001f9f\u0013:4w\u000e\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006IA/\u001f9fkRLGn\u001d\u0006\u0003\u0013*\u000bAA[1wC*\u00111\nC\u0001\u0004CBL\u0017BA'G\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b\u0011\"\u001b8qkR$\u0016\u0010]3\u0011\u0007E36%D\u0001S\u0015\t\u0019F+\u0001\u0005usB,\u0017N\u001c4p\u0015\t)&*\u0001\u0004d_6lwN\\\u0005\u0003/J\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t3\u0002\u0011\t\u0011)A\u0005\u007f\u0005\u0001R.\u001b8SKR,g\u000e^5p]RKW.\u001a\u0005\t7\u0002\u0011\t\u0011)A\u0005\u007f\u0005\u0001R.\u0019=SKR,g\u000e^5p]RKW.\u001a\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f}\u0003\u0017MY2eKB\u0019!\u0003A\u000b\t\u000beb\u0006\u0019\u0001\u001e\t\u000byb\u0006\u0019A \t\u000b\rc\u0006\u0019\u0001#\t\u000b=c\u0006\u0019\u0001)\t\u000bec\u0006\u0019A \t\u000bmc\u0006\u0019A \t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0017\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u0005I\u0007c\u00016n_6\t1N\u0003\u0002m)\u0006)1\u000f^1uK&\u0011an\u001b\u0002\u000b-\u0006dW/Z*uCR,\u0007C\u00019s\u001b\u0005\t(B\u0001\u0014\t\u0013\t\u0019\u0018OA\u0002S_^D\u0011\"\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002<\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\t9(\u0010\u0005\u0002\u001cq&\u0011\u0011\u0010\b\u0002\u0005+:LG\u000fC\u0004|i\u0006\u0005\t\u0019A5\u0002\u0007a$\u0013\u0007C\u0005~\u0001\u0001\u0007\t\u0011)Q\u0005S\u0006\t\u0012mY2v[Vd\u0017\r^8s'R\fG/\u001a\u0011\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t!A\u0006s_^l\u0015\r]*uCR,WCAA\u0002!\u0019Q\u0017QA \u0002\n%\u0019\u0011qA6\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004R!a\u0003\u0002\u0012=l!!!\u0004\u000b\u0007U\nyAC\u0001J\u0013\u0011\t\u0019\"!\u0004\u0003\t1K7\u000f\u001e\u0005\f\u0003/\u0001\u0001\u0019!a\u0001\n\u0013\tI\"A\bs_^l\u0015\r]*uCR,w\fJ3r)\r9\u00181\u0004\u0005\nw\u0006U\u0011\u0011!a\u0001\u0003\u0007A1\"a\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004\u0005a!o\\<NCB\u001cF/\u0019;fA!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0013\u0003\u0019yW\u000f\u001e9viV\t1\u0005C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0012AC8viB,Ho\u0018\u0013fcR\u0019q/!\f\t\u0011m\f9#!AA\u0002\rB!\"!\r\u0001\u0001\u0004\u0005\t\u0015)\u0003$\u0003\u001dyW\u000f\u001e9vi\u0002B1\"!\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00028\u0005a1m\\;oi\u0016\u00148\u000b^1uKV\u0011\u0011\u0011\b\t\u0004U6|\u0004bCA\u001f\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007f\t\u0001cY8v]R,'o\u0015;bi\u0016|F%Z9\u0015\u0007]\f\t\u0005C\u0005|\u0003w\t\t\u00111\u0001\u0002:!Y\u0011Q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001d\u00035\u0019w.\u001e8uKJ\u001cF/\u0019;fA!Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011BA\u001c\u0003=\u0019X.\u00197mKN$Hk]*uCR,\u0007bCA'\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001f\n1c]7bY2,7\u000f\u001e+t'R\fG/Z0%KF$2a^A)\u0011%Y\u00181JA\u0001\u0002\u0004\tI\u0004C\u0006\u0002V\u0001\u0001\r\u0011!Q!\n\u0005e\u0012\u0001E:nC2dWm\u001d;UgN#\u0018\r^3!\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\f\u0003?\u0002\u0001\u0019!a\u0001\n\u0013\t\t'\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002x\u0003GB\u0001b_A/\u0003\u0003\u0005\ra\f\u0005\u000b\u0003O\u0002\u0001\u0019!A!B\u0013y\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\tY\u0007\u0001C!\u0003[\nAa\u001c9f]R\u0019q/a\u001c\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003g\naaY8oM&<\u0007\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005e\u0004\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003{\n9HA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003\u0003\u0003A\u0011IAB\u00039\u0001(o\\2fgN,E.Z7f]R$ra^AC\u0003\u0013\u000b)\u000bC\u0004\u0002\b\u0006}\u0004\u0019A\u0012\u0002\r%t\u0007/\u001e;D\u0011!\tY)a A\u0002\u00055\u0015aA2uqB!\u0011qRAQ!\u001d\t\t*!(\u0016G\rj!!a%\u000b\t\u0005U\u0015qS\u0001\nMVt7\r^5p]NT1aSAM\u0015\r\tY\nC\u0001\ngR\u0014X-Y7j]\u001eLA!a(\u0002\u0014\n!2*Z=fIB\u0013xnY3tg\u001a+hn\u0019;j_:LA!a)\u0002\u001e\n91i\u001c8uKb$\b\u0002CAT\u0003\u007f\u0002\r!!+\u0002\u0007=,H\u000fE\u0003\u0002,\u0006=6%\u0004\u0002\u0002.*\u0011Q\u0007C\u0005\u0005\u0003c\u000biKA\u0005D_2dWm\u0019;pe\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0016aB8o)&lWM\u001d\u000b\bo\u0006e\u0016QXAc\u0011\u001d\tY,a-A\u0002}\n\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005-\u00151\u0017a\u0001\u0003\u007f\u0003B!a$\u0002B&!\u00111YAO\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"a*\u00024\u0002\u0007\u0011\u0011\u0016\u0005\b\u0003\u0013\u0004A\u0011IAf\u0003\u0015\u0019Gn\\:f)\u00059\b")
public class ProcTimeBoundedRowsOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingOffset;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private CRow output;
    private ValueState<Object> counterState;
    private ValueState<Object> smallestTsState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        ProcTimeBoundedRowsOver procTimeBoundedRowsOver = this;
        synchronized (procTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> counterState() {
        return this.counterState;
    }

    private void counterState_$eq(ValueState<Object> x$1) {
        this.counterState = x$1;
    }

    private ValueState<Object> smallestTsState() {
        return this.smallestTsState;
    }

    private void smallestTsState_$eq(ValueState<Object> x$1) {
        this.smallestTsState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("windowBufferMapState", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor aggregationStateDescriptor = new ValueStateDescriptor("aggregationState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(aggregationStateDescriptor));
        ValueStateDescriptor processedCountDescriptor = new ValueStateDescriptor("processedCountState", Long.TYPE);
        this.counterState_$eq((ValueState<Object>)this.getRuntimeContext().getState(processedCountDescriptor));
        ValueStateDescriptor smallestTimestampDescriptor = new ValueStateDescriptor("smallestTSState", Long.TYPE);
        this.smallestTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(smallestTimestampDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long counter;
        long smallestTs;
        Row input = inputC.row();
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        if ((smallestTs = BoxesRunTime.unboxToLong((Object)this.smallestTsState().value())) == 0L) {
            smallestTs = currentTime;
            this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)smallestTs));
        }
        if ((counter = BoxesRunTime.unboxToLong((Object)this.counterState().value())) == this.precedingOffset) {
            List retractList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)smallestTs));
            Row retractRow = (Row)retractList.get(0);
            this.function().retract(accumulators, retractRow);
            retractList.remove(0);
            if (!retractList.isEmpty()) {
                this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)smallestTs), (Object)retractList);
            } else {
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)smallestTs));
                Iterator iter = this.rowMapState().keys().iterator();
                long currentTs = 0L;
                long newSmallestTs = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    currentTs = BoxesRunTime.unboxToLong(iter.next());
                    if (currentTs >= newSmallestTs) continue;
                    newSmallestTs = currentTs;
                }
                this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)newSmallestTs));
            }
        } else {
            this.counterState().update((Object)BoxesRunTime.boxToLong((long)(++counter)));
        }
        this.function().setForwardedFields(input, this.output().row());
        this.function().accumulate(accumulators, input);
        this.function().setAggregationResults(accumulators, this.output().row());
        List currentTimeState = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime));
        if (currentTimeState != null) {
            currentTimeState.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime), (Object)currentTimeState);
        } else {
            ArrayList<Row> newList = new ArrayList<Row>();
            newList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime), newList);
        }
        this.accumulatorState().update((Object)accumulators);
        out.collect((Object)this.output());
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block0: {
            if (!this.stateCleaningEnabled()) break block0;
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState(), this.counterState(), this.smallestTsState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        block0: {
            if (this.function() == null) break block0;
            this.function().close();
        }
    }

    public ProcTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, long precedingOffset, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.precedingOffset = precedingOffset;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(minRetentionTime, maxRetentionTime);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkArgument((precedingOffset > 0L ? 1 : 0) != 0);
    }
}

