/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.expressions.And;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Or;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionConverter$;
import org.apache.flink.table.expressions.PlannerResolvedFieldReference;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001=\u0011ADU3y\u001d>$W\rV8FqB\u0014Xm]:j_:\u001cuN\u001c<feR,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007eq\u0002%D\u0001\u001b\u0015\tYB$A\u0002sKbT!!\b\u0006\u0002\u000f\r\fGnY5uK&\u0011qD\u0007\u0002\u000b%\u0016Dh+[:ji>\u0014\bcA\u0011%M5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004PaRLwN\u001c\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0019\t1\"\u001a=qe\u0016\u001c8/[8og&\u00111\u0006\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u0015%t\u0007/\u001e;OC6,7\u000fE\u0002\"_EJ!\u0001\r\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005IJdBA\u001a8!\t!$%D\u00016\u0015\t1d\"\u0001\u0004=e>|GOP\u0005\u0003q\t\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001H\t\u0005\t{\u0001\u0011\t\u0011)A\u0005}\u0005ya-\u001e8di&|gnQ1uC2|w\r\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\r\u000591-\u0019;bY><\u0017BA\"A\u0005=1UO\\2uS>t7)\u0019;bY><\u0007\"B#\u0001\t\u00031\u0015A\u0002\u001fj]&$h\bF\u0002H\u0013*\u0003\"\u0001\u0013\u0001\u000e\u0003\tAQ!\f#A\u00029BQ!\u0010#A\u0002yBQ\u0001\u0014\u0001\u0005B5\u000bQB^5tSRLe\u000e];u%\u00164GC\u0001\u0011O\u0011\u0015y5\n1\u0001Q\u0003!Ig\u000e];u%\u00164\u0007CA\rR\u0013\t\u0011&DA\u0006SKbLe\u000e];u%\u00164\u0007\"\u0002+\u0001\t\u0003*\u0016A\u0005<jg&$H+\u00192mK&s\u0007/\u001e;SK\u001a$\"\u0001\t,\t\u000b]\u001b\u0006\u0019\u0001-\u0002!I,\u0007\u0010V1cY\u0016Le\u000e];u%\u00164\u0007CA\rZ\u0013\tQ&D\u0001\tSKb$\u0016M\u00197f\u0013:\u0004X\u000f\u001e*fM\")A\f\u0001C!;\u0006ia/[:ji2{7-\u00197SK\u001a$\"\u0001\t0\t\u000b}[\u0006\u0019\u00011\u0002\u00111|7-\u00197SK\u001a\u0004\"!G1\n\u0005\tT\"a\u0003*fq2{7-\u00197SK\u001aDQ\u0001\u001a\u0001\u0005B\u0015\fAB^5tSRd\u0015\u000e^3sC2$\"\u0001\t4\t\u000b\u001d\u001c\u0007\u0019\u00015\u0002\u000f1LG/\u001a:bYB\u0011\u0011$[\u0005\u0003Uj\u0011!BU3y\u0019&$XM]1m\u0011\u0015a\u0007\u0001\"\u0011n\u0003%1\u0018n]5u\u0007\u0006dG\u000e\u0006\u0002!]\")qn\u001ba\u0001a\u0006!1-\u00197m!\tI\u0012/\u0003\u0002s5\t9!+\u001a=DC2d\u0007\"\u0002;\u0001\t\u0003*\u0018\u0001\u0005<jg&$h)[3mI\u0006\u001b7-Z:t)\t\u0001c\u000fC\u0003xg\u0002\u0007\u00010A\u0006gS\u0016dG-Q2dKN\u001c\bCA\rz\u0013\tQ(D\u0001\bSKb4\u0015.\u001a7e\u0003\u000e\u001cWm]:\t\u000bq\u0004A\u0011I?\u0002'YL7/\u001b;D_J\u0014X\r\u001c,be&\f'\r\\3\u0015\u0005\u0001r\bBB@|\u0001\u0004\t\t!\u0001\bd_J\u0014X\r\u001c,be&\f'\r\\3\u0011\u0007e\t\u0019!C\u0002\u0002\u0006i\u0011\u0011CU3y\u0007>\u0014(/\u001a7WCJL\u0017M\u00197f\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\tQB^5tSR\u0014\u0016M\\4f%\u00164Gc\u0001\u0011\u0002\u000e!A\u0011qBA\u0004\u0001\u0004\t\t\"\u0001\u0005sC:<WMU3g!\rI\u00121C\u0005\u0004\u0003+Q\"a\u0003*fqJ\u000bgnZ3SK\u001aDq!!\u0007\u0001\t\u0003\nY\"A\u0007wSNLGoU;c#V,'/\u001f\u000b\u0004A\u0005u\u0001\u0002CA\u0010\u0003/\u0001\r!!\t\u0002\u0011M,(-U;fef\u00042!GA\u0012\u0013\r\t)C\u0007\u0002\f%\u0016D8+\u001e2Rk\u0016\u0014\u0018\u0010C\u0004\u0002*\u0001!\t%a\u000b\u0002#YL7/\u001b;Es:\fW.[2QCJ\fW\u000eF\u0002!\u0003[A\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\rIft\u0017-\\5d!\u0006\u0014\u0018-\u001c\t\u00043\u0005M\u0012bAA\u001b5\ty!+\u001a=Es:\fW.[2QCJ\fW\u000eC\u0004\u0002:\u0001!\t%a\u000f\u0002\u0013YL7/\u001b;Pm\u0016\u0014Hc\u0001\u0011\u0002>!A\u0011qHA\u001c\u0001\u0004\t\t%\u0001\u0003pm\u0016\u0014\bcA\r\u0002D%\u0019\u0011Q\t\u000e\u0003\u000fI+\u0007p\u0014<fe\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013\u0001\u0006<jg&$\b+\u0019;uKJtg)[3mIJ+g\rF\u0002!\u0003\u001bB\u0001\"a\u0014\u0002H\u0001\u0007\u0011\u0011K\u0001\tM&,G\u000e\u001a*fMB\u0019\u0011$a\u0015\n\u0007\u0005U#D\u0001\nSKb\u0004\u0016\r\u001e;fe:4\u0015.\u001a7e%\u00164\u0007bBA-\u0001\u0011%\u00111L\u0001\u000fY>|7.\u001e9Gk:\u001cG/[8o)\u0015\u0001\u0013QLA1\u0011\u001d\ty&a\u0016A\u0002E\nAA\\1nK\"A\u00111MA,\u0001\u0004\t)'\u0001\u0005pa\u0016\u0014\u0018M\u001c3t!\u0015\t9'!\u001d'\u001d\u0011\tI'!\u001c\u000f\u0007Q\nY'C\u0001$\u0013\r\tyGI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019(!\u001e\u0003\u0007M+\u0017OC\u0002\u0002p\tBq!!\u001f\u0001\t\u0013\tY(A\u0004sKBd\u0017mY3\u0015\u0007E\ni\bC\u0004\u0002\u0000\u0005]\u0004\u0019A\u0019\u0002\u0007M$(\u000f")
public class RexNodeToExpressionConverter
implements RexVisitor<Option<Expression>> {
    private final String[] inputNames;
    private final FunctionCatalog functionCatalog;

    @Override
    public Option<Expression> visitInputRef(RexInputRef inputRef) {
        Preconditions.checkArgument((inputRef.getIndex() < this.inputNames.length ? 1 : 0) != 0);
        return new Some((Object)new PlannerResolvedFieldReference(this.inputNames[inputRef.getIndex()], FlinkTypeFactory$.MODULE$.toTypeInfo(inputRef.getType())));
    }

    @Override
    public Option<Expression> visitTableInputRef(RexTableInputRef rexTableInputRef) {
        return this.visitInputRef(rexTableInputRef);
    }

    @Override
    public Option<Expression> visitLocalRef(RexLocalRef localRef) {
        throw new TableException("Bug: RexLocalRef should have been expanded");
    }

    @Override
    public Option<Expression> visitLiteral(RexLiteral literal) {
        Object object;
        TypeInformation<?> literalType;
        TypeInformation<?> typeInformation = literalType = FlinkTypeFactory$.MODULE$.toTypeInfo(literal.getType());
        SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (!(sqlTimeTypeInfo != null ? !sqlTimeTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
            DateString rexValue = literal.getValueAs(DateString.class);
            object = Date.valueOf(rexValue.toString());
        } else {
            SqlTimeTypeInfo sqlTimeTypeInfo2 = SqlTimeTypeInfo.TIME;
            TypeInformation<?> typeInformation3 = typeInformation;
            if (!(sqlTimeTypeInfo2 != null ? !sqlTimeTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                TimeString rexValue = literal.getValueAs(TimeString.class);
                object = Time.valueOf(rexValue.toString(0));
            } else {
                SqlTimeTypeInfo sqlTimeTypeInfo3 = SqlTimeTypeInfo.TIMESTAMP;
                TypeInformation<?> typeInformation4 = typeInformation;
                if (!(sqlTimeTypeInfo3 != null ? !sqlTimeTypeInfo3.equals(typeInformation4) : typeInformation4 != null)) {
                    TimestampString rexValue = literal.getValueAs(TimestampString.class);
                    object = Timestamp.valueOf(rexValue.toString(3));
                } else {
                    BasicTypeInfo basicTypeInfo = BasicTypeInfo.BYTE_TYPE_INFO;
                    TypeInformation<?> typeInformation5 = typeInformation;
                    if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation5) : typeInformation5 != null)) {
                        object = literal.getValueAs(Byte.class);
                    } else {
                        BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.SHORT_TYPE_INFO;
                        TypeInformation<?> typeInformation6 = typeInformation;
                        if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(typeInformation6) : typeInformation6 != null)) {
                            object = literal.getValueAs(Short.class);
                        } else {
                            BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.INT_TYPE_INFO;
                            TypeInformation<?> typeInformation7 = typeInformation;
                            if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(typeInformation7) : typeInformation7 != null)) {
                                object = literal.getValueAs(Integer.class);
                            } else {
                                BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.LONG_TYPE_INFO;
                                TypeInformation<?> typeInformation8 = typeInformation;
                                if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(typeInformation8) : typeInformation8 != null)) {
                                    object = literal.getValueAs(Long.class);
                                } else {
                                    BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.FLOAT_TYPE_INFO;
                                    TypeInformation<?> typeInformation9 = typeInformation;
                                    if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(typeInformation9) : typeInformation9 != null)) {
                                        object = literal.getValueAs(Float.class);
                                    } else {
                                        BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                                        TypeInformation<?> typeInformation10 = typeInformation;
                                        if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(typeInformation10) : typeInformation10 != null)) {
                                            object = literal.getValueAs(Double.class);
                                        } else {
                                            BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.STRING_TYPE_INFO;
                                            TypeInformation<?> typeInformation11 = typeInformation;
                                            if (!(basicTypeInfo7 != null ? !basicTypeInfo7.equals(typeInformation11) : typeInformation11 != null)) {
                                                object = literal.getValueAs(String.class);
                                            } else {
                                                BasicTypeInfo basicTypeInfo8 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                                                TypeInformation<?> typeInformation12 = typeInformation;
                                                if (!(basicTypeInfo8 != null ? !basicTypeInfo8.equals(typeInformation12) : typeInformation12 != null)) {
                                                    object = literal.getValueAs(Boolean.class);
                                                } else {
                                                    BasicTypeInfo basicTypeInfo9 = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                                                    TypeInformation<?> typeInformation13 = typeInformation;
                                                    if (!(basicTypeInfo9 != null ? !basicTypeInfo9.equals(typeInformation13) : typeInformation13 != null)) {
                                                        object = literal.getValueAs(BigDecimal.class);
                                                    } else {
                                                        RexProgramExtractor$.MODULE$.LOG().debug("Literal {} of SQL type {} is not supported and cannot be converted. Please reach out to the community if you think this type should be supported.", new Object[]{literal, literal.getType()});
                                                        return None$.MODULE$;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Date literalValue = object;
        return new Some((Object)new Literal(literalValue, literalType));
    }

    @Override
    public Option<Expression> visitCall(RexCall call) {
        None$ none$;
        Buffer operands = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(call.getOperands()).map((Function1 & Serializable & scala.Serializable)operand -> (Expression)operand.accept(this).orNull(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom());
        if (operands.contains(null)) {
            none$ = None$.MODULE$;
        } else {
            Option<Expression> option;
            SqlOperator sqlOperator = call.getOperator();
            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.OR;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
                option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> new Or((PlannerExpression)l, (PlannerExpression)r)));
            } else {
                SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.AND;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> new And((PlannerExpression)l, (PlannerExpression)r)));
                } else if (sqlOperator instanceof SqlFunction) {
                    SqlFunction sqlFunction = (SqlFunction)sqlOperator;
                    option = this.lookupFunction(this.replace(sqlFunction.getName()), (Seq<Expression>)operands);
                } else if (sqlOperator instanceof SqlPostfixOperator) {
                    SqlPostfixOperator sqlPostfixOperator = (SqlPostfixOperator)sqlOperator;
                    option = this.lookupFunction(this.replace(sqlPostfixOperator.getName()), (Seq<Expression>)operands);
                } else {
                    option = this.lookupFunction(this.replace(String.valueOf((Object)sqlOperator.getKind())), (Seq<Expression>)operands);
                }
            }
            none$ = option;
        }
        return none$;
    }

    @Override
    public Option<Expression> visitFieldAccess(RexFieldAccess fieldAccess) {
        return None$.MODULE$;
    }

    @Override
    public Option<Expression> visitCorrelVariable(RexCorrelVariable correlVariable) {
        return None$.MODULE$;
    }

    @Override
    public Option<Expression> visitRangeRef(RexRangeRef rangeRef) {
        return None$.MODULE$;
    }

    @Override
    public Option<Expression> visitSubQuery(RexSubQuery subQuery) {
        return None$.MODULE$;
    }

    @Override
    public Option<Expression> visitDynamicParam(RexDynamicParam dynamicParam) {
        return None$.MODULE$;
    }

    @Override
    public Option<Expression> visitOver(RexOver over) {
        return None$.MODULE$;
    }

    @Override
    public Option<Expression> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return None$.MODULE$;
    }

    private Option<Expression> lookupFunction(String name, Seq<Expression> operands) {
        ExpressionBridge<PlannerExpression> expressionBridge = new ExpressionBridge<PlannerExpression>(PlannerExpressionConverter$.MODULE$.INSTANCE());
        return JavaScalaConversionUtil$.MODULE$.toScala(this.functionCatalog.lookupFunction(UnresolvedIdentifier.of(name))).flatMap((Function1 & Serializable & scala.Serializable)result -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (PlannerExpression)expressionBridge.bridge(ApiExpressionUtils.unresolvedCall(result.getFunctionDefinition(), (Expression[])operands.toArray(ClassTag$.MODULE$.apply(Expression.class))))).toOption());
    }

    private String replace(String str) {
        return str.replaceAll("\\s|_", "");
    }

    public RexNodeToExpressionConverter(String[] inputNames, FunctionCatalog functionCatalog) {
        this.inputNames = inputNames;
        this.functionCatalog = functionCatalog;
    }
}

