/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.Sink;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.util.UpdatingPlanChecker$;
import org.apache.flink.table.planner.DataStreamConversions$;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.DataStreamTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n'&t7N\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!\u0001B*j].\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u001b\u0011\u000bG/Y*ue\u0016\fWNU3m\u0011!Y\u0002A!A!\u0002\u0013a\u0012aB2mkN$XM\u001d\t\u0003;\u0005j\u0011A\b\u0006\u0003\u000f}Q!\u0001\t\u0007\u0002\u000f\r\fGnY5uK&\u0011!E\b\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003;\u0019J!a\n\u0010\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005A\u0011N\u001c9viJ+G\u000e\u0005\u0002,]5\tAF\u0003\u0002.?\u0005\u0019!/\u001a7\n\u0005=b#a\u0002*fY:{G-\u001a\u0005\nc\u0001\u0011\t\u0011)A\u0005e\u001d\u000bAa]5oWB\u00121g\u000f\t\u0004i]JT\"A\u001b\u000b\u0005YB\u0011!B:j].\u001c\u0018B\u0001\u001d6\u0005%!\u0016M\u00197f'&t7\u000e\u0005\u0002;w1\u0001A!\u0003\u001f1\u0003\u0003\u0005\tQ!\u0001>\u0005\ryF%M\t\u0003}\u0011\u0003\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013qAT8uQ&tw\r\u0005\u0002@\u000b&\u0011a\t\u0011\u0002\u0004\u0003:L\u0018BA\u0019\u0015\u0011%I\u0005A!A!\u0002\u0013QU+\u0001\u0005tS:\\g*Y7f!\tY%K\u0004\u0002M!B\u0011Q\nQ\u0007\u0002\u001d*\u0011q\nE\u0001\u0007yI|w\u000e\u001e \n\u0005E\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015!\n\u0005%#\u0002\"B,\u0001\t\u0003A\u0016A\u0002\u001fj]&$h\b\u0006\u0004Z5ncVL\u0019\t\u0003/\u0001AQa\u0007,A\u0002qAQ\u0001\n,A\u0002\u0015BQ!\u000b,A\u0002)BQ!\r,A\u0002y\u0003$aX1\u0011\u0007Q:\u0004\r\u0005\u0002;C\u0012IA(XA\u0001\u0002\u0003\u0015\t!\u0010\u0005\u0006\u0013Z\u0003\rA\u0013\u0005\u0006I\u0002!\t%Z\u0001\u0005G>\u0004\u0018\u0010F\u0002+M\u001eDQ\u0001J2A\u0002\u0015BQ\u0001[2A\u0002%\fa!\u001b8qkR\u001c\bc\u00016pU5\t1N\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]6\u0003\t1K7\u000f\u001e\u0005\u0006e\u0002!\te]\u0001\u0010iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]R\u0019A/a\u0003\u0011\u0007U\\X0D\u0001w\u0015\t\u0019qO\u0003\u0002ys\u0006\u0019\u0011\r]5\u000b\u0005iT\u0011!C:ue\u0016\fW.\u001b8h\u0013\tahO\u0001\u0006ECR\f7\u000b\u001e:fC6\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tQ\u0001^=qKNT1!!\u0002\t\u0003\u001d\u0011XO\u001c;j[\u0016L1!!\u0003\u0000\u0005\u0011\u0019%k\\<\t\u000f\u00055\u0011\u000f1\u0001\u0002\u0010\u00059\u0001\u000f\\1o]\u0016\u0014\b\u0003BA\t\u0003+i!!a\u0005\u000b\u0007\u00055\u0001\"\u0003\u0003\u0002\u0018\u0005M!!D*ue\u0016\fW\u000e\u00157b]:,'\u000fC\u0004\u0002\u001c\u0001!I!!\b\u0002\u0017]\u0014\u0018\u000e^3U_NKgn[\u000b\u0005\u0003?\tI\u0004\u0006\u0003\u0002\"\u0005]\u0002\u0007BA\u0012\u0003g\u0001b!!\n\u0002.\u0005ERBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0007\u0011\fwM\u0003\u0002y\u0015%!\u0011qFA\u0014\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u00042AOA\u001a\t-\t)$!\u0007\u0002\u0002\u0003\u0005)\u0011A\u001f\u0003\u0007}##\u0007\u0003\u0005\u0002\u000e\u0005e\u0001\u0019AA\b\t\u001d\tY$!\u0007C\u0002u\u0012\u0011\u0001\u0016\u0005\b\u0003\u007f\u0001A\u0011BA!\u0003I9(/\u001b;f)>\u0014V\r\u001e:bGR\u001c\u0016N\\6\u0016\t\u0005\r\u00131\f\u000b\u0007\u0003\u000b\n\t&!\u00181\t\u0005\u001d\u0013Q\n\t\u0006k\u0006%\u00131J\u0005\u0003\u0003Y\u00042AOA'\t-\ty%!\u0010\u0002\u0002\u0003\u0005)\u0011A\u001f\u0003\u0007}#3\u0007C\u00042\u0003{\u0001\r!a\u0015\u0011\u000bQ\n)&!\u0017\n\u0007\u0005]SG\u0001\fSKR\u0014\u0018m\u0019;TiJ,\u0017-\u001c+bE2,7+\u001b8l!\rQ\u00141\f\u0003\b\u0003w\tiD1\u0001>\u0011!\ti!!\u0010A\u0002\u0005=\u0001bBA1\u0001\u0011%\u00111M\u0001\u0012oJLG/\u001a+p\u0003B\u0004XM\u001c3TS:\\W\u0003BA3\u0003w\"b!a\u001a\u0002r\u0005u\u0004\u0007BA5\u0003[\u0002R!^A%\u0003W\u00022AOA7\t-\ty'a\u0018\u0002\u0002\u0003\u0005)\u0011A\u001f\u0003\u0007}#C\u0007C\u00042\u0003?\u0002\r!a\u001d\u0011\u000bQ\n)(!\u001f\n\u0007\u0005]TGA\u000bBaB,g\u000eZ*ue\u0016\fW\u000eV1cY\u0016\u001c\u0016N\\6\u0011\u0007i\nY\bB\u0004\u0002<\u0005}#\u0019A\u001f\t\u0011\u00055\u0011q\fa\u0001\u0003\u001fAq!!!\u0001\t\u0013\t\u0019)A\txe&$X\rV8VaN,'\u000f^*j].,B!!\"\u0002\u001cR1\u0011qQAI\u0003;\u0003D!!#\u0002\u000eB)Q/!\u0013\u0002\fB\u0019!(!$\u0005\u0017\u0005=\u0015qPA\u0001\u0002\u0003\u0015\t!\u0010\u0002\u0004?\u0012*\u0004bB\u0019\u0002\u0000\u0001\u0007\u00111\u0013\t\u0006i\u0005U\u0015\u0011T\u0005\u0004\u0003/+$!F+qg\u0016\u0014Ho\u0015;sK\u0006lG+\u00192mKNKgn\u001b\t\u0004u\u0005mEaBA\u001e\u0003\u007f\u0012\r!\u0010\u0005\t\u0003\u001b\ty\b1\u0001\u0002\u0010!9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0016a\u0004;sC:\u001cH.\u0019;f)>$\u0016\u0010]3\u0016\t\u0005\u0015\u00161\u0016\u000b\t\u0003O\u000by+!-\u0002<B!Qo_AU!\rQ\u00141\u0016\u0003\b\u0003[\u000byJ1\u0001>\u0005\u0005\t\u0005\u0002CA\u0007\u0003?\u0003\r!a\u0004\t\u0011\u0005M\u0016q\u0014a\u0001\u0003k\u000bab^5uQ\u000eC\u0017M\\4f\r2\fw\rE\u0002@\u0003oK1!!/A\u0005\u001d\u0011un\u001c7fC:D\u0001\"!0\u0002 \u0002\u0007\u0011qX\u0001\u0004iB,\u0007CBAa\u0003\u0017\fI+\u0004\u0002\u0002D*!\u0011QYAd\u0003!!\u0018\u0010]3j]\u001a|'\u0002BAe\u0003W\taaY8n[>t\u0017\u0002BAg\u0003\u0007\u0014q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\b\u0003#\u0004A\u0011BAj\u00039!(/\u00198tY\u0006$X-\u00138qkR,B!!6\u0002\\RQ\u0011q[Ao\u0003?\fi/!=\u0011\tU\\\u0018\u0011\u001c\t\u0004u\u0005mGaBAW\u0003\u001f\u0014\r!\u0010\u0005\t\u0003\u001b\ty\r1\u0001\u0002\u0010!A\u0011\u0011]Ah\u0001\u0004\t\u0019/A\u0007m_\u001eL7-\u00197TG\",W.\u0019\t\u0005\u0003K\fI/\u0004\u0002\u0002h*\u0011\u0001\u0010C\u0005\u0005\u0003W\f9OA\u0006UC\ndWmU2iK6\f\u0007\u0002CA_\u0003\u001f\u0004\r!a<\u0011\r\u0005\u0005\u00171ZAm\u0011!\t\u0019,a4A\u0002\u0005U\u0006bBA{\u0001\u0011%\u0011q_\u0001\u000fO\u0016$H+\u00192mKN\u001b\u0007.Z7b+\t\t\u0019\u000f")
public class DataStreamSink
extends Sink
implements DataStreamRel {
    private final RelOptCluster cluster;

    @Override
    public boolean needsUpdatesAsRetraction() {
        return DataStreamRel.needsUpdatesAsRetraction$(this);
    }

    @Override
    public boolean producesUpdates() {
        return DataStreamRel.producesUpdates$(this);
    }

    @Override
    public boolean consumesRetractions() {
        return DataStreamRel.consumesRetractions$(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel.producesRetractions$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataStreamSink(this.cluster, traitSet, inputs.get(0), super.sink(), super.sinkName());
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner) {
        Transformation<?> inputTransform = this.writeToSink(planner);
        return new DataStream(planner.getExecutionEnvironment(), inputTransform);
    }

    private <T> Transformation<?> writeToSink(StreamPlanner planner) {
        SinkTransformation sinkTransformation;
        TableSink<?> tableSink = super.sink();
        if (tableSink instanceof RetractStreamTableSink) {
            RetractStreamTableSink retractStreamTableSink = (RetractStreamTableSink)tableSink;
            org.apache.flink.streaming.api.datastream.DataStreamSink<?> resultSink = this.writeToRetractSink(retractStreamTableSink, planner);
            sinkTransformation = resultSink.getTransformation();
        } else if (tableSink instanceof UpsertStreamTableSink) {
            UpsertStreamTableSink upsertStreamTableSink = (UpsertStreamTableSink)tableSink;
            org.apache.flink.streaming.api.datastream.DataStreamSink<?> resultSink = this.writeToUpsertSink(upsertStreamTableSink, planner);
            sinkTransformation = resultSink.getTransformation();
        } else if (tableSink instanceof AppendStreamTableSink) {
            AppendStreamTableSink appendStreamTableSink = (AppendStreamTableSink)tableSink;
            org.apache.flink.streaming.api.datastream.DataStreamSink<?> resultSink = this.writeToAppendSink(appendStreamTableSink, planner);
            sinkTransformation = resultSink.getTransformation();
        } else if (tableSink instanceof DataStreamTableSink) {
            DataStreamTableSink dataStreamTableSink = (DataStreamTableSink)tableSink;
            if (!dataStreamTableSink.withChangeFlag() && !UpdatingPlanChecker$.MODULE$.isAppendOnly(this.getInput())) {
                throw new ValidationException("Table is not an append-only table. Use the toRetractStream() in order to handle add and retract messages.");
            }
            DataStream dataStream = this.translateInput(planner, this.getTableSchema(), dataStreamTableSink.getOutputType(), dataStreamTableSink.withChangeFlag());
            sinkTransformation = dataStream.getTransformation();
        } else {
            throw new ValidationException("Stream Tables can only be emitted by AppendStreamTableSink, RetractStreamTableSink, or UpsertStreamTableSink.");
        }
        return sinkTransformation;
    }

    private <T> org.apache.flink.streaming.api.datastream.DataStreamSink<?> writeToRetractSink(RetractStreamTableSink<T> sink, StreamPlanner planner) {
        TypeInformation<?> outputType = TypeConversions.fromDataTypeToLegacyInfo(sink.getConsumedDataType());
        DataStream<?> result = this.translateToType(planner, true, outputType);
        return sink.consumeDataStream(result);
    }

    private <T> org.apache.flink.streaming.api.datastream.DataStreamSink<?> writeToAppendSink(AppendStreamTableSink<T> sink, StreamPlanner planner) {
        if (!UpdatingPlanChecker$.MODULE$.isAppendOnly(this.getInput())) {
            throw new TableException("AppendStreamTableSink requires that Table has only insert changes.");
        }
        TypeInformation<?> outputType = TypeConversions.fromDataTypeToLegacyInfo(sink.getConsumedDataType());
        TableSchema resultType = this.getTableSchema();
        DataStream<?> result = this.translateInput(planner, resultType, outputType, false);
        return sink.consumeDataStream(result);
    }

    /*
     * Unable to fully structure code
     */
    private <T> org.apache.flink.streaming.api.datastream.DataStreamSink<?> writeToUpsertSink(UpsertStreamTableSink<T> sink, StreamPlanner planner) {
        block4: {
            block3: {
                isAppendOnlyTable = UpdatingPlanChecker$.MODULE$.isAppendOnly(this.getInput());
                sink.setIsAppendOnly(Predef$.MODULE$.boolean2Boolean(isAppendOnlyTable));
                sinkFieldNames = sink.getTableSchema().getFieldNames();
                tableKeys = UpdatingPlanChecker$.MODULE$.getUniqueKeyFields(this.getInput(), sinkFieldNames);
                var7_6 = false;
                var8_7 = null;
                var9_8 = tableKeys;
                if (!(var9_8 instanceof Some)) break block3;
                var10_9 = (Some)var9_8;
                keys = (String[])var10_9.value();
                sink.setKeyFields(keys);
                var3_11 = BoxedUnit.UNIT;
                break block4;
            }
            if (!None$.MODULE$.equals(var9_8)) ** GOTO lbl-1000
            var7_6 = true;
            var8_7 = var9_8;
            if (isAppendOnlyTable) {
                sink.setKeyFields(null);
                var3_12 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                if (var7_6 && !isAppendOnlyTable) {
                    throw new TableException("UpsertStreamTableSink requires that Table has full primary keys if it is updated.");
                }
                throw new MatchError(var9_8);
            }
        }
        outputType = TypeConversions.fromDataTypeToLegacyInfo(sink.getConsumedDataType());
        resultType = this.getTableSchema();
        result = this.translateInput(planner, resultType, outputType, true);
        return sink.consumeDataStream(result);
    }

    private <A> DataStream<A> translateToType(StreamPlanner planner, boolean withChangeFlag, TypeInformation<A> tpe) {
        TableSchema rowType = this.getTableSchema();
        if (!withChangeFlag && !UpdatingPlanChecker$.MODULE$.isAppendOnly(this.input)) {
            throw new ValidationException("Table is not an append-only table. Use the toRetractStream() in order to handle add and retract messages.");
        }
        return this.translateInput(planner, rowType, tpe, withChangeFlag);
    }

    private <A> DataStream<A> translateInput(StreamPlanner planner, TableSchema logicalSchema, TypeInformation<A> tpe, boolean withChangeFlag) {
        DataStream<CRow> dataStream = ((DataStreamRel)this.getInput()).translateToPlan(planner);
        return DataStreamConversions$.MODULE$.convert(dataStream, logicalSchema, withChangeFlag, tpe, planner.getConfig());
    }

    private TableSchema getTableSchema() {
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getInput().getRowType().getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getType(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toTypeInfo((RelDataType)relDataType), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeConversions.fromLegacyInfoToDataType(x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(super.sink().getTableSchema().getFieldNames(), fieldTypes).build();
    }

    public DataStreamSink(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, TableSink<?> sink, String sinkName) {
        this.cluster = cluster;
        super(cluster, traitSet, inputRel, sink, sinkName);
        FlinkRelNode.$init$(this);
        DataStreamRel.$init$(this);
    }
}

