/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.functions.python.utils.PythonFunctionUtils;

public class FunctionDefinitionUtil {
    public static FunctionDefinition createFunctionDefinition(String name, String className) {
        return FunctionDefinitionUtil.createJavaFunctionDefinition(name, className);
    }

    public static FunctionDefinition createFunctionDefinition(String name, String className, FunctionLanguage functionLanguage, ReadableConfig config) {
        if (functionLanguage == FunctionLanguage.PYTHON) {
            return FunctionDefinitionUtil.createFunctionDefinitionInternal(name, (UserDefinedFunction)((Object)PythonFunctionUtils.getPythonFunction(className, config)));
        }
        return FunctionDefinitionUtil.createJavaFunctionDefinition(name, className);
    }

    private static FunctionDefinition createJavaFunctionDefinition(String name, String className) {
        Object func;
        try {
            func = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(String.format("Failed instantiating '%s'", className), e);
        }
        return FunctionDefinitionUtil.createFunctionDefinitionInternal(name, (UserDefinedFunction)func);
    }

    private static FunctionDefinition createFunctionDefinitionInternal(String name, UserDefinedFunction udf) {
        if (udf instanceof ScalarFunction || udf instanceof TableFunction) {
            return udf;
        }
        if (udf instanceof AggregateFunction) {
            AggregateFunction a = (AggregateFunction)udf;
            return new AggregateFunctionDefinition(name, a, UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(a), UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(a));
        }
        if (udf instanceof TableAggregateFunction) {
            TableAggregateFunction a = (TableAggregateFunction)udf;
            return new TableAggregateFunctionDefinition(name, a, UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(a), UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(a));
        }
        throw new UnsupportedOperationException(String.format("Function %s should be of ScalarFunction, TableFunction, AggregateFunction, or TableAggregateFunction", udf.getClass().getName()));
    }
}

