/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public interface FileSystemFormatFactory
extends Factory {
    public InputFormat<RowData, ?> createReader(ReaderContext var1);

    public Optional<Encoder<RowData>> createEncoder(WriterContext var1);

    public Optional<BulkWriter.Factory<RowData>> createBulkWriterFactory(WriterContext var1);

    public static interface WriterContext {
        public TableSchema getSchema();

        public ReadableConfig getFormatOptions();

        public List<String> getPartitionKeys();

        default public String[] getFormatFieldNames() {
            return (String[])Arrays.stream(this.getSchema().getFieldNames()).filter(name -> !this.getPartitionKeys().contains(name)).toArray(String[]::new);
        }

        default public DataType[] getFormatFieldTypes() {
            return (DataType[])Arrays.stream(this.getSchema().getFieldNames()).filter(name -> !this.getPartitionKeys().contains(name)).map(name -> this.getSchema().getFieldDataType((String)name).get()).toArray(DataType[]::new);
        }

        default public RowType getFormatRowType() {
            return RowType.of((LogicalType[])Arrays.stream(this.getFormatFieldTypes()).map(DataType::getLogicalType).toArray(LogicalType[]::new), this.getFormatFieldNames());
        }
    }

    public static interface ReaderContext {
        public TableSchema getSchema();

        public ReadableConfig getFormatOptions();

        public List<String> getPartitionKeys();

        public String getDefaultPartName();

        public Path[] getPaths();

        public int[] getProjectFields();

        public long getPushedDownLimit();

        public List<Expression> getPushedDownFilters();

        default public String[] getFormatFieldNames() {
            return (String[])Arrays.stream(this.getSchema().getFieldNames()).filter(name -> !this.getPartitionKeys().contains(name)).toArray(String[]::new);
        }

        default public DataType[] getFormatFieldTypes() {
            return (DataType[])Arrays.stream(this.getSchema().getFieldNames()).filter(name -> !this.getPartitionKeys().contains(name)).map(name -> this.getSchema().getFieldDataType((String)name).get()).toArray(DataType[]::new);
        }

        default public RowType getFormatRowType() {
            return RowType.of((LogicalType[])Arrays.stream(this.getFormatFieldTypes()).map(DataType::getLogicalType).toArray(LogicalType[]::new), this.getFormatFieldNames());
        }

        default public List<String> getFormatProjectFields() {
            List selectFieldNames = Arrays.stream(this.getProjectFields()).mapToObj(i -> this.getSchema().getFieldNames()[i]).collect(Collectors.toList());
            return selectFieldNames.stream().filter(name -> !this.getPartitionKeys().contains(name)).collect(Collectors.toList());
        }
    }
}

