/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGeneratorSource;
import org.apache.flink.streaming.api.functions.source.datagen.RandomGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.SequenceGenerator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;

@PublicEvolving
public class DataGenTableSourceFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "datagen";
    public static final Long ROWS_PER_SECOND_DEFAULT_VALUE = 10000L;
    public static final ConfigOption<Long> ROWS_PER_SECOND = ConfigOptions.key((String)"rows-per-second").longType().defaultValue((Object)ROWS_PER_SECOND_DEFAULT_VALUE).withDescription("Rows per second to control the emit rate.");
    public static final String FIELDS = "fields";
    public static final String KIND = "kind";
    public static final String START = "start";
    public static final String END = "end";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String LENGTH = "length";
    public static final String SEQUENCE = "sequence";
    public static final String RANDOM = "random";

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(ROWS_PER_SECOND);
        return options;
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        Configuration options = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)options).setString(arg_0, arg_1));
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema(context.getCatalogTable().getSchema());
        DataGenerator[] fieldGenerators = new DataGenerator[tableSchema.getFieldCount()];
        for (int i = 0; i < fieldGenerators.length; ++i) {
            fieldGenerators[i] = this.createDataGenerator(tableSchema.getFieldName(i).get(), tableSchema.getFieldDataType(i).get(), (ReadableConfig)options);
        }
        return new DataGenTableSource(fieldGenerators, tableSchema, (Long)options.get(ROWS_PER_SECOND));
    }

    private DataGenerator createDataGenerator(String name, DataType type, ReadableConfig options) {
        String genType;
        switch (genType = (String)options.get(ConfigOptions.key((String)("fields." + name + "." + KIND)).stringType().defaultValue((Object)RANDOM))) {
            case "random": {
                return this.createRandomGenerator(name, type, options);
            }
            case "sequence": {
                return this.createSequenceGenerator(name, type, options);
            }
        }
        throw new ValidationException("Unsupported generator type: " + genType);
    }

    private DataGenerator createRandomGenerator(String name, DataType type, ReadableConfig options) {
        ConfigOption lenKey = ConfigOptions.key((String)("fields." + name + "." + LENGTH)).intType().defaultValue((Object)100);
        ConfigOptions.OptionBuilder minKey = ConfigOptions.key((String)("fields." + name + "." + MIN));
        ConfigOptions.OptionBuilder maxKey = ConfigOptions.key((String)("fields." + name + "." + MAX));
        switch (type.getLogicalType().getTypeRoot()) {
            case BOOLEAN: {
                return RandomGenerator.booleanGenerator();
            }
            case CHAR: 
            case VARCHAR: {
                int length = (Integer)options.get(lenKey);
                return DataGenTableSourceFactory.getRandomStringGenerator(length);
            }
            case TINYINT: {
                return RandomGenerator.byteGenerator((byte)((Integer)options.get(minKey.intType().defaultValue((Object)-128))).byteValue(), (byte)((Integer)options.get(maxKey.intType().defaultValue((Object)127))).byteValue());
            }
            case SMALLINT: {
                return RandomGenerator.shortGenerator((short)((Integer)options.get(minKey.intType().defaultValue((Object)Short.MIN_VALUE))).shortValue(), (short)((Integer)options.get(maxKey.intType().defaultValue((Object)Short.MAX_VALUE))).shortValue());
            }
            case INTEGER: {
                return RandomGenerator.intGenerator((int)((Integer)options.get(minKey.intType().defaultValue((Object)Integer.MIN_VALUE))), (int)((Integer)options.get(maxKey.intType().defaultValue((Object)Integer.MAX_VALUE))));
            }
            case BIGINT: {
                return RandomGenerator.longGenerator((long)((Long)options.get(minKey.longType().defaultValue((Object)Long.MIN_VALUE))), (long)((Long)options.get(maxKey.longType().defaultValue((Object)Long.MAX_VALUE))));
            }
            case FLOAT: {
                return RandomGenerator.floatGenerator((float)((Float)options.get(minKey.floatType().defaultValue((Object)Float.valueOf(Float.MIN_VALUE)))).floatValue(), (float)((Float)options.get(maxKey.floatType().defaultValue((Object)Float.valueOf(Float.MAX_VALUE)))).floatValue());
            }
            case DOUBLE: {
                return RandomGenerator.doubleGenerator((double)((Double)options.get(minKey.doubleType().defaultValue((Object)Double.MIN_VALUE))), (double)((Double)options.get(maxKey.doubleType().defaultValue((Object)Double.MAX_VALUE))));
            }
        }
        throw new ValidationException("Unsupported type: " + type);
    }

    private static RandomGenerator<StringData> getRandomStringGenerator(final int length) {
        return new RandomGenerator<StringData>(){

            public StringData next() {
                return StringData.fromString(this.random.nextHexString(length));
            }
        };
    }

    private DataGenerator createSequenceGenerator(String name, DataType type, ReadableConfig options) {
        String startKeyStr = "fields." + name + "." + START;
        String endKeyStr = "fields." + name + "." + END;
        ConfigOptions.OptionBuilder startKey = ConfigOptions.key((String)startKeyStr);
        ConfigOptions.OptionBuilder endKey = ConfigOptions.key((String)endKeyStr);
        options.getOptional(startKey.stringType().noDefaultValue()).orElseThrow(() -> new ValidationException("Could not find required property '" + startKeyStr + "' for sequence generator."));
        options.getOptional(endKey.stringType().noDefaultValue()).orElseThrow(() -> new ValidationException("Could not find required property '" + endKeyStr + "' for sequence generator."));
        switch (type.getLogicalType().getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return DataGenTableSourceFactory.getSequenceStringGenerator((Long)options.get(startKey.longType().noDefaultValue()), (Long)options.get(endKey.longType().noDefaultValue()));
            }
            case TINYINT: {
                return SequenceGenerator.byteGenerator((byte)((Integer)options.get(startKey.intType().noDefaultValue())).byteValue(), (byte)((Integer)options.get(endKey.intType().noDefaultValue())).byteValue());
            }
            case SMALLINT: {
                return SequenceGenerator.shortGenerator((short)((Integer)options.get(startKey.intType().noDefaultValue())).shortValue(), (short)((Integer)options.get(endKey.intType().noDefaultValue())).shortValue());
            }
            case INTEGER: {
                return SequenceGenerator.intGenerator((int)((Integer)options.get(startKey.intType().noDefaultValue())), (int)((Integer)options.get(endKey.intType().noDefaultValue())));
            }
            case BIGINT: {
                return SequenceGenerator.longGenerator((long)((Long)options.get(startKey.longType().noDefaultValue())), (long)((Long)options.get(endKey.longType().noDefaultValue())));
            }
            case FLOAT: {
                return SequenceGenerator.floatGenerator((short)((Integer)options.get(startKey.intType().noDefaultValue())).shortValue(), (short)((Integer)options.get(endKey.intType().noDefaultValue())).shortValue());
            }
            case DOUBLE: {
                return SequenceGenerator.doubleGenerator((int)((Integer)options.get(startKey.intType().noDefaultValue())), (int)((Integer)options.get(endKey.intType().noDefaultValue())));
            }
        }
        throw new ValidationException("Unsupported type: " + type);
    }

    private static SequenceGenerator<StringData> getSequenceStringGenerator(long start, long end) {
        return new SequenceGenerator<StringData>(start, end){

            public StringData next() {
                return StringData.fromString(((Long)this.valuesToEmit.poll()).toString());
            }
        };
    }

    private static class RowGenerator
    implements DataGenerator<RowData> {
        private static final long serialVersionUID = 1L;
        private final DataGenerator[] fieldGenerators;
        private final String[] fieldNames;

        private RowGenerator(DataGenerator[] fieldGenerators, String[] fieldNames) {
            this.fieldGenerators = fieldGenerators;
            this.fieldNames = fieldNames;
        }

        public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
            for (int i = 0; i < this.fieldGenerators.length; ++i) {
                this.fieldGenerators[i].open(this.fieldNames[i], context, runtimeContext);
            }
        }

        public void snapshotState(FunctionSnapshotContext context) throws Exception {
            for (DataGenerator generator : this.fieldGenerators) {
                generator.snapshotState(context);
            }
        }

        public boolean hasNext() {
            for (DataGenerator generator : this.fieldGenerators) {
                if (generator.hasNext()) continue;
                return false;
            }
            return true;
        }

        public RowData next() {
            GenericRowData row = new GenericRowData(this.fieldNames.length);
            for (int i = 0; i < this.fieldGenerators.length; ++i) {
                row.setField(i, this.fieldGenerators[i].next());
            }
            return row;
        }
    }

    static class DataGenTableSource
    implements ScanTableSource {
        private final DataGenerator[] fieldGenerators;
        private final TableSchema schema;
        private final long rowsPerSecond;

        private DataGenTableSource(DataGenerator[] fieldGenerators, TableSchema schema, long rowsPerSecond) {
            this.fieldGenerators = fieldGenerators;
            this.schema = schema;
            this.rowsPerSecond = rowsPerSecond;
        }

        @Override
        public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
            return SourceFunctionProvider.of(this.createSource(), false);
        }

        @VisibleForTesting
        DataGeneratorSource<RowData> createSource() {
            return new DataGeneratorSource((DataGenerator)new RowGenerator(this.fieldGenerators, this.schema.getFieldNames()), this.rowsPerSecond);
        }

        @Override
        public DynamicTableSource copy() {
            return new DataGenTableSource(this.fieldGenerators, this.schema, this.rowsPerSecond);
        }

        @Override
        public String asSummaryString() {
            return "DataGenTableSource";
        }

        @Override
        public ChangelogMode getChangelogMode() {
            return ChangelogMode.insertOnly();
        }
    }
}

