/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.expressions.LeafExpression;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ew!B\u0001\u0003\u0011\u0003i\u0011a\u0002'ji\u0016\u0014\u0018\r\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0002'ji\u0016\u0014\u0018\r\\\n\u0004\u001fIA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00069=!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035A\u0001bH\bC\u0002\u0013\u0005a\u0001I\u0001\u0004+R\u001bU#A\u0011\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\tAA+[7f5>tW\r\u0003\u0004+\u001f\u0001\u0006I!I\u0001\u0005+R\u001b\u0005\u0005\u0003\u0004-\u001f\u0011\u0005a!L\u0001\u0006CB\u0004H.\u001f\u000b\u0004]\u0005M\u0005C\u0001\b0\r\u0011\u0001\"\u0001\u0011\u0019\u0014\t=\nD\u0007\u0007\t\u0003\u001dIJ!a\r\u0002\u0003\u001d1+\u0017MZ#yaJ,7o]5p]B\u00111#N\u0005\u0003mQ\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u00059_\tU\r\u0011\"\u0001:\u0003\u00151\u0018\r\\;f+\u0005Q\u0004CA\n<\u0013\taDCA\u0002B]fD\u0001BP\u0018\u0003\u0012\u0003\u0006IAO\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\u0001{#Q3A\u0005\u0002\u0005\u000b!B]3tk2$H+\u001f9f+\u0005\u0011\u0005GA\"P!\r!5*T\u0007\u0002\u000b*\u0011aiR\u0001\tif\u0004X-\u001b8g_*\u0011\u0001*S\u0001\u0007G>lWn\u001c8\u000b\u0005)3\u0011aA1qS&\u0011A*\u0012\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]B\u0011aj\u0014\u0007\u0001\t%\u0001\u0016+!A\u0001\u0002\u000b\u00051KA\u0002`IEB\u0001BU\u0018\u0003\u0012\u0003\u0006IAQ\u0001\fe\u0016\u001cX\u000f\u001c;UsB,\u0007%\u0005\u0002UuA\u00111#V\u0005\u0003-R\u0011qAT8uQ&tw\rC\u0003\u001d_\u0011\u0005\u0001\fF\u0002/3jCQ\u0001O,A\u0002iBQ\u0001Q,A\u0002m\u0003$\u0001\u00180\u0011\u0007\u0011[U\f\u0005\u0002O=\u0012I\u0001KWA\u0001\u0002\u0003\u0015\ta\u0015\u0005\u0006A>\"\t%Y\u0001\ti>\u001cFO]5oOR\t!\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003KRi\u0011A\u001a\u0006\u0003O2\ta\u0001\u0010:p_Rt\u0014BA5\u0015\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%$\u0002B\u000280\t\u00032q.A\u0005u_J+\u0007PT8eKR\u0011\u0001\u000f\u001f\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f1A]3y\u0015\t)\b\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005]\u0014(a\u0002*fq:{G-\u001a\u0005\u0006s6\u0004\u001dA_\u0001\u000be\u0016d')^5mI\u0016\u0014\bCA>\u007f\u001b\u0005a(BA?u\u0003\u0015!xn\u001c7t\u0013\tyHP\u0001\u0006SK2\u0014U/\u001b7eKJDq!a\u00010\t\u0013\t)!A\bwC2,X-Q:DC2,g\u000eZ1s+\t\t9\u0001E\u0002#\u0003\u0013I1!a\u0003$\u0005!\u0019\u0015\r\\3oI\u0006\u0014\b\"CA\b_\u0005\u0005I\u0011AA\t\u0003\u0011\u0019w\u000e]=\u0015\u000b9\n\u0019\"!\u0006\t\u0011a\ni\u0001%AA\u0002iB\u0001\u0002QA\u0007!\u0003\u0005\ra\u0017\u0005\n\u00033y\u0013\u0013!C\u0001\u00037\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001e)\u001a!(a\b,\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000b\u0015\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\t)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\r0#\u0003%\t!!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0007\u0019\u0005\u0003s\ti\u0004\u0005\u0003E\u0017\u0006m\u0002c\u0001(\u0002>\u0011Q\u0001+!\r\u0002\u0002\u0003\u0005)\u0011A*\t\u0013\u0005\u0005s&!A\u0005B\u0005\r\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0015\nA\u0001\\1oO&\u00191.!\u0013\t\u0013\u0005Es&!A\u0005\u0002\u0005M\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\r\u0019\u0012qK\u0005\u0004\u00033\"\"aA%oi\"I\u0011QL\u0018\u0002\u0002\u0013\u0005\u0011qL\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rQ\u0014\u0011\r\u0005\u000b\u0003G\nY&!AA\u0002\u0005U\u0013a\u0001=%c!I\u0011qM\u0018\u0002\u0002\u0013\u0005\u0013\u0011N\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000e\t\u0006\u0003[\n\u0019HO\u0007\u0003\u0003_R1!!\u001d\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\nyG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tIhLA\u0001\n\u0003\tY(\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a!\u0011\u0007M\ty(C\u0002\u0002\u0002R\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002d\u0005]\u0014\u0011!a\u0001u!I\u0011qQ\u0018\u0002\u0002\u0013\u0005\u0013\u0011R\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u000b\u0005\n\u0003\u001b{\u0013\u0011!C!\u0003\u001f\u000ba!Z9vC2\u001cH\u0003BA?\u0003#C\u0011\"a\u0019\u0002\f\u0006\u0005\t\u0019\u0001\u001e\t\r\u0005U5\u00061\u0001;\u0003\u0005a\u0007\u0002\u0003\u0017\u0010\u0003\u0003%\t)!'\u0015\u000b9\nY*!(\t\ra\n9\n1\u0001;\u0011\u001d\u0001\u0015q\u0013a\u0001\u0003?\u0003D!!)\u0002&B!AiSAR!\rq\u0015Q\u0015\u0003\u000b!\u0006u\u0015\u0011!A\u0001\u0006\u0003\u0019\u0006\"CAU\u001f\u0005\u0005I\u0011QAV\u0003\u001d)h.\u00199qYf$B!!,\u0002BB)1#a,\u00024&\u0019\u0011\u0011\u0017\u000b\u0003\r=\u0003H/[8o!\u0019\u0019\u0012Q\u0017\u001e\u0002:&\u0019\u0011q\u0017\u000b\u0003\rQ+\b\u000f\\33a\u0011\tY,a0\u0011\t\u0011[\u0015Q\u0018\t\u0004\u001d\u0006}FA\u0003)\u0002(\u0006\u0005\t\u0011!B\u0001'\"I\u00111YAT\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\u0002\u0004\"CAd\u001f\u0005\u0005I\u0011BAe\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005-\u0007\u0003BA$\u0003\u001bLA!a4\u0002J\t1qJ\u00196fGR\u0004")
public class Literal
extends LeafExpression
implements Serializable {
    private final Object value;
    private final TypeInformation<?> resultType;

    public static Option<Tuple2<Object, TypeInformation<?>>> unapply(Literal literal) {
        return Literal$.MODULE$.unapply(literal);
    }

    public static Literal apply(Object object, TypeInformation<?> typeInformation) {
        return Literal$.MODULE$.apply(object, typeInformation);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public TypeInformation<?> resultType() {
        return this.resultType;
    }

    public String toString() {
        String string;
        TypeInformation<?> typeInformation = this.resultType();
        if (typeInformation instanceof BasicTypeInfo) {
            string = this.value().toString();
        } else {
            SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
            TypeInformation<?> typeInformation2 = typeInformation;
            if (!(sqlTimeTypeInfo != null ? !sqlTimeTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                string = new StringBuilder(7).append(this.value().toString()).append(".toDate").toString();
            } else {
                SqlTimeTypeInfo sqlTimeTypeInfo2 = SqlTimeTypeInfo.TIME;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (!(sqlTimeTypeInfo2 != null ? !sqlTimeTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                    string = new StringBuilder(7).append(this.value().toString()).append(".toTime").toString();
                } else {
                    SqlTimeTypeInfo sqlTimeTypeInfo3 = SqlTimeTypeInfo.TIMESTAMP;
                    TypeInformation<?> typeInformation4 = typeInformation;
                    if (!(sqlTimeTypeInfo3 != null ? !sqlTimeTypeInfo3.equals(typeInformation4) : typeInformation4 != null)) {
                        string = new StringBuilder(12).append(this.value().toString()).append(".toTimestamp").toString();
                    } else {
                        TimeIntervalTypeInfo<Long> timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MILLIS;
                        TypeInformation<?> typeInformation5 = typeInformation;
                        if (!(timeIntervalTypeInfo != null ? !((Object)timeIntervalTypeInfo).equals(typeInformation5) : typeInformation5 != null)) {
                            string = new StringBuilder(7).append(this.value().toString()).append(".millis").toString();
                        } else {
                            TimeIntervalTypeInfo<Integer> timeIntervalTypeInfo2 = TimeIntervalTypeInfo.INTERVAL_MONTHS;
                            TypeInformation<?> typeInformation6 = typeInformation;
                            string = !(timeIntervalTypeInfo2 != null ? !((Object)timeIntervalTypeInfo2).equals(typeInformation6) : typeInformation6 != null) ? new StringBuilder(7).append(this.value().toString()).append(".months").toString() : new StringBuilder(11).append("Literal(").append(this.value()).append(", ").append(this.resultType()).append(")").toString();
                        }
                    }
                }
            }
        }
        return string;
    }

    @Override
    public RexNode toRexNode(RelBuilder relBuilder) {
        RexNode rexNode;
        TypeInformation<?> typeInformation = this.resultType();
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
            BigDecimal bigDecValue = (BigDecimal)this.value();
            RelDataType decType = relBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL);
            rexNode = relBuilder.getRexBuilder().makeExactLiteral(bigDecValue, decType);
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.LONG_TYPE_INFO;
            TypeInformation<?> typeInformation3 = typeInformation;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                BigDecimal bigint = BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)this.value()));
                rexNode = relBuilder.getRexBuilder().makeBigintLiteral(bigint);
            } else {
                SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
                TypeInformation<?> typeInformation4 = typeInformation;
                if (!(sqlTimeTypeInfo != null ? !sqlTimeTypeInfo.equals(typeInformation4) : typeInformation4 != null)) {
                    DateString datestr = DateString.fromCalendarFields(this.valueAsCalendar());
                    rexNode = relBuilder.getRexBuilder().makeDateLiteral(datestr);
                } else {
                    SqlTimeTypeInfo sqlTimeTypeInfo2 = SqlTimeTypeInfo.TIME;
                    TypeInformation<?> typeInformation5 = typeInformation;
                    if (!(sqlTimeTypeInfo2 != null ? !sqlTimeTypeInfo2.equals(typeInformation5) : typeInformation5 != null)) {
                        TimeString timestr = TimeString.fromCalendarFields(this.valueAsCalendar());
                        rexNode = relBuilder.getRexBuilder().makeTimeLiteral(timestr, 0);
                    } else {
                        SqlTimeTypeInfo sqlTimeTypeInfo3 = SqlTimeTypeInfo.TIMESTAMP;
                        TypeInformation<?> typeInformation6 = typeInformation;
                        if (!(sqlTimeTypeInfo3 != null ? !sqlTimeTypeInfo3.equals(typeInformation6) : typeInformation6 != null)) {
                            TimestampString timestampstr = TimestampString.fromCalendarFields(this.valueAsCalendar());
                            rexNode = relBuilder.getRexBuilder().makeTimestampLiteral(timestampstr, 3);
                        } else {
                            TimeIntervalTypeInfo<Integer> timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MONTHS;
                            TypeInformation<?> typeInformation7 = typeInformation;
                            if (!(timeIntervalTypeInfo != null ? !((Object)timeIntervalTypeInfo).equals(typeInformation7) : typeInformation7 != null)) {
                                BigDecimal interval = BigDecimal.valueOf(BoxesRunTime.unboxToInt((Object)this.value()));
                                SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
                                rexNode = relBuilder.getRexBuilder().makeIntervalLiteral(interval, intervalQualifier);
                            } else {
                                TimeIntervalTypeInfo<Long> timeIntervalTypeInfo2 = TimeIntervalTypeInfo.INTERVAL_MILLIS;
                                TypeInformation<?> typeInformation8 = typeInformation;
                                if (!(timeIntervalTypeInfo2 != null ? !((Object)timeIntervalTypeInfo2).equals(typeInformation8) : typeInformation8 != null)) {
                                    BigDecimal interval = BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)this.value()));
                                    SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
                                    rexNode = relBuilder.getRexBuilder().makeIntervalLiteral(interval, intervalQualifier);
                                } else {
                                    rexNode = relBuilder.literal(this.value());
                                }
                            }
                        }
                    }
                }
            }
        }
        return rexNode;
    }

    /*
     * WARNING - void declaration
     */
    private Calendar valueAsCalendar() {
        void var2_2;
        Date date = (Date)this.value();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return var2_2;
    }

    public Literal copy(Object value, TypeInformation<?> resultType) {
        return new Literal(value, resultType);
    }

    public Object copy$default$1() {
        return this.value();
    }

    public TypeInformation<?> copy$default$2() {
        return this.resultType();
    }

    @Override
    public String productPrefix() {
        return "Literal";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TypeInformation<?> typeInformation;
        int n = x$1;
        switch (n) {
            case 0: {
                typeInformation = this.value();
                break;
            }
            case 1: {
                typeInformation = this.resultType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return typeInformation;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Literal;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Literal)) return false;
        boolean bl = true;
        if (!bl) return false;
        Literal literal = (Literal)x$1;
        if (!BoxesRunTime.equals((Object)this.value(), (Object)literal.value())) return false;
        TypeInformation<?> typeInformation = this.resultType();
        TypeInformation<?> typeInformation2 = literal.resultType();
        if (typeInformation == null) {
            if (typeInformation2 != null) {
                return false;
            }
        } else if (!typeInformation.equals(typeInformation2)) return false;
        if (!literal.canEqual(this)) return false;
        return true;
    }

    public Literal(Object value, TypeInformation<?> resultType) {
        this.value = value;
        this.resultType = resultType;
    }
}

