/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.Registration;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.descriptors.TableDescriptor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class ConnectTableDescriptor
extends TableDescriptor<ConnectTableDescriptor> {
    private final Registration registration;
    @Nullable
    private Schema schemaDescriptor;
    private List<String> partitionKeys = new ArrayList<String>();

    public ConnectTableDescriptor(Registration registration, ConnectorDescriptor connectorDescriptor) {
        super(connectorDescriptor);
        this.registration = registration;
    }

    public ConnectTableDescriptor withSchema(Schema schema) {
        this.schemaDescriptor = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this;
    }

    public ConnectTableDescriptor withPartitionKeys(List<String> partitionKeys) {
        this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"PartitionKeys must not be null.");
        return this;
    }

    public void createTemporaryTable(String path) {
        if (this.schemaDescriptor == null) {
            throw new TableException("Table schema must be explicitly defined. To derive schema from the underlying connector use registerTableSourceInternal/registerTableSinkInternal/registerTableSourceAndSink.");
        }
        this.registration.createTemporaryTable(path, CatalogTableImpl.fromProperties(this.toProperties()));
    }

    @Override
    protected Map<String, String> additionalProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        if (this.schemaDescriptor != null) {
            properties.putProperties(this.schemaDescriptor.toProperties());
        }
        properties.putPartitionKeys(this.partitionKeys);
        return properties.asMap();
    }
}

