/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite;

import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;

@Internal
public final class FlinkCalciteSqlValidator
extends SqlValidatorImpl {
    public FlinkCalciteSqlValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
        super(opTab, catalogReader, typeFactory, SqlConformanceEnum.DEFAULT);
    }

    @Override
    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        SqlNode condition;
        if (!(join.getJoinType() != JoinType.LEFT || SqlUtil.stripAs(join.getRight()).getKind() != SqlKind.COLLECTION_TABLE || (condition = join.getCondition()) == null || SqlUtil.isLiteral(condition) && ((SqlLiteral)condition).getValueAs(Boolean.class) == Boolean.TRUE)) {
            throw new ValidationException(String.format("Left outer joins with a table function do not accept a predicate such as %s. Only literal TRUE is accepted.", condition));
        }
        super.validateJoin(join, scope);
    }
}

