/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonRowDeserializationSchema;
import org.apache.flink.formats.json.JsonRowSchemaConverter;
import org.apache.flink.formats.json.JsonRowSerializationSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.JsonValidator;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;

public class JsonRowFormatFactory
extends TableFormatFactoryBase<Row>
implements SerializationSchemaFactory<Row>,
DeserializationSchemaFactory<Row> {
    public JsonRowFormatFactory() {
        super("json", 1, true);
    }

    protected List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.json-schema");
        properties.add("format.schema");
        properties.add("format.fail-on-missing-field");
        return properties;
    }

    public DeserializationSchema<Row> createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = JsonRowFormatFactory.getValidatedProperties(properties);
        JsonRowDeserializationSchema.Builder schema = new JsonRowDeserializationSchema.Builder(this.createTypeInformation(descriptorProperties));
        descriptorProperties.getOptionalBoolean("format.fail-on-missing-field").ifPresent(flag -> {
            if (flag.booleanValue()) {
                schema.failOnMissingField();
            }
        });
        descriptorProperties.getOptionalBoolean("format.ignore-parse-errors").ifPresent(flag -> {
            if (flag.booleanValue()) {
                schema.ignoreParseErrors();
            }
        });
        return schema.build();
    }

    public SerializationSchema<Row> createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = JsonRowFormatFactory.getValidatedProperties(properties);
        return new JsonRowSerializationSchema.Builder(this.createTypeInformation(descriptorProperties)).build();
    }

    private TypeInformation<Row> createTypeInformation(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return (RowTypeInfo)descriptorProperties.getType("format.schema");
        }
        if (descriptorProperties.containsKey("format.json-schema")) {
            return JsonRowSchemaConverter.convert(descriptorProperties.getString("format.json-schema"));
        }
        return JsonRowFormatFactory.deriveSchema((Map)descriptorProperties.asMap()).toRowType();
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> propertiesMap) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(propertiesMap);
        new JsonValidator().validate(descriptorProperties);
        return descriptorProperties;
    }
}

