/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.api.TableException;

public class JsonOptions {
    public static final ConfigOption<Boolean> FAIL_ON_MISSING_FIELD = ConfigOptions.key((String)"fail-on-missing-field").booleanType().defaultValue((Object)false).withDescription("Optional flag to specify whether to fail if a field is missing or not, false by default");
    public static final ConfigOption<Boolean> IGNORE_PARSE_ERRORS = ConfigOptions.key((String)"ignore-parse-errors").booleanType().defaultValue((Object)false).withDescription("Optional flag to skip fields and rows with parse errors instead of failing;\nfields are set to null in case of errors, false by default");
    public static final ConfigOption<String> TIMESTAMP_FORMAT = ConfigOptions.key((String)"timestamp-format.standard").stringType().defaultValue((Object)"SQL").withDescription("Optional flag to specify timestamp format, SQL by default. Option ISO-8601 will parse input timestamp in \"yyyy-MM-ddTHH:mm:ss.s{precision}\" format and output timestamp in the same format. Option SQL will parse input timestamp in \"yyyy-MM-dd HH:mm:ss.s{precision}\" format and output timestamp in the same format.");
    public static final String SQL = "SQL";
    public static final String ISO_8601 = "ISO-8601";
    public static final Set<String> TIMESTAMP_FORMAT_ENUM = new HashSet<String>(Arrays.asList("SQL", "ISO-8601"));

    public static TimestampFormat getTimestampFormat(ReadableConfig config) {
        String timestampFormat;
        switch (timestampFormat = (String)config.get(TIMESTAMP_FORMAT)) {
            case "SQL": {
                return TimestampFormat.SQL;
            }
            case "ISO-8601": {
                return TimestampFormat.ISO_8601;
            }
        }
        throw new TableException(String.format("Unsupported timestamp format '%s'. Validator should have checked that.", timestampFormat));
    }
}

