/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/reflection/DefinitionWithMetaData.as
 * org.apache.flex.reflection.DefinitionWithMetaData
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.reflection.DefinitionWithMetaData');

goog.require('org.apache.flex.reflection.DefinitionBase');
goog.require('org.apache.flex.reflection.MetaDataDefinition');
goog.require('org.apache.flex.reflection.getDefinitionByName');



/**
 * @constructor
 * @extends {org.apache.flex.reflection.DefinitionBase}
 * @param {string} name
 * @param {Object=} rawData
 */
org.apache.flex.reflection.DefinitionWithMetaData = function(name, rawData) {
  rawData = typeof rawData !== 'undefined' ? rawData : null;
  org.apache.flex.reflection.DefinitionWithMetaData.base(this, 'constructor', name, rawData);
};
goog.inherits(org.apache.flex.reflection.DefinitionWithMetaData, org.apache.flex.reflection.DefinitionBase);


Object.defineProperties(org.apache.flex.reflection.DefinitionWithMetaData.prototype, /** @lends {org.apache.flex.reflection.DefinitionWithMetaData.prototype} */ {
/** @export */
metadata: {
get: /** @this {org.apache.flex.reflection.DefinitionWithMetaData} */ function() {
  var /** @type {Array} */ results = [];
  
  var /** @type {*} */ rdata;
  var /** @type {Object} */ data = this.rawData;
  if (data.names !== undefined) {
    var /** @type {string} */ name = org.apache.flex.utils.Language.string(data.names[0].qName);
    var /** @type {Object} */ def = org.apache.flex.reflection.getDefinitionByName(name);
    rdata = def.prototype.FLEXJS_REFLECTION_INFO();
  }
  else
    rdata = data;
  if (rdata !== undefined && rdata.metadata !== undefined) {
    var /** @type {Array} */ metadatas = rdata.metadata();
    if (metadatas) {
      var /** @type {number} */ n = metadatas.length;
      var foreachiter0_target = metadatas;
      for (var foreachiter0 in foreachiter0_target) 
      {
      var mdDef = foreachiter0_target[foreachiter0];
      
        results.push(new org.apache.flex.reflection.MetaDataDefinition(mdDef.name, mdDef));}
      
    }
  }
  return results;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.reflection.DefinitionWithMetaData.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DefinitionWithMetaData', qName: 'org.apache.flex.reflection.DefinitionWithMetaData'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.reflection.DefinitionWithMetaData', org.apache.flex.reflection.DefinitionWithMetaData);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.reflection.DefinitionWithMetaData.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'metadata': { type: 'Array', declaredBy: 'org.apache.flex.reflection.DefinitionWithMetaData'}
      };
    },
    methods: function () {
      return {
        'DefinitionWithMetaData': { type: '', declaredBy: 'org.apache.flex.reflection.DefinitionWithMetaData'}
      };
    }
  };
};